/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.soap;

import com.trs.infra.I18NMessage;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;

public class CMySoapClient {
    private static Logger m_oLogger = Logger.getLogger(CMySoapClient.class);
    String m_sHost = "http://127.0.0.1:8000";
    String m_sUserName;
    String m_sPassword;
    String m_sURN = "urn:SoapExample";
    URL m_objURL = null;
    Service m_objService = null;
    boolean m_bKeepAlive = false;

    public CMySoapClient() {
        try {
            this.m_objService = new Service();
        }
        catch (Exception ex) {
            m_oLogger.error((Object)I18NMessage.get(CMySoapClient.class, "CMySoapClient.label1", "\u521b\u5efaService\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }

    public void setServer(String _sHost, String _sUserName, String _sPassword) {
        this.m_sHost = _sHost;
        this.m_sUserName = _sUserName;
        this.m_sPassword = _sPassword;
        try {
            this.m_objURL = new URL(this.m_sHost);
        }
        catch (Exception ex) {
            m_oLogger.error((Object)I18NMessage.get(CMySoapClient.class, "CMySoapClient.label2", "\u521d\u59cb\u5316URL\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }

    public void setKeepAlive(boolean _bKeepAlive) {
        this.m_bKeepAlive = _bKeepAlive;
    }

    public void setUrn(String _sUrn) {
        this.m_sURN = _sUrn;
    }

    public String getHost() {
        return this.m_objURL.getHost();
    }

    public int getPort() {
        return this.m_objURL.getPort();
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public String getPassWord() {
        return this.m_sPassword;
    }

    public String getUrn() {
        return this.m_sURN;
    }

    void setCommonCallProperty(Call _objCall) {
        _objCall.setTargetEndpointAddress(this.m_objURL);
        _objCall.setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        Hashtable<String, String> m_HttpHeader = new Hashtable<String, String>();
        m_HttpHeader.put(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
        if (this.m_bKeepAlive) {
            m_HttpHeader.put("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
        } else {
            m_HttpHeader.put("Connection", HTTPConstants.HEADER_CONNECTION_CLOSE);
        }
        _objCall.setProperty("HTTP-Request-Headers", m_HttpHeader);
        _objCall.setUsername(this.m_sUserName);
        _objCall.setPassword(this.m_sPassword);
    }

    synchronized Object remoteCall(Call _objCall, Object[] _objArray) throws RemoteException {
        Object _obj = null;
        _obj = _objCall.invoke(_objArray);
        return _obj;
    }

    Call getCall() throws ServiceException {
        Call _objCall = null;
        _objCall = (Call)this.m_objService.createCall();
        this.setCommonCallProperty(_objCall);
        return _objCall;
    }
}

