/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.common.WCMException;
import java.util.Map;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static String getProperty(Map _properties, String _sName) {
        if (_sName == null) {
            return null;
        }
        return (String)_properties.get(_sName.toUpperCase());
    }

    public static String getPropertyTrim(Map _properties, String _sName) {
        String sValue = PropertiesUtil.getProperty(_properties, _sName);
        return sValue == null ? null : sValue.trim();
    }

    public static String getRequiredProperty(Map _properties, String _sName) throws WCMException {
        String sValue = PropertiesUtil.getProperty(_properties, _sName);
        if (sValue == null || sValue.length() == 0) {
            throw new WCMException(1106, "Property [" + _sName + "] required!");
        }
        return sValue;
    }

    public static String getRequiredPropertyTrim(Map _properties, String _sName) throws WCMException {
        String sValue = PropertiesUtil.getPropertyTrim(_properties, _sName);
        if (sValue == null || sValue.length() == 0) {
            throw new WCMException(1106, "Property [" + _sName + "] required!");
        }
        return sValue;
    }

    public static int getIntProperty(Map _properties, String _sName, int _nDefault) throws WCMException {
        String sValue = PropertiesUtil.getPropertyTrim(_properties, _sName);
        if (sValue == null || sValue.length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, "Value [" + sValue + "] of property [" + _nDefault + "] is not integer!", ex);
        }
    }

    public static boolean getBooleanProperty(Map _properties, String _sName, boolean _bDefault) {
        String sValue = PropertiesUtil.getPropertyTrim(_properties, _sName);
        if (sValue == null || sValue.length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }
}

