/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMyXXEHelper {
    public static final String REG_INJECT_SQL_PRE = "(?i)((^|[^a-zA-Z]+)(";
    public static final String REG_INJECT_SQL_SUF = ")([^a-zA-Z]+|$))";
    private static final char[] CHARS_ALLOW = new char[]{'!', '<', '>'};

    public static void assertNoXXE(String sContent) {
        if (sContent == null || sContent.trim().length() == 0) {
            return;
        }
        boolean bFind = false;
        int length = sContent.length();
        for (int i = 0; i < length; ++i) {
            if (sContent.charAt(i) != '<') continue;
            int nextIndex = i + 1;
            char cTemp = sContent.charAt(nextIndex);
            while (!CMyXXEHelper.isValidChar(cTemp)) {
                cTemp = sContent.charAt(++nextIndex);
            }
            if (nextIndex >= length) break;
            if (cTemp != '!') continue;
            int closeTagIndex = sContent.indexOf(62, nextIndex + 1);
            if (closeTagIndex == -1) break;
            String sRange = sContent.substring(nextIndex + 1, closeTagIndex);
            if (CMyXXEHelper.containsXXEKeyWord(sRange, "entity")) {
                bFind = true;
                break;
            }
            if (!CMyXXEHelper.containsXXEKeyWord(sRange, "doctype|entity")) continue;
            if (CMyXXEHelper.containsXXEKeyWord(sRange, "public|system")) {
                bFind = true;
                break;
            }
            i = closeTagIndex;
        }
        if (bFind) {
            throw new RuntimeException("input string cannot contain <!doctype or <!entity flag, only for xxe sercurity");
        }
    }

    private static boolean isValidChar(char _cValue) {
        for (char c : CHARS_ALLOW) {
            if (c != _cValue) continue;
            return true;
        }
        if (_cValue >= '0' && _cValue <= '9') {
            return true;
        }
        if (_cValue >= 'a' && _cValue <= 'z') {
            return true;
        }
        return _cValue >= 'A' && _cValue <= 'Z';
    }

    public static void assertNoXXEWithFile(String sFilePath) throws Exception {
        byte[] aContent = CMyXXEHelper.readBytesFromFile(sFilePath);
        CMyXXEHelper.assertNoXXE(new String(aContent));
    }

    public static final boolean containsXXEKeyWord(String _sContext, String _sKeyWords) {
        if (_sContext == null || _sContext.trim().length() == 0) {
            return false;
        }
        Pattern oPattern = Pattern.compile(REG_INJECT_SQL_PRE + _sKeyWords + REG_INJECT_SQL_SUF);
        Matcher oMatcher = oPattern.matcher(_sContext);
        return oMatcher.find();
    }

    public static byte[] readBytesFromFile(String _sFileName) throws Exception {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(_sFileName);
            byte[] buffer = new byte[1024];
            bos = new ByteArrayOutputStream(2048);
            int nLen = 0;
            while ((nLen = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, nLen);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new Exception("\u8bfb\u53d6\u6587\u4ef6[" + _sFileName + "]\u5931\u8d25\uff01");
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        try {
            String[] pContent = new String[]{"<!DOCTYPE root SYSTEM \"http://192.168.51.41:81/linux.xml\">", "<" + URLDecoder.decode("%00", "UTF-8") + "!DOCTYPE root SYSTEM \"http://192.168.51.41:81/linux.xml\">"};
            int i = 0;
            for (String sContent : pContent) {
                try {
                    System.out.println(i++);
                    System.out.println(sContent);
                    CMyXXEHelper.assertNoXXE(sContent);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        catch (Exception e) {
            System.err.println("decode error!");
            e.printStackTrace();
        }
    }
}

