/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.domain.PreNextDocumentsImpl;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.util.HashMap;
import java.util.Map;

public class ChnlDocLCListenerForPreNextPage
implements IObjectLCListenerOnModify {
    private static final Map MOVED_DOCS = new HashMap(32);

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (this.notChnlDocMoved(_oObjModified)) {
            return;
        }
        if (ContextParameters.get(0, true) == Boolean.TRUE) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)_oObjModified;
        if (chnlDoc.getModal() == 2 || MetaDataConstants.PubStatusEnum.PUBLISHED.value != chnlDoc.getPubStatus()) {
            return;
        }
        if (_nEventType == 5) {
            Documents nextDocs;
            PreNextDocumentsImpl preNextDocs = new PreNextDocumentsImpl();
            Documents[] docs = preNextDocs.getPreNextDocuments(chnlDoc.getChannel(), chnlDoc.getDocument(), 1, null);
            if (docs == null || docs.length == 0) {
                return;
            }
            Documents preDocs = docs[0];
            int[] pDocId = new int[2];
            if (!preDocs.isEmpty()) {
                Document doc = (Document)preDocs.getAt(0);
                if (doc != null) {
                    pDocId[0] = doc.getId();
                }
                preDocs.clear();
            }
            if (!(nextDocs = docs[1]).isEmpty()) {
                Document doc = (Document)nextDocs.getAt(0);
                if (doc != null) {
                    pDocId[1] = doc.getId();
                }
                nextDocs.clear();
            }
            MOVED_DOCS.put(chnlDoc.getKey(), pDocId);
        } else {
            int[] pDocId = (int[])MOVED_DOCS.remove(chnlDoc.getKey());
            if (pDocId == null) {
                return;
            }
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(chnlDoc.getChannel());
            PublishServer publishServer = PublishServer.getInstance();
            for (int nDocId : pDocId) {
                if (nDocId == 0) continue;
                Document document = Document.findById(nDocId, "DocId,DocTitle,DocChannel,DocStatus");
                IPublishContent content = PublishElementFactory.makeContentFrom(document, folder);
                boolean bCanDoPub = 10 == document.getStatusId();
                try {
                    bCanDoPub = bCanDoPub && content.validateCanDoPub();
                }
                catch (Exception e) {
                    bCanDoPub = false;
                }
                if (!bCanDoPub) continue;
                publishServer.publishContent(content, 8);
            }
        }
    }

    private boolean notChnlDocMoved(BaseObj _oObjModified) {
        return _oObjModified.getWCMType() != 614 || !_oObjModified.isChangeProperty("CHNLID");
    }
}

