/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.apache.log4j.Logger;

public class QueryDocumentCenter {
    private static Logger logger = Logger.getLogger(QueryDocumentCenter.class);

    public static Documents queryDocumentsOfCurrPage(WCMFilter _filter, String _sSelectFieldsOfDocument, int _nPageIndex, int _nPageSize) throws WCMException {
        int nCount;
        DBManager dbManager = DBManager.getDBManager();
        String sQueryCountSQL = "select count(" + _filter.getSelect() + ") from " + _filter.getFrom();
        if (!CMyString.isEmpty(_filter.getWhere())) {
            sQueryCountSQL = sQueryCountSQL + " where " + _filter.getWhere();
        }
        if ((nCount = dbManager.sqlExecuteIntQuery(sQueryCountSQL, _filter.getSearchValues())) <= 0) {
            return new Documents(null);
        }
        CPager pager = new CPager(_nPageSize);
        pager.setItemCount(nCount);
        pager.setCurrentPageIndex(_nPageIndex);
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(_filter.toSQL());
            oPreStmt.setFetchSize(_nPageSize);
            DBManager.setParameters(oPreStmt, _filter);
            result = oPreStmt.executeQuery();
            Documents documents = new Documents(null, _nPageSize, 2);
            documents.setRecCount(nCount);
            int nCurrIndex = 0;
            int nCurrPageCount = 0;
            while (result.next()) {
                int nDocId;
                Document document;
                if (++nCurrIndex < pager.getFirstItemIndex() || (document = Document.findById(nDocId = result.getInt("DOCID"), _sSelectFieldsOfDocument)) == null) continue;
                documents.addElement(document);
                if (++nCurrPageCount <= _nPageSize) continue;
                break;
            }
            Documents documents2 = documents;
            return documents2;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public static Documents queryDocumentsForUser(User _currUser, BaseChannel _oChannelOrSite, String _sSelectFieldsOfDocument, int _nPageIndex, int _nPageSize, boolean _bContainsChildren, WCMFilter _filter) throws WCMException {
        Channels oQueryChannels = null;
        StringBuffer sbWhere = new StringBuffer();
        if (_oChannelOrSite.isSite() && _currUser.isAdministrator()) {
            sbWhere.append("exists(select 1 from WCMChannel b where b.SiteId=? and b.ChannelId=WCMUserDoc.ChnlId)");
        } else if (_oChannelOrSite.isSite() || _bContainsChildren) {
            oQueryChannels = new Channels(null);
            QueryDocumentCenter.makeChannelsWithRightOfChannel(_currUser, _oChannelOrSite, 30, oQueryChannels);
            if (oQueryChannels.isEmpty()) {
                throw new WCMException("\u60a8\u6ca1\u6709\u53ef\u4ee5\u6d4f\u89c8\u6587\u6863\u7684\u680f\u76ee\uff01" + _currUser);
            }
            sbWhere.append("ChnlId in(");
            int nSize = oQueryChannels.size();
            for (int i = 0; i < nSize; ++i) {
                sbWhere.append("?,");
            }
            sbWhere.setLength(sbWhere.length() - 1);
            sbWhere.append(")");
        } else {
            sbWhere.append("ChnlId=?");
        }
        sbWhere.append(" and (");
        sbWhere.append("(OprId=0 and DocLevel<=?)");
        sbWhere.append(" or (OprType=204 and OprId=?)");
        Groups groups = _currUser.getGroups();
        if (groups != null && !groups.isEmpty()) {
            sbWhere.append(" or (OprType=201 and OprId in(" + groups.getIdListAsString() + ")");
            sbWhere.append(")");
        }
        sbWhere.append(")");
        WCMFilter filter = new WCMFilter("WCMUserDoc", sbWhere.toString(), "WCMUserDoc.DocId desc", "distinct WCMUserDoc.docid");
        String sDocLevel = _currUser.getAttributeValue("DocLevel");
        int nDocLevel = 0;
        if (!CMyString.isEmpty(sDocLevel)) {
            nDocLevel = Integer.parseInt(sDocLevel);
        }
        if (oQueryChannels == null) {
            filter.addSearchValues(_oChannelOrSite.getId());
        } else {
            int nSize = oQueryChannels.size();
            for (int i = 0; i < nSize; ++i) {
                filter.addSearchValues(oQueryChannels.getIdAt(i));
            }
        }
        filter.addSearchValues(nDocLevel);
        filter.addSearchValues(_currUser.getId());
        filter.mergeWith(_filter);
        return QueryDocumentCenter.queryDocumentsOfCurrPage(filter, _sSelectFieldsOfDocument, _nPageIndex, _nPageSize);
    }

    public static Documents queryDocumentsForUser(User _currUser, int _nChannelId, String _sSelectFieldsOfDocument, int _nPageIndex, int _nPageSize) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        if (channel == null) {
            throw new WCMException("\u6307\u5b9a\u680f\u76ee\u4e0d\u5b58\u5728\uff01[ChannelId=" + _nChannelId + "]");
        }
        return QueryDocumentCenter.queryDocumentsForUser(_currUser, channel, _sSelectFieldsOfDocument, _nPageIndex, _nPageSize, false, null);
    }

    private static Channels makeChannelsWithRightOfChannel(User _loginUser, BaseChannel _oCurrChannel, int _nRightIndex, Channels _oRecordChannels) throws WCMException {
        if (_oCurrChannel == null) {
            return _oRecordChannels;
        }
        List<Channel> lChildren = _oCurrChannel.getChildren(null);
        boolean bSuperManOnTheChannel = _loginUser.getName().equals(_oCurrChannel.getCrUserName());
        RightValue rightValue = new RightValue();
        if (!bSuperManOnTheChannel) {
            rightValue = AuthServer.getRightValue((CMSObj)_oCurrChannel, _loginUser);
        }
        if (lChildren == null || lChildren.isEmpty()) {
            if (!_oCurrChannel.isSite() && rightValue.isHasRight(_nRightIndex)) {
                _oRecordChannels.addElement(_oCurrChannel);
            }
            return _oRecordChannels;
        }
        if (!bSuperManOnTheChannel && rightValue.getValue() <= 0L) {
            return _oRecordChannels;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; --i) {
            QueryDocumentCenter.makeChannelsWithRightOfChannel(_loginUser, lChildren.get(i), _nRightIndex, _oRecordChannels);
        }
        return _oRecordChannels;
    }
}

