/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat.tool;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StatPageGener {
    private static final Logger LOG = Logger.getLogger(StatPageGener.class);
    private static final String[] PAGES = new String[]{"barchart.jsp", "barchartdata.jsp", "piechart.jsp", "piechartdata.jsp", "stat_include.jsp", "stat_common.js", "datatable.jsp", "stat_export.jsp", "trendchart.jsp", "trendchartdata.jsp"};
    private String srcDir;
    private String prefix;
    private String prefixDesc;
    private String statSQL;
    private String destDir;
    private FileService destFileDir;

    public final String getSrcDir() {
        return this.srcDir;
    }

    public final void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public final String getPrefixDesc() {
        return this.prefixDesc;
    }

    public final void setPrefixDesc(String prefixDesc) {
        this.prefixDesc = prefixDesc;
    }

    public final String getStatSQL() {
        return this.statSQL;
    }

    public final void setStatSQL(String statSQL) {
        this.statSQL = statSQL;
    }

    public final String getDestDir() {
        return this.destDir;
    }

    public final void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public void makePages() {
        this.destFileDir = new FileService(this.srcDir, this.destDir);
        this.destFileDir.mkdir();
        FileService templates = new FileService(this.srcDir, "template");
        final HashSet special = new HashSet(PAGES.length);
        Collections.addAll(special, PAGES);
        templates.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                if (special.contains(pathname.getName())) {
                    StatPageGener.this.modifyAndCopy(pathname);
                } else {
                    StatPageGener.this.copy(pathname);
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyAndCopy(FileStore pathname) {
        InputStream fins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        OutputStream fos = null;
        PrintWriter writer = null;
        OutputStreamWriter osw = null;
        try {
            fins = pathname.getInputStream();
            insr = new InputStreamReader(fins, "utf-8");
            reader = new BufferedReader(insr);
            String prefix = this.getPrefix();
            String prefixDesc = this.getPrefixDesc();
            String sql = this.getStatSQL();
            String filename = prefix + "_" + pathname.getName();
            fos = new FileService(this.destFileDir, filename).getOutputStream();
            osw = new OutputStreamWriter(fos, "utf-8");
            writer = new PrintWriter(osw);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String var = "#PREFIX#";
                if (line.indexOf(var) != -1) {
                    line = CMyString.replaceStr(line, var, prefix);
                }
                if (line.indexOf(var = "#PREFIX_DESC#") != -1) {
                    line = CMyString.replaceStr(line, var, prefixDesc);
                }
                if (line.indexOf(var = "#STAT_SQL#") != -1) {
                    line = CMyString.replaceStr(line, var, sql);
                }
                writer.println(line);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to modify and copy file: " + pathname), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(FileStore pathname) {
        InputStream fins = null;
        OutputStream fos = null;
        try {
            fins = pathname.getInputStream();
            String prefix = this.getPrefix();
            String filename = prefix + "_" + pathname.getName();
            fos = new FileService(this.destFileDir, filename).getOutputStream();
            byte[] buff = new byte[10240];
            int len = -1;
            while ((len = fins.read(buff)) != -1) {
                fos.write(buff, 0, len);
            }
            fos.flush();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to copy file: " + pathname), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        StatPageGener gener = new StatPageGener();
        gener.setSrcDir("D:/wcmteam_newrepo/TRS.WCM.V6.1.Std/SourceCode/WebApp/app/stat/doc_stat");
        gener.setDestDir("sitesource");
        gener.setPrefix("sitesource");
        gener.setPrefixDesc("\u6587\u6863\u6765\u6e90");
        gener.setStatSQL("/*test sql*/");
        gener.makePages();
        Class<StatPageGener> clazz = StatPageGener.class;
        for (Method method : clazz.getMethods()) {
            String name;
            if (!Modifier.isPublic(method.getModifiers()) || !(name = method.getName()).startsWith("get")) continue;
            try {
                method.invoke(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

