/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.ObjToXmlConverterByDOM4j;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import com.trs.infra.util.jazzlib.ZipEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MasterMgr
implements IMasterMgr {
    private static Logger s_logger = Logger.getLogger(MasterMgr.class);
    private static XmlToObjConverter m_converter = new XmlToObjConverter(1);
    private Reports m_importReports;

    private void registerConverter() {
        m_converter.registPersistentObj("XWCMMASTER", Master.class);
    }

    @Override
    public Master save(User _oUser, String _sMasterName, String _sFileName) throws WCMException {
        Master master;
        WCMFilter filter = new WCMFilter("", "MName=?", "", "");
        filter.addSearchValues(_sMasterName);
        Masters masters = Masters.openWCMObjs(_oUser, filter);
        if (masters.isEmpty()) {
            master = Master.createNewInstance();
        } else {
            master = (Master)masters.getAt(0);
            if (master == null) {
                master = Master.createNewInstance();
            }
        }
        String sValidRusult = this.validateMasterFile(_sFileName);
        if (!CMyString.isEmpty(sValidRusult)) {
            throw new WCMException(sValidRusult);
        }
        String sNewFileName = this.copyFileIfNeed(_sFileName, false);
        if (master.isAddMode()) {
            master.setMName(_sMasterName);
            String sPicFileName = master.getPicFileName();
            if (CMyString.isEmpty(sPicFileName)) {
                master.setPicFileName("0");
            } else {
                master.setPicFileName(this.copyFileIfNeed(sPicFileName, false));
            }
        }
        master.setFileName(sNewFileName);
        master.save(_oUser);
        return master;
    }

    private String copyFileIfNeed(String _sFile, boolean _isPath) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!_isPath) {
            String sFileFlag = filesMan.getFileFlag(_sFile);
            String sNewFileName = _sFile;
            if (sFileFlag != "W0") {
                sNewFileName = filesMan.copyWCMFile(_sFile, "W0");
            }
            return sNewFileName;
        }
        return CMyFile.extractFileName(filesMan.copyFile(_sFile, "W0", true));
    }

    @Override
    public Master save(User _oUser, Master _oMaster) throws WCMException {
        if (_oMaster == null) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label1", "\u9700\u8981\u4fdd\u5b58\u7684\u6bcd\u677f\u4e3a\u7a7a\uff01"));
        }
        String sMasterFileName = _oMaster.getFinalPropertyAsString("FILENAME");
        String sValidRusult = this.validateMasterFile(sMasterFileName, _oMaster.getMasterType());
        if (!CMyString.isEmpty(sValidRusult)) {
            throw new WCMException(sValidRusult);
        }
        String sFileName = this.copyFileIfNeed(sMasterFileName, false);
        if (_oMaster.isAddMode()) {
            String sPicFileName = _oMaster.getPicFileName();
            if (!CMyString.isEmpty(sPicFileName)) {
                _oMaster.setPicFileName(this.copyFileIfNeed(sPicFileName, false));
            } else {
                _oMaster.setPicFileName("0");
            }
        } else if (_oMaster.isChangeProperty("PicFileName")) {
            String sNewPic = (String)_oMaster.getNewProperty("PicFileName");
            if (CMyString.isEmpty(sNewPic)) {
                _oMaster.setPicFileName("0");
            } else {
                _oMaster.setPicFileName(this.copyFileIfNeed(sNewPic, false));
            }
        }
        _oMaster.setFileName(sFileName);
        _oMaster.save(_oUser);
        return _oMaster;
    }

    @Override
    public boolean delete(User _oCurrUser, Masters _oMasters) throws WCMException {
        if (_oMasters == null) {
            return true;
        }
        for (int i = 0; i < _oMasters.size(); ++i) {
            Master currMaster = (Master)_oMasters.getAt(i);
            if (currMaster == null) continue;
            String sFileName = currMaster.getFileName();
            currMaster.delete(_oCurrUser);
            FilesMan filesMan = FilesMan.getFilesMan();
            String sFilePath = filesMan.mapFilePath(sFileName, 0);
            CMyFile.deleteFile(sFilePath + sFileName);
            String sPicFile = currMaster.getPicFileName();
            if (CMyString.isEmpty(sPicFile) || sPicFile.equals("0")) continue;
            CMyFile.deleteFile(filesMan.mapFilePath(sPicFile, 0) + sPicFile);
        }
        return true;
    }

    @Override
    public String export(Masters _oMasters) throws WCMException {
        if (_oMasters == null) {
            return null;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sPath = filesMan.getNextFilePathName("ST", "zip");
        CMyZip myZip = new CMyZip();
        try {
            myZip.setZipFileName(sPath);
        }
        catch (CMyException e) {
            throw new WCMException("\u521b\u5efazip\u6587\u4ef6\u5931\u8d25", e);
        }
        String sXMLFile = "";
        ObjToXmlConverterByDOM4j oObjToXmlConverterByDOM4j = new ObjToXmlConverterByDOM4j();
        for (int i = 0; i < _oMasters.size(); ++i) {
            Master currMaster = (Master)_oMasters.getAt(i);
            if (currMaster == null) continue;
            try {
                sXMLFile = filesMan.getNextFileName("ST", "xml", null, true);
                oObjToXmlConverterByDOM4j.toXMLFile(currMaster, sXMLFile);
                myZip.addToZip(sXMLFile, false);
                String sMasterFile = currMaster.getFileName();
                String sMasterFilePath = filesMan.mapFilePath(sMasterFile, 0);
                myZip.addToZip(sMasterFilePath + sMasterFile, false);
                String sPicFile = currMaster.getPicFileName();
                if (CMyString.isEmpty(sPicFile) || sPicFile.equals("0")) continue;
                if (!CMyFile.fileExists(sPicFile = filesMan.mapFilePath(sPicFile, 0) + sPicFile)) {
                    s_logger.info((Object)("\u627e\u4e0d\u5230\u6bcd\u677f\u7f29\u7565\u56fe\uff1a" + sPicFile));
                    continue;
                }
                myZip.addToZip(sPicFile, false);
                continue;
            }
            catch (CMyException e) {
                throw new WCMException("\u6dfb\u52a0\u6bcd\u677f\u76f8\u5173\u8d44\u6e90\u5230zip\u6587\u4ef6\u5931\u8d25", e);
            }
            finally {
                try {
                    filesMan.deleteFile(sXMLFile);
                }
                catch (Exception ex) {
                    s_logger.error((Object)"\u5220\u9664\u539f\u6bcd\u677f\u7f29\u7565\u56fe\u65f6\u51fa\u9519", (Throwable)ex);
                }
            }
        }
        try {
            boolean bDone = myZip.done();
            if (bDone) {
                return CMyFile.extractFileName(sPath);
            }
            return null;
        }
        catch (CMyException e) {
            throw new WCMException("\u5bfc\u51fa\u6bcd\u677f\u65f6\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    @Override
    public Reports importMasters(User _oCurrUser, String _sImportMastersFileName) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(_sImportMastersFileName)) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u6587\u4ef6\u540d\u4e3a\u7a7a"));
        }
        String sFileExt = CMyFile.extractFileExt(_sImportMastersFileName);
        if (!sFileExt.equalsIgnoreCase("zip")) {
            throw new WCMException(1200, I18NMessage.get(MasterMgr.class, "MasterMgr.label4", "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6"));
        }
        String sPath = this.getFullFileName(_sImportMastersFileName);
        String sUnZipFilePath = CMyFile.extractFilePath(sPath);
        sUnZipFilePath = sUnZipFilePath + CMyFile.extractMainFileName(sPath) + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(sPath, sUnZipFilePath);
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
        }
        catch (Exception e) {
            throw new WCMException("\u89e3\u538b\u6587\u4ef6\u5931\u8d25", e);
        }
        this.registerConverter();
        ArrayList allXMLFiles = uzf.getFilteredFiles();
        if (allXMLFiles == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u6bcd\u677f\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String sXmlFile = null;
        XmlObject[] xmlObjs = null;
        for (int i = 0; i < allXMLFiles.size(); ++i) {
            sXmlFile = (String)allXMLFiles.get(i);
            xmlObjs = m_converter.convertXml(sXmlFile, null, null);
            this.importMasters(xmlObjs, sUnZipFilePath, 3);
        }
        CMyFile.deleteDir(sUnZipFilePath);
        this.m_importReports.setTitle("\u5bfc\u5165\u6bcd\u677f\u6587\u4ef6");
        return this.m_importReports;
    }

    @Override
    public Reports importMasters(User _oCurrUser, String _sImportMastersFileName, int _nImportMode) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(_sImportMastersFileName)) {
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u6587\u4ef6\u540d\u4e3a\u7a7a"));
        }
        String sFileExt = CMyFile.extractFileExt(_sImportMastersFileName);
        if (!sFileExt.equalsIgnoreCase("zip")) {
            throw new WCMException(1200, I18NMessage.get(MasterMgr.class, "MasterMgr.label4", "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6"));
        }
        String sPath = this.getFullFileName(_sImportMastersFileName);
        String sUnZipFilePath = CMyFile.extractFilePath(sPath);
        sUnZipFilePath = sUnZipFilePath + CMyFile.extractMainFileName(sPath) + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(sPath, sUnZipFilePath);
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
        }
        catch (Exception e) {
            throw new WCMException("\u89e3\u538b\u6587\u4ef6\u5931\u8d25", e);
        }
        this.registerConverter();
        ArrayList allXMLFiles = uzf.getFilteredFiles();
        if (allXMLFiles == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u6bcd\u677f\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String sXmlFile = null;
        XmlObject[] xmlObjs = null;
        for (int i = 0; i < allXMLFiles.size(); ++i) {
            sXmlFile = (String)allXMLFiles.get(i);
            xmlObjs = m_converter.convertXml(sXmlFile, null, null);
            this.importMasters(xmlObjs, sUnZipFilePath, _nImportMode);
        }
        CMyFile.deleteDir(sUnZipFilePath);
        this.m_importReports.setTitle("\u5bfc\u5165\u6bcd\u677f\u6587\u4ef6");
        return this.m_importReports;
    }

    private void importMasters(XmlObject[] _xmlObjs, String _unZipPath, int _nImportMode) throws WCMException {
        int[] pResultIds = new int[_xmlObjs.length];
        for (int i = 0; i < _xmlObjs.length; ++i) {
            Master master = this.importMaster(_xmlObjs[i], _unZipPath, _nImportMode);
            if (master == null) continue;
            pResultIds[i] = master.getId();
        }
        this.m_importReports.setResultIds(pResultIds);
    }

    private Master importMaster(XmlObject _xmlObj, String _unZipPath, int _nImportMode) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        if (_xmlObj == null) {
            throw new WCMException(20, "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e\uff0cxml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6bcd\u677f\u63cf\u8ff0\u6587\u4ef6");
        }
        BaseObj obj = _xmlObj.getCurrentObj();
        try {
            Master currMaster = (Master)obj;
            currMaster.setNextId();
            String sMasterName = currMaster.getMName();
            if (this.existsMName(currMaster.getId(), sMasterName)) {
                switch (_nImportMode) {
                    case 1: {
                        this.masterFileHandler(currMaster, _unZipPath);
                        this.masterPicFileHandler(currMaster, _unZipPath);
                        Master oldMaster = this.findMasterByName(currUser, sMasterName);
                        int nOldMasterId = oldMaster.getId();
                        oldMaster.setNewProperties(currMaster.getAllProperty());
                        oldMaster.setId(nOldMasterId);
                        oldMaster.setProperty("CRUSER", currUser.getName());
                        oldMaster.setProperty("CRTIME", CMyDateTime.now());
                        oldMaster.save(currUser);
                        this.m_importReports.addSucessedReport("\u5bfc\u5165\u6bcd\u677f\u3010" + sMasterName + "\u3011\u6210\u529f.");
                        return oldMaster;
                    }
                    case 3: {
                        this.changeMasterName(currMaster);
                        break;
                    }
                    case 2: {
                        WCMException exception = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + sMasterName + "]\u7684\u6bcd\u677f,\u5ffd\u7565\u8be5\u5bfc\u5165");
                        this.m_importReports.addFailedReport("\u5df2\u5b58\u5728\u540c\u540d\u7684\u6bcd\u677f\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u6bcd\u677f[" + sMasterName + "]\u7684\u5bfc\u5165", exception);
                        return null;
                    }
                }
            }
            this.masterFileHandler(currMaster, _unZipPath);
            this.masterPicFileHandler(currMaster, _unZipPath);
            currMaster.setCrUser(currUser);
            currMaster.setProperty("CRTIME", CMyDateTime.now());
            currMaster.save(currUser);
            this.m_importReports.addSucessedReport("\u5bfc\u5165\u6bcd\u677f\u3010" + currMaster.getMName() + "\u3011\u6210\u529f.");
            return currMaster;
        }
        catch (Exception e) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u6bcd\u677f\u5931\u8d25", e);
            return null;
        }
    }

    private void masterFileHandler(Master _oMaster, String _unZipPath) throws WCMException {
        String sNewFile = this.copyFileIfNeed(_unZipPath + _oMaster.getFileName(), true);
        String sResult = this.validateMasterFile(sNewFile, _oMaster.getMasterType());
        if (sResult != null) {
            throw new WCMException(sResult);
        }
        _oMaster.setFileName(sNewFile);
    }

    private void masterPicFileHandler(Master _oMaster, String _unZipPath) throws WCMException {
        String sPicFile = _oMaster.getPicFileName();
        if (!CMyString.isEmpty(sPicFile)) {
            if (!sPicFile.equals("0")) {
                _oMaster.setPicFileName(this.copyFileIfNeed(_unZipPath + sPicFile, true));
            }
        } else {
            _oMaster.setPicFileName("0");
        }
    }

    private void changeMasterName(Master _oMaster) throws WCMException {
        String sMName = _oMaster.getMName();
        int nObjectId = _oMaster.getId();
        try {
            if (!this.existsMName(nObjectId, sMName)) {
                return;
            }
            String sNewMName = sMName = sMName.replaceAll("(_\\d+)+", "");
            int nCount = nObjectId;
            while (this.existsMName(nObjectId, sNewMName)) {
                sNewMName = sMName + "_" + nCount;
                ++nCount;
            }
            _oMaster.setMName(sNewMName);
        }
        catch (Exception ex) {
            throw new WCMException("\u6821\u9a8c\u6bcd\u677f\u91cd\u540d\u65f6\u51fa\u9519", ex);
        }
    }

    @Override
    public boolean existsMName(int _nObjectId, String _sMName) throws Exception {
        WCMFilter filter = new WCMFilter("XWCMMASTER", "MasterId!=? and MName=?", "", "");
        filter.addSearchValues(_nObjectId);
        filter.addSearchValues(_sMName);
        return DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0;
    }

    @Override
    public Masters query(User _oCurrUser, WCMFilter _oFilter) throws WCMException {
        return Masters.openWCMObjs(_oCurrUser, _oFilter);
    }

    @Override
    public String validateMasterFile(String _sFileName) throws WCMException {
        String sResult = I18NMessage.get(MasterMgr.class, "MasterMgr.label6", "\u6bcd\u677f\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c");
        if (CMyString.isEmpty(_sFileName)) {
            return sResult + I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a");
        }
        String sFileExt = CMyFile.extractFileExt(_sFileName);
        if (!sFileExt.equalsIgnoreCase("zip")) {
            return sResult + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label8", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u662fzip\u6587\u4ef6"), new String[]{_sFileName});
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(_sFileName, 0);
        if (!CMyFile.fileExists(sFilePath + _sFileName)) {
            return sResult + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label9", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u5b58\u5728"), new String[]{_sFileName});
        }
        CMyUnzip myUnzip = new CMyUnzip();
        String sUnZipPath = filesMan.mapFilePath(_sFileName, 0) + "unZip" + CMyFile.extractMainFileName(_sFileName) + "\\";
        try {
            myUnzip.setZipFile(sFilePath + _sFileName);
            Enumeration eItems = myUnzip.getItems();
            boolean bIncludeIndex = false;
            while (eItems.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)eItems.nextElement();
                if (!ze.getName().equalsIgnoreCase("index.html")) continue;
                bIncludeIndex = true;
                break;
            }
            if (!bIncludeIndex) {
                return sResult + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label10", "[{0}]\u4e2d\u6ca1\u6709\u5305\u542b\u6307\u5b9a\u6587\u4ef6index.html"), new String[]{_sFileName});
            }
            myUnzip.unzip(sUnZipPath, true);
            String sCheckResult = this.checkFile(sUnZipPath, "index.html");
            if (!CMyString.isEmpty(sCheckResult)) {
                return sResult + sCheckResult;
            }
            ZipEntry ze = myUnzip.getItem("detail.html");
            if (ze != null && !CMyString.isEmpty(sCheckResult = this.checkFile(sUnZipPath, "detail.html"))) {
                return sResult + sCheckResult;
            }
            ze = myUnzip.getItem("outline.html");
            if (ze != null && !CMyString.isEmpty(sCheckResult = this.checkFile(sUnZipPath, "outline.html"))) {
                return sResult + sCheckResult;
            }
            CMyFile.deleteDir(sUnZipPath);
        }
        catch (Throwable e) {
            CMyFile.deleteDir(sUnZipPath);
            return I18NMessage.get(MasterMgr.class, "MasterMgr.label7", "\u6821\u9a8c\u6bcd\u677f\u65f6\u51fa\u9519") + CMyException.getStackTraceText(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateMasterFile(String _sFileName, int _nMasterType) throws WCMException {
        String sResult = I18NMessage.get(MasterMgr.class, "MasterMgr.label6", "\u6bcd\u677f\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c");
        if (CMyString.isEmpty(_sFileName)) {
            return sResult + I18NMessage.get(MasterMgr.class, "MasterMgr.label3", "\u6307\u5b9a\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a");
        }
        String sFileExt = CMyFile.extractFileExt(_sFileName);
        if (!sFileExt.equalsIgnoreCase("zip")) {
            return sResult + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label8", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u662fzip\u6587\u4ef6"), new String[]{_sFileName});
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(_sFileName, 0);
        if (!CMyFile.fileExists(sFilePath + _sFileName)) {
            return sResult + CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label9", "\u6307\u5b9a\u7684\u6587\u4ef6[{0}]\u4e0d\u5b58\u5728"), new String[]{_sFileName});
        }
        CMyUnzip myUnzip = new CMyUnzip();
        String sUnZipPath = filesMan.mapFilePath(_sFileName, 0) + "unZip" + CMyFile.extractMainFileName(_sFileName) + "\\";
        try {
            Object ze;
            myUnzip.setZipFile(sFilePath + _sFileName);
            Enumeration eItems = myUnzip.getItems();
            boolean bIncludeIndexOrDetail = false;
            int nHtmlFileNumber = 0;
            String sOnlyHtmlFileName = null;
            if (_nMasterType == 1) {
                while (eItems.hasMoreElements()) {
                    ze = (ZipEntry)eItems.nextElement();
                    if (((ZipEntry)ze).getName().equalsIgnoreCase("index.html")) {
                        bIncludeIndexOrDetail = true;
                        break;
                    }
                    if (((ZipEntry)ze).getName().indexOf(".html") == -1) continue;
                    ++nHtmlFileNumber;
                    sOnlyHtmlFileName = ((ZipEntry)ze).getName();
                }
            } else if (_nMasterType == 2) {
                while (eItems.hasMoreElements()) {
                    ze = (ZipEntry)eItems.nextElement();
                    if (((ZipEntry)ze).getName().equalsIgnoreCase("detail.html")) {
                        bIncludeIndexOrDetail = true;
                        break;
                    }
                    if (((ZipEntry)ze).getName().indexOf(".html") == -1) continue;
                    ++nHtmlFileNumber;
                    sOnlyHtmlFileName = ((ZipEntry)ze).getName();
                }
            } else {
                String ze2 = this.validateMasterFile(_sFileName);
                return ze2;
            }
            if (!bIncludeIndexOrDetail) {
                if (nHtmlFileNumber < 1) {
                    ze = sResult + CMyString.format("[{0}\u4e2d\u6ca1\u6709\u5305\u542b\u6bcd\u677fhtml\u6587\u4ef6]", new String[]{_sFileName});
                    return ze;
                }
                if (nHtmlFileNumber > 1) {
                    ze = sResult + CMyString.format("[{0}]\u4e2d\u5305\u542b\u591a\u4e2ahtml\u6587\u4ef6\uff0czip\u6587\u4ef6\u4e2d\u53ea\u5141\u8bb8\u6709\u4e00\u4e2ahtml\u683c\u5f0f\u7684\u6587\u4ef6", new String[]{_sFileName});
                    return ze;
                }
            }
            myUnzip.unzip(sUnZipPath, true);
            String sCheckResult = null;
            if (bIncludeIndexOrDetail && _nMasterType == 1) {
                sCheckResult = this.checkFile(sUnZipPath, "index.html");
            } else if (bIncludeIndexOrDetail && _nMasterType == 2) {
                sCheckResult = this.checkFile(sUnZipPath, "detail.html");
            } else if (!bIncludeIndexOrDetail && nHtmlFileNumber == 1) {
                sCheckResult = this.checkFile(sUnZipPath, sOnlyHtmlFileName);
            }
            if (!CMyString.isEmpty(sCheckResult)) {
                String string = sResult + sCheckResult;
                return string;
            }
        }
        catch (Throwable e) {
            String string = I18NMessage.get(MasterMgr.class, "MasterMgr.label7", "\u6821\u9a8c\u6bcd\u677f\u65f6\u51fa\u9519") + CMyException.getStackTraceText(e);
            return string;
        }
        finally {
            CMyFile.deleteDir(sUnZipPath);
        }
        return null;
    }

    private String checkFile(String _sFilePath, String _sFileName) throws Exception {
        String sFile = _sFilePath + _sFileName;
        if (CMyString.isEmpty(sFile)) {
            return "\u6587\u4ef6\u3010" + sFile + "\u3011\u4e0d\u5b58\u5728";
        }
        String sEncode = CharsetDetector.detect(sFile);
        String sFileContent = CMyFile.readFile(sFile, sEncode);
        String sPattern = "(?is)<html[^>]*>.*<head>.*(?:<TRS_TagCreator\\s*tag\\s*=\\s*(?:'|\")?TRS_Resources(?:'|\")?[^/]*/>|<TRS_TagCreator\\s*tag\\s*=\\s*(?:'|\")?TRS_Resources(?:'|\")?[^>]*>\\s*</TRS_TagCreator>).*</head>.*<body[^>]*>.*</body>.*</html>";
        Matcher matcher = Pattern.compile(sPattern).matcher(sFileContent);
        boolean bMatches = matcher.find();
        if (!bMatches) {
            return "\u6587\u4ef6\u3010" + _sFileName + "\u3011\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684html\u3001head\u3001body\u6807\u7b7e\u6216\u8005\u6ca1\u6709\u5728head\u4e2d\u5305\u542b\u6307\u5b9atag\u7b49\u4e8eTRS_Resources\u7684TRS_TagCreator\u6807\u8bb0";
        }
        return null;
    }

    @Override
    public String getMasterFileContent(Master oMaster, int _nFileType) throws WCMException {
        int nMasterId = oMaster.getId();
        String sFileName = oMaster.getFileName();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(sFileName, 0);
        if (!CMyFile.fileExists(sFilePath + sFileName)) {
            throw new WCMException(CMyString.format(I18NMessage.get(MasterMgr.class, "MasterMgr.label14", "\u6307\u5b9a\u7684\u6bcd\u677f[Id={0}]\u7684\u6bcd\u677f\u6587\u4ef6[{1}]\u4e0d\u5b58\u5728"), new String[]{CMyString.numberToStr(nMasterId), sFileName}));
        }
        String sUnZipPath = sFilePath + "unZip" + CMyFile.extractMainFileName(sFileName) + "\\";
        try {
            CMyUnzip myUnzip = new CMyUnzip();
            myUnzip.setZipFile(sFilePath + sFileName);
            myUnzip.unzip(sUnZipPath, true);
            Enumeration eItems = myUnzip.getItems();
            ZipEntry ze = null;
            String sFileNameOfMaster = null;
            block1 : switch (_nFileType) {
                case 1: 
                case 2: {
                    while (eItems.hasMoreElements()) {
                        ze = (ZipEntry)eItems.nextElement();
                        if (ze.getName().toLowerCase().indexOf(".html") == -1) continue;
                        sFileNameOfMaster = ze.getName();
                        if (!ze.getName().equalsIgnoreCase("index.html")) continue;
                        break block1;
                    }
                    break;
                }
                case 3: {
                    while (eItems.hasMoreElements()) {
                        ze = (ZipEntry)eItems.nextElement();
                        if (ze.getName().toLowerCase().indexOf(".html") == -1) continue;
                        sFileNameOfMaster = ze.getName();
                        if (!ze.getName().equalsIgnoreCase("detail.html")) continue;
                        break block1;
                    }
                    break;
                }
            }
            if (sFileNameOfMaster == null) {
                CMyFile.deleteDir(sUnZipPath);
                return null;
            }
            String sFile = sUnZipPath + sFileNameOfMaster;
            String sEncode = CharsetDetector.detect(sFile);
            String sFileContent = CMyFile.readFile(sFile, sEncode);
            CMyFile.deleteDir(sUnZipPath);
            return sFileContent;
        }
        catch (CMyException e) {
            CMyFile.deleteDir(sUnZipPath);
            throw new WCMException(I18NMessage.get(MasterMgr.class, "MasterMgr.label15", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25"), e);
        }
    }

    private String getFullFileName(String _sImportFile) throws WCMException {
        String sImportFile = _sImportFile;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sImportFile)) {
            String sPath = filesMan.mapFilePath(_sImportFile, 0);
            sImportFile = sPath + _sImportFile;
        }
        return sImportFile;
    }

    private Master findMasterByName(User _oCurrUser, String _sMasterName) throws WCMException {
        WCMFilter filter = new WCMFilter(null, "MNAME=?", "MASTERID desc");
        filter.addSearchValues(_sMasterName);
        Masters oMasters = Masters.openWCMObjs(_oCurrUser, filter);
        return oMasters.size() > 0 ? (Master)oMasters.getAt(0) : null;
    }
}

