/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.calendar.EventType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.message.Message;
import com.trs.components.common.reminder.Reminder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;

public class Event
extends CMSObj {
    public static final int OBJ_TYPE = 306;
    public static final String DB_TABLE_NAME = "WCMEVENT";
    public static final String DB_ID_NAME = "EVENTID";
    public static final int[] ALL_REMIND_TYPES = new int[]{0, 1, 2};

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 306;
    }

    public String getTitle() {
        return (String)this.getProperty("TITLE");
    }

    public boolean setTitle(String _title) throws WCMException {
        return this.setProperty("TITLE", _title);
    }

    public String getDesc() {
        return (String)this.getProperty("EDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("EDESC", _desc);
    }

    public int getTypeId() {
        return this.getPropertyAsInt("ETYPE", 0);
    }

    public EventType getType() throws WCMException {
        int typeId = this.getTypeId();
        if (typeId == 0) {
            return null;
        }
        return EventType.findById(typeId);
    }

    public boolean setType(int _typeId) throws WCMException {
        System.out.println(_typeId);
        EventType type = EventType.findById(_typeId);
        return this.setType(type);
    }

    public boolean setType(EventType _type) throws WCMException {
        if (_type == null || !_type.isValidInstance()) {
            throw new WCMException(1104, I18NMessage.get(Event.class, "Event.label1", "Type\u503c\u65e0\u6548(Event.setType)"));
        }
        return this.setProperty("ETYPE", _type.getId());
    }

    public String getOwnerName() {
        return (String)this.getProperty("OWNER");
    }

    public User getOwner() {
        String sName = this.getOwnerName();
        return sName == null ? null : User.findByName(sName);
    }

    public boolean setOwner(String _ownerName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label2", "\u5c5e\u6027Owner\u4e0d\u5141\u8bb8\u4fee\u6539(Event.setOwner)"));
        }
        return this.setProperty("OWNER", _ownerName);
    }

    public boolean setOwner(User _owner) throws WCMException {
        if (_owner == null || !_owner.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Event.class, "Event.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Event.setOwner)"));
        }
        return this.setOwner(_owner.getName());
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("ESTART");
    }

    public boolean setStartTime(CMyDateTime _time) throws WCMException {
        if (_time == null || _time.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label4", "\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f(Event.setStartTime)"));
        }
        return this.setProperty("ESTART", _time);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EEND");
    }

    public boolean setEndTime(CMyDateTime _time) throws WCMException {
        if (_time == null || _time.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Event.class, "Event.label5", "\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f(Event.setEndTime)"));
        }
        return this.setProperty("EEND", _time);
    }

    private String getRemindFieldName(int _nRemindType) throws WCMException {
        switch (_nRemindType) {
            case 0: {
                return "ONLINEREMIND";
            }
            case 1: {
                return "EMAILREMIND";
            }
            case 2: {
                return "MOBILEREMIND";
            }
        }
        throw new WCMException(10, I18NMessage.get(Event.class, "Event.label6", "\u65e0\u6548\u7684\u63d0\u9192\u7c7b\u522b\uff08Event.getRemindFieldName\uff09"));
    }

    public boolean isRemindBy(int _nRemindType) throws WCMException {
        String sName = this.getRemindFieldName(_nRemindType);
        int nValue = this.getPropertyAsInt(sName, 0);
        return nValue == 1;
    }

    public String getSendTypes() throws WCMException {
        String sSendTypes = "";
        for (int i = 0; i < ALL_REMIND_TYPES.length; ++i) {
            int nSendType = ALL_REMIND_TYPES[i];
            if (!this.isRemindBy(nSendType)) continue;
            sSendTypes = sSendTypes + "," + this.getSendTypeName(nSendType);
        }
        if (sSendTypes.length() > 2) {
            sSendTypes = sSendTypes.substring(1, sSendTypes.length());
        }
        return sSendTypes;
    }

    private String getSendTypeName(int _nSendType) {
        switch (_nSendType) {
            case 0: {
                return "Message";
            }
            case 1: {
                return "Email";
            }
            case 2: {
                return "SMS";
            }
        }
        return "";
    }

    public boolean setRemindBy(int _nRemindType, boolean _bIfRemind) throws WCMException {
        if (!this.isAddMode() && this.isRemindDone(_nRemindType)) {
            return true;
        }
        String sName = this.getRemindFieldName(_nRemindType);
        return this.setProperty(sName, _bIfRemind ? 1 : 0);
    }

    public boolean isRemindDone(int _nRemindType) throws WCMException {
        String sName = this.getRemindFieldName(_nRemindType);
        int nValue = this.getPropertyAsInt(sName, 0);
        return nValue == 2;
    }

    public boolean setRemindDone(int _nRemindType) throws WCMException {
        String sName = this.getRemindFieldName(_nRemindType);
        int nValue = ((Number)this.getProperty(sName)).intValue();
        if (nValue != 1) {
            throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label7", "\u65e0\u6548\u64cd\u4f5c\uff1a\u5f53\u524d\u8bbe\u7f6e\u4e3a\u65e0\u63d0\u9192\uff08Event.setRemindDone\uff09"));
        }
        return this.setProperty(sName, 2L);
    }

    public int getAheadRemindTime() {
        return this.getPropertyAsInt("AHEADREMDTIME", 0);
    }

    public boolean setAheadRemindTime(int _nAheadRemindTime) throws WCMException {
        if (_nAheadRemindTime < 0) {
            throw new WCMException(10, I18NMessage.get(Event.class, "Event.label8", "\u65e0\u6548\u7684\u53c2\u6570\u503c(Event.setAheadRemindTime)"));
        }
        return this.setProperty("AHEADREMDTIME", _nAheadRemindTime);
    }

    public boolean isShared() {
        return this.getPropertyAsBoolean("ISSHARE", false);
    }

    public boolean setShare(boolean _bShared) throws WCMException {
        return this.setProperty("ISSHARE", _bShared);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("TITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label9", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("ESTART") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label10", "\u5c5e\u6027StartTime\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("EEND") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label11", "\u5c5e\u6027EndTime\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("OWNER") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label12", "\u5c5e\u6027Owner\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)"));
            }
            if (this.getProperty("ETYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Event.class, "Event.label13", "\u5c5e\u6027\u65e5\u7a0b\u5b89\u6392\u7684\u4e8b\u4ef6\u7c7b\u578bEType\u6ca1\u6709\u8bbe\u7f6e(Event.isValid)!"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Event.class, "Event.label14", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Event.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            String sName = null;
            sName = this.getRemindFieldName(0);
            if (this.getProperty(sName) == null) {
                this.setRemindBy(0, false);
            }
            if (this.getProperty(sName = this.getRemindFieldName(1)) == null) {
                this.setRemindBy(1, false);
            }
            if (this.getProperty(sName = this.getRemindFieldName(2)) == null) {
                this.setRemindBy(2, false);
            }
            if (this.getProperty("AHEADREMDTIME") == null) {
                this.setAheadRemindTime(10);
            }
            this.setCrTime();
            super.insert(_currUser);
            this.doRemindJob();
        }
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        boolean[] bNeedJob = new boolean[ALL_REMIND_TYPES.length];
        boolean bNeeded = false;
        for (int i = 0; i < ALL_REMIND_TYPES.length; ++i) {
            String sField = this.getRemindFieldName(ALL_REMIND_TYPES[i]);
            Number iValueNew = (Number)this.getNewProperty(sField);
            if (iValueNew == null || iValueNew.intValue() != 1) {
                bNeedJob[i] = false;
                continue;
            }
            Number iValueOld = (Number)this.getAllProperty().get(sField);
            boolean bl = bNeedJob[i] = iValueOld == null || iValueOld.intValue() == 0;
            if (!bNeedJob[i] || bNeeded) continue;
            bNeeded = true;
        }
        super.update(_user);
        Message message = Message.findById(this.getRemindMsgId());
        boolean bl = bNeeded = bNeeded || message == null;
        if (bNeeded) {
            try {
                this.doRemindJob();
            }
            catch (Exception ex) {
                throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label15", "\u5904\u7406\u63d0\u9192Job\u65f6\u5931\u8d25(Event.update)"), ex);
            }
        } else {
            String sSendTypes = this.getSendTypes();
            if (sSendTypes.length() > 0) {
                message.canEdit(_user);
                message.setSendTypes(this.getSendTypes());
                message.save(_user);
            } else {
                message.delete(_user);
                this.removeRemindJob(message, _user);
            }
        }
    }

    private boolean setRemindMsgId(int _nNewMsgId) throws WCMException {
        return this.setProperty("REMINDMSGID", _nNewMsgId);
    }

    public int getRemindMsgId() {
        return this.getPropertyAsInt("REMINDMSGID", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemindJob() throws WCMException {
        try {
            String sSenderTypes = this.getSendTypes();
            if (sSenderTypes == null || sSenderTypes.length() == 0) {
                return;
            }
            Message newMessage = Message.createNewInstance();
            newMessage.setTitle(this.getTitle());
            newMessage.setBody(this.getDesc());
            User receiver = User.findByName(this.getCrUserName());
            newMessage.setReceivers(204, String.valueOf(receiver.getId()));
            newMessage.setSendTypes(sSenderTypes);
            newMessage.insert(this.getCrUser());
            try {
                this.canEdit(receiver);
                this.setRemindMsgId(newMessage.getId());
                this.update(receiver);
            }
            finally {
                this.unlock();
            }
            CMyDateTime dtRemind = (CMyDateTime)this.getStartTime().clone();
            dtRemind.dateAdd(5, this.getAheadRemindTime() * -1);
            Reminder.createSchedule(newMessage, dtRemind);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Event.class, "Event.label16", "\u5904\u7406\u63d0\u9192Job\u65f6\u5931\u8d25(Event.doRemindJob)"), ex);
        }
    }

    private void removeRemindJob(Message _message, User _user) throws WCMException {
        Schedule schedule = Schedule.findBySender(1, _message);
        if (schedule != null) {
            schedule.delete(_user);
        }
    }

    public static final Event findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Event)BaseObj.findById(Event.class, _nId);
    }

    public static final Event createNewInstance() throws WCMException {
        return (Event)BaseObj.createNewInstance(Event.class);
    }

    public static final Event findByKey(Object _oKey) throws WCMException {
        return (Event)BaseObj.findByKey(Event.class, _oKey);
    }
}

