/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.logger.IObjLogger;
import com.trs.cms.logger.LogInfo;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class ObjSysLogger {
    private static Logger logger = Logger.getLogger(ObjSysLogger.class);
    private static final String LOGGERIMPL = IObjLogger.class.getName();
    private static final HashMap LOGGERS = new HashMap(20, 0.5f);
    private static final ObjSysLogger INSTANCE = new ObjSysLogger();
    private static final boolean STATR_LOGGER = true;

    private ObjSysLogger() {
        this.init();
    }

    private void init() {
        IDiscovery loggerDiscovery = WCMDiscoveryFactory.getDiscovery();
        Iterator itr = loggerDiscovery.getImplementors(LOGGERIMPL);
        if (itr != null) {
            String name = null;
            while (itr.hasNext()) {
                name = (String)itr.next();
                try {
                    Class<?> clazz = Class.forName(name);
                    IObjLogger logger = (IObjLogger)clazz.newInstance();
                    Method method = clazz.getMethod("getLogObjType", null);
                    LOGGERS.put(String.valueOf(method.invoke((Object)logger, null)), logger);
                }
                catch (Exception ex) {
                    logger.error((Object)("error regesiter obj logger:" + name), (Throwable)ex);
                }
                LOGGERS.remove(String.valueOf(702));
            }
        }
    }

    public static ObjSysLogger instance() {
        return INSTANCE;
    }

    public int startLogInserting(User curruser, BaseObj object) {
        IObjLogger objlogger = (IObjLogger)LOGGERS.get(String.valueOf(object.getWCMType()));
        if (objlogger == null) {
            return 0;
        }
        LogInfo logInfo = objlogger.makeLogOnAdd(object);
        return this.saveLog(curruser, object, logInfo);
    }

    public int startLogModifying(User curruser, BaseObj object) {
        IObjLogger objlogger = (IObjLogger)LOGGERS.get(String.valueOf(object.getWCMType()));
        if (objlogger == null) {
            return 0;
        }
        LogInfo logInfo = objlogger.makeLogOnModify(object);
        return this.saveLog(curruser, object, logInfo);
    }

    public int startLogDeleting(User curruser, BaseObj object) {
        IObjLogger objlogger = (IObjLogger)LOGGERS.get(String.valueOf(object.getWCMType()));
        if (objlogger == null) {
            return 0;
        }
        LogInfo logInfo = objlogger.makeLogOnDel(object);
        return this.saveLog(curruser, object, logInfo);
    }

    private int saveLog(User curruser, BaseObj object, LogInfo logInfo) {
        if (logInfo == null) {
            return 0;
        }
        try {
            Log log = new Log();
            log.setOpType(logInfo.optype);
            log.setObjName(logInfo.name);
            log.setDesc(logInfo.detail);
            log.setObjType(object.getWCMType());
            log.setObjId(object.getId());
            log.setUser(curruser.getName());
            log.setLogUserIP(curruser.getLoginIP());
            log.setTopLogId(ObjSysLogger.getTopLogId());
            long currentTimeMillis = System.currentTimeMillis();
            log.setStartTimeMillis(currentTimeMillis);
            log.setEndTimeMillis(currentTimeMillis);
            log.setLogType(3);
            log.setResult(0);
            log.setOpTime();
            log.save();
            return log.getId();
        }
        catch (WCMException ex) {
            logger.error((Object)"Failed to record a log", (Throwable)ex);
            if (logger.isDebugEnabled()) {
                StringBuffer buff = new StringBuffer(256);
                buff.append(curruser);
                buff.append(" operate on ");
                buff.append(object);
                buff.append(". Detail log info:");
                buff.append(logInfo);
                logger.debug((Object)buff);
                buff.setLength(0);
                buff = null;
            }
            return 0;
        }
    }

    private static int getTopLogId() {
        Integer iTopId = (Integer)BaseContextHelper.getArg(LogServer.CONTEXT_INDEX_TOPID);
        if (iTopId == null) {
            return 0;
        }
        return iTopId;
    }

    public void finishLog(int _nLogId) {
        this.finishLog(_nLogId, null, 0);
    }

    public void finishLog(int _nLogId, int _nObjId) {
        this.finishLog(_nLogId, null, 0);
    }

    public void finishLog(int _nLogId, Throwable error) {
        this.finishLog(_nLogId, error, 0);
    }

    private void finishLog(int _nLogId, Throwable error, int _nObjId) {
        if (_nLogId <= 0) {
            return;
        }
        if (error == null) {
            if (_nObjId > 0) {
                LogServer.endRecordSucceedOperation(_nLogId, _nObjId);
            } else {
                LogServer.endRecordSucceedOperation(_nLogId);
            }
        } else {
            LogServer.endRecordFailedOperation(_nLogId, error);
        }
    }
}

