/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseWCMObjectToXML
implements IXMLConvertor {
    private String m_sPrefix = this.getClass().getName() + ".";
    private NamesRegister m_oSpecialPropertiesRegister = new NamesRegister();
    private HashMap m_hmNewTagNames = new HashMap(1);
    protected boolean m_bToXMLDependsOnSelectFields = true;

    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        this.specialDoWith(_methodContext);
        if (_result instanceof BaseObjs) {
            return this.toXMLString(_methodContext, (BaseObjs)_result);
        }
        if (_result instanceof BaseObj) {
            return this.toXMLString(_methodContext, (BaseObj)_result);
        }
        throw new ConvertException(I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label1", "\u7c7b\u578b[") + _result.getClass().getName() + I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label2", "]\u4e0d\u5339\u914d\uff01"));
    }

    protected void specialDoWith(MethodContext _methodContext) {
    }

    private String toXMLString(MethodContext _methodContext, BaseObjs _baseObjects) throws ConvertException {
        if (_methodContext != null && _methodContext.getValue("OnlyReturnIds", false)) {
            String sValue;
            int nValueType = _methodContext.getValue("IdsValueType", 0);
            switch (nValueType) {
                case 0: {
                    sValue = _baseObjects.getIdListAsString(',');
                    _methodContext.setReturnHTML(true);
                    break;
                }
                case 1: {
                    sValue = "{Ids:\"" + _baseObjects.getIdListAsString(',') + "\"}";
                    _methodContext.setReturnJSON(true);
                    break;
                }
                default: {
                    sValue = "<Ids>" + _baseObjects.getIdListAsString(',') + "</Ids>";
                }
            }
            return sValue;
        }
        String sObjectsTagName = this.makeTagName(_baseObjects.getClass());
        String sObjectTagName = this.makeTagName(_baseObjects.getElementClass());
        int nPageSize = -1;
        int nPageIndex = 1;
        if (_methodContext != null) {
            nPageSize = _methodContext.getPageSize();
            nPageIndex = _methodContext.getPageIndex();
        }
        CPager currPager = new CPager(nPageSize);
        currPager.setCurrentPageIndex(nPageIndex);
        currPager.setItemCount(_baseObjects.size());
        Element rootElement = DocumentHelper.createElement((String)sObjectsTagName);
        this.setPageAttributes(currPager, rootElement);
        this.setRootAttributes(_methodContext, _baseObjects, rootElement);
        String[] pSelectFields = this.makeSelectFields(_methodContext);
        if (pSelectFields != null && pSelectFields.length == 1 && pSelectFields[0].equalsIgnoreCase(_baseObjects.getIdFieldName())) {
            String sIdFieldName = _baseObjects.getIdFieldName();
            for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                Element element = rootElement.addElement(sObjectTagName);
                element.addElement(sIdFieldName).addText(String.valueOf(_baseObjects.getIdAt(i - 1)));
            }
        } else {
            boolean bLoadText = _methodContext != null && _methodContext.getValue("_loadtext_", false);
            for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                BaseObj object = _baseObjects.getAt(i - 1);
                if (object == null) continue;
                Element elChild = this.makeElementFromBaseObj(_methodContext, sObjectTagName, object, bLoadText, pSelectFields);
                rootElement.add(elChild);
            }
        }
        return rootElement.asXML();
    }

    private String[] makeSelectFields(MethodContext _methodContext) {
        if (_methodContext == null) {
            return null;
        }
        String[] pSelectFields = null;
        String sSelectFields = _methodContext.getValue("SelectFields");
        if (sSelectFields != null && sSelectFields.length() > 0 && !sSelectFields.equals("*")) {
            pSelectFields = CMyString.split(sSelectFields, ",");
        }
        return pSelectFields;
    }

    private void setRootAttributes(MethodContext context, BaseObjs objects, Element rootElement) throws ConvertException {
        String[][] pSpecialProperty = this.getSpecialRootAttributes(context, objects);
        this.setElementAttributes(rootElement, pSpecialProperty);
    }

    private void setElementAttributes(Element _rootElement, String[][] _pAttributes) throws ConvertException {
        if (_pAttributes == null) {
            return;
        }
        for (int i = 0; i < _pAttributes.length; ++i) {
            if (_pAttributes[i] == null) continue;
            if (_pAttributes[i].length < 2) {
                throw new ConvertException(I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label3", "getSpecialRootAttributes\u7684\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
            }
            _rootElement.addAttribute(_pAttributes[i][0], _pAttributes[i][1]);
        }
    }

    protected abstract String[][] getSpecialElementAttributes(MethodContext var1, BaseObj var2) throws ConvertException;

    protected abstract String[][] getSpecialRootAttributes(MethodContext var1, BaseObjs var2) throws ConvertException;

    protected abstract String[][] getSpecialRootAttributes(MethodContext var1, BaseObj var2) throws ConvertException;

    private String toXMLString(MethodContext _methodContext, BaseObj _baseObject) throws ConvertException {
        String[] pSelectFields = this.makeSelectFields(_methodContext);
        String sObjectTagName = this.makeTagName(_baseObject.getClass());
        Element root = this.makeElementFromBaseObj(_methodContext, sObjectTagName, _baseObject, true, pSelectFields);
        String[][] pSpecialProperty = this.getSpecialRootAttributes(_methodContext, _baseObject);
        this.setElementAttributes(root, pSpecialProperty);
        return root.asXML();
    }

    private void setPageAttributes(CPager _pager, Element _element) {
        _element.addAttribute("Num", String.valueOf(_pager.getItemCount()));
        if (_pager.getPageSize() <= 0) {
            return;
        }
        _element.addAttribute("PageSize", String.valueOf(_pager.getPageSize()));
        _element.addAttribute("PageCount", String.valueOf(_pager.getPageCount()));
        _element.addAttribute("CurrPageIndex", String.valueOf(_pager.getCurrentPageIndex()));
    }

    protected boolean isToHTML(MethodContext _methodContext, String _sFieldName) {
        if (_methodContext == null) {
            return false;
        }
        String sFieldsToHTML = _methodContext.getValue("FieldsToHTML");
        if (sFieldsToHTML == null || sFieldsToHTML.length() == 0) {
            return false;
        }
        return ("," + sFieldsToHTML + ",").toUpperCase().indexOf("," + _sFieldName.toUpperCase() + ",") >= 0;
    }

    protected Element makeElementFromBaseObj(MethodContext _methodContext, String _sTagName, BaseObj _baseObj, boolean _bLoadText, String[] _pSelectFields) throws ConvertException {
        Hashtable[] pProperties = this.getPropertiesArray(_baseObj, _bLoadText);
        Element element = DocumentHelper.createElement((String)_sTagName);
        for (Hashtable properties : pProperties) {
            if (properties == null) continue;
            Object[] pKeys = null;
            pKeys = this.m_bToXMLDependsOnSelectFields && _pSelectFields != null && _pSelectFields.length > 0 ? _pSelectFields : properties.keySet().toArray();
            for (int i = 0; i < pKeys.length; ++i) {
                String[][] pSpecialProperty;
                String sName = ((String)pKeys[i]).toUpperCase();
                Element field = element.addElement(sName);
                Object oValue = properties.get(sName);
                if (sName.equals("ATTRIBUTE") && oValue != null) {
                    AttributesString attrs = new AttributesString(oValue.toString());
                    List listNames = attrs.getNameList();
                    int nSize = listNames.size();
                    for (int j = 0; j < nSize; ++j) {
                        String sAttrName = (String)listNames.get(j);
                        field.addAttribute(sAttrName, attrs.getAttributeValue(sAttrName));
                    }
                    continue;
                }
                String sValue = null;
                int nSpecialPropertyId = this.lookupHostSpecialPropertyId(sName);
                if (nSpecialPropertyId > 0 && (pSpecialProperty = this.getSpecialProperty(_methodContext, _baseObj, nSpecialPropertyId, oValue)) != null) {
                    String sNewTagName = (String)this.m_hmNewTagNames.get(sName);
                    if (sNewTagName != null) {
                        field.setName(sNewTagName);
                    }
                    if (pSpecialProperty.length == 1 && pSpecialProperty[0].length == 1) {
                        sValue = pSpecialProperty[0][0];
                    } else if (pSpecialProperty.length == 1 && pSpecialProperty[0].length == 2) {
                        boolean bFieldToHTML = this.isToHTML(_methodContext, (sNewTagName != null ? sNewTagName : sName) + "." + pSpecialProperty[0][0]);
                        field.addAttribute(pSpecialProperty[0][0], bFieldToHTML ? CMyString.transDisplay(pSpecialProperty[0][1], false) : pSpecialProperty[0][1]);
                    } else {
                        for (int j = 0; j < pSpecialProperty.length; ++j) {
                            boolean bFieldToHTML = this.isToHTML(_methodContext, (sNewTagName != null ? sNewTagName : sName) + "." + pSpecialProperty[j][0]);
                            field.addAttribute(pSpecialProperty[j][0], bFieldToHTML ? CMyString.transDisplay(pSpecialProperty[j][1], false) : pSpecialProperty[j][1]);
                        }
                        continue;
                    }
                }
                if (this.isCData(oValue)) {
                    if (sValue == null) {
                        sValue = oValue == null || oValue instanceof NullValue ? "" : oValue.toString();
                    }
                    if (sValue == null || sValue.length() <= 0) continue;
                    if (this.isToHTML(_methodContext, sName)) {
                        sValue = CMyString.transDisplay(sValue, false);
                    }
                    if (sValue.matches("(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*")) {
                        field.setText(sValue);
                        continue;
                    }
                    field.addCDATA(sValue);
                    continue;
                }
                if (sValue != null) {
                    field.setText(sValue);
                    continue;
                }
                if (oValue instanceof CMyDateTime) {
                    CMyDateTime dtValue = (CMyDateTime)oValue;
                    if (dtValue.isNull()) continue;
                    field.setText(this.convertDateTimeValueToString(_methodContext, dtValue));
                    continue;
                }
                if (sValue == null) {
                    sValue = oValue == null || oValue instanceof NullValue ? "" : oValue.toString();
                }
                if (sValue == null || sValue.length() <= 0) continue;
                field.setText(sValue);
            }
            this.setElementAttributes(element, this.getSpecialElementAttributes(_methodContext, _baseObj));
        }
        return element;
    }

    protected Hashtable[] getPropertiesArray(BaseObj _baseObj, boolean _bLoadText) {
        Hashtable<String, Object> properties = _bLoadText ? _baseObj.getAllProperty() : _baseObj.getProperties();
        return new Hashtable[]{properties};
    }

    protected String convertDateTimeValueToString(MethodContext _methodContext, CMyDateTime _dtValue) {
        String sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        if (_methodContext != null && (sDateTimeFormat = _methodContext.getValue("DateTimeFormat")) == null) {
            sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        }
        String sDtValue = _dtValue.toString(sDateTimeFormat);
        return sDtValue;
    }

    private boolean isCData(Object _value) {
        if (_value instanceof CDBText) {
            return true;
        }
        return _value instanceof String && ((String)_value).length() > 0;
    }

    private String makeTagName(Class _objectClass) {
        String sObjectsTagName = _objectClass.getName();
        int nPos = sObjectsTagName.lastIndexOf(46);
        if (nPos >= 0) {
            sObjectsTagName = sObjectsTagName.substring(nPos + 1);
        }
        return sObjectsTagName;
    }

    protected abstract void registerHostSpecialProperties();

    protected abstract String[][] getSpecialProperty(MethodContext var1, BaseObj var2, int var3, Object var4) throws ConvertException;

    protected void registerHostSpecialProperty(String _sName, int _nId) {
        this.registerHostSpecialProperty(_sName, _nId, null);
    }

    protected void registerHostSpecialProperty(String _sName, int _nId, String _sNewTagName) {
        this.m_oSpecialPropertiesRegister.register(this.m_sPrefix + _sName.toUpperCase(), _nId);
        if (_sNewTagName != null) {
            this.m_hmNewTagNames.put(_sName.toUpperCase(), _sNewTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String _sName) {
        if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
            NamesRegister namesRegister = this.m_oSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
                    this.registerHostSpecialProperties();
                    this.m_oSpecialPropertiesRegister.register(this.m_sPrefix, 0);
                }
            }
        }
        return this.m_oSpecialPropertiesRegister.lookup(this.m_sPrefix + _sName.toUpperCase(), -1);
    }
}

