/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DocPublishTaskLogger
extends AbstractLogger {
    private static final Logger LOG = Logger.getLogger(DocPublishTaskLogger.class);
    private static final int MAX_DOCSIZE = 20;

    @Override
    public int startLog(MethodConfig conf, MethodContext context) {
        User loginUser = ContextHelper.getLoginUser();
        int nPublishTtype = context.getValue("PublishType", 0);
        String sLogType = this.getLogType(nPublishTtype, context.getValue("withdrawall", false));
        if (sLogType == null) {
            sLogType = "UNKNOWN_OPERTYPE";
        }
        Document logobj = null;
        try {
            StringBuffer desc = new StringBuffer(256);
            if (nPublishTtype == 7) {
                desc.append(sLogType).append(", \u88ab\u64a4\u9500\u53d1\u5e03\u7684\u5bf9\u8c61\u4e3a: ");
            } else {
                desc.append(sLogType).append(", \u88ab\u53d1\u5e03\u7684\u5bf9\u8c61\u4e3a: ");
            }
            String sIds = context.getObjectIds();
            ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, sIds);
            if (chnldocs.isEmpty()) {
                return 0;
            }
            int size = chnldocs.size();
            for (int i = 0; i < size && i < 20; ++i) {
                Document doc;
                ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (chnldoc == null || (doc = chnldoc.getDocument()) == null) continue;
                if (logobj == null) {
                    logobj = doc;
                }
                desc.append(doc);
                desc.append(", ");
            }
            if (chnldocs.size() > 20) {
                desc.append(" ...(\u7565). ID\u5e8f\u5217\u4e3a:").append(sIds);
                desc.append(", ");
            }
            if (logobj == null) {
                LOG.warn((Object)"No need to log a pubish operate: no object found.");
                return 0;
            }
            return (int)LogServer.startRecord(loginUser.getName(), sLogType, desc.substring(0, desc.length() - 2), logobj);
        }
        catch (WCMException ex) {
            LOG.error((Object)"Failed to log a publish operate.", (Throwable)ex);
            return 0;
        }
    }

    protected String getLogType(int nPublishType, boolean bAll) {
        String sLogType = "\u6587\u6863\u7684";
        sLogType = bAll ? sLogType + "\u76f4\u63a5\u64a4\u9500\u53d1\u5e03" : sLogType + PublishConstants.getPublishTypeName(nPublishType, "\u672a\u77e5\u53d1\u5e03\u7c7b\u578b");
        try {
            if (!LogServer.existsLogType(sLogType)) {
                this.createLogTypeIfNeed(sLogType, sLogType);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return sLogType;
    }

    @Override
    public String getClassDesc() {
        return "\u6587\u6863\u53d1\u5e03";
    }
}

