/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.filter.logicProcessor.IDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class UpdateGroupProcessor
implements IDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(UpdateGroupProcessor.class);
    private IAgent agent;
    private final String idsCmd = "updGroup";

    public UpdateGroupProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String groupDN;
        String sourceName;
        String groupName = ProcessorUtil.getGroupNameFromRequestHeader(req);
        SSOGroup ssoGroup = this.agent.getUpdSSOGroup(groupName, sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req), groupDN = ProcessorUtil.getGroupDnFromRequestHeader(req));
        if (ssoGroup == null) {
            LOG.error((Object)"[IDSAgent]group is null!");
            resp.sendError(500, "[IDSAgent]group is null! (app, idsCmd,groupName)=" + this.agent.getAgentName() + ", " + "updGroup" + " ," + groupName + ". host=" + InetAddress.getLocalHost());
        } else {
            boolean opResult;
            try {
                opResult = this.agent.getServletAppActorV2().updateGroup(req, resp, ssoGroup);
            }
            catch (Throwable t) {
                LOG.error((Object)"[ActorErr]update group fail!", t);
                resp.sendError(500, "[ActorErr]updateGroup() fail! err=" + t);
                return;
            }
            if (opResult) {
                resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "updGroup");
            } else {
                resp.sendError(500, "[ActorErr]updateGroup() return false!");
            }
        }
    }

    public String getIDSCmd() {
        return "updGroup";
    }
}

