/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AddUserProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(AddUserProcessor.class);
    private IAgent agent;
    private final String idsCmd = "addUser";

    public AddUserProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String sourceName;
        String userName = ProcessorUtil.getUserNameFromRequestHeader(req);
        SSOUser ssoUser = this.agent.getNewSSOUser(userName, sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req));
        if (ssoUser == null) {
            LOG.error((Object)"[IDSAgent]user is null!");
            resp.sendError(500, "[IDSAgent]user is null! (app, idsCmd)=" + this.agent.getAgentName() + ", " + "addUser" + ". host=" + InetAddress.getLocalHost());
        } else {
            boolean opResult;
            try {
                opResult = this.agent.getServletAppActorV2().addUser(req, resp, ssoUser);
            }
            catch (Throwable t) {
                LOG.error((Object)("[ActorErr]addUser fail! (app, idsCmd)=" + this.agent.getAgentName() + ", " + "addUser"), t);
                resp.sendError(500, "[ActorErr]addUser() fail! (app, idsCmd)=" + this.agent.getAgentName() + ", err=" + t.getClass());
                return;
            }
            if (resp.isCommitted()) {
                return;
            }
            if (opResult) {
                resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "addUser");
            } else {
                resp.sendError(500, "[ActorErr]addUser() return false!");
            }
        }
    }

    public String getIDSCmd() {
        return "addUser";
    }
}

