/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class HttpCheck {
    private static final Logger logger = Logger.getLogger(HttpCheck.class);
    private static HttpClient client;

    static {
        HttpCheck.init();
    }

    public static boolean isFineHttpRSCode(String url) {
        if (url == null || url.trim().length() == 0) {
            return false;
        }
        GetMethod method = new GetMethod(url);
        try {
            int respCode = client.executeMethod((HttpMethod)method);
            boolean bl = respCode / 100 < 4;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("httpClient.executeMethod failed! url=" + url), (Throwable)e);
            return false;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static int getHttpRSCode(String url) {
        if (url == null || url.trim().length() == 0) {
            return 400;
        }
        GetMethod method = new GetMethod(url);
        try {
            int n = client.executeMethod((HttpMethod)method);
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("httpClient.executeMethod failed! url=" + url), (Throwable)e);
            return 400;
        }
        finally {
            method.releaseConnection();
        }
    }

    private static void init() {
        client = new HttpClient();
        client.setConnectionTimeout(60000);
    }
}

