/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.authorization.processor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.authorization.IAuthorizationActor;
import com.trs.idm.client.authorization.bo.Role;
import com.trs.idm.client.authorization.processor.IAuthorizationProcessor;
import com.trs.idm.util.StringHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetURAProcessor
implements IAuthorizationProcessor {
    private static final Logger logger = Logger.getLogger(GetURAProcessor.class);
    private IAuthorizationActor actor;

    public GetURAProcessor(IAuthorizationActor actor) {
        this.actor = actor;
    }

    @Override
    public String process(String data) {
        Map parameters;
        String userName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request data is " + data));
        }
        if (StringHelper.isEmpty(userName = (String)(parameters = this.parseQueryRequest(data)).get("userName"))) {
            logger.error((Object)"request to get user's role assignments,but userName is empty.");
            return null;
        }
        Element assignments = DocumentHelper.createDocument().addElement("user_role_assignments");
        Properties userProps = new Properties();
        userProps.put("userName", userName);
        SSOUser user = new SSOUser(userProps);
        List roles = this.actor.listAllRoles();
        if (roles != null && !roles.isEmpty()) {
            for (Role role : roles) {
                Element eleRole = assignments.addElement("role");
                eleRole.addAttribute("id", role.getId());
                eleRole.addAttribute("name", role.getName());
                eleRole.addAttribute("assigned", this.actor.isRoleAssigned(role, user) ? "true" : "false");
            }
        }
        String result = assignments.asXML();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get user " + userName + "'s role assignments is " + result));
        }
        return result;
    }

    private Map parseQueryRequest(String request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Iterator parameterIterator = null;
        try {
            parameterIterator = DocumentHelper.parseText((String)request).getRootElement().elementIterator("parameter");
        }
        catch (DocumentException documentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (parameterIterator != null) {
            while (parameterIterator.hasNext()) {
                Element eleParameter = (Element)parameterIterator.next();
                String name = eleParameter.attributeValue("name");
                if (StringHelper.isEmpty(name)) continue;
                parameters.put(name, eleParameter.attributeValue("value"));
            }
        }
        return parameters;
    }
}

