/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor;

import com.trs.idm.client.IWebCoAppActor;
import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.IServletAppActor;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class LegacyActorAdapter
implements IServletAppActor {
    private IWebCoAppActor legacyActor;
    private String legacyActorClassName;
    private static final Logger LOG = Logger.getLogger(LegacyActorAdapter.class);

    public LegacyActorAdapter(IWebCoAppActor legacyActor) {
        if (legacyActor == null) {
            throw new IllegalArgumentException("legacyActor is null!");
        }
        this.legacyActorClassName = legacyActor.getClass().getName();
        this.legacyActor = legacyActor;
    }

    @Override
    public void start(ServletContext application) {
        LOG.info((Object)("actor start, application" + application));
    }

    public void stop(ServletContext application) {
        LOG.info((Object)("actor stop, application:" + application));
    }

    @Override
    public boolean addUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.addUser(user.getUserName(), user.getProperties(), request);
    }

    @Override
    public boolean checkLocalLogin(HttpServletRequest request) throws ActorException {
        return this.legacyActor.checkLocalLogin(request.getSession()) || this.legacyActor.canPass(request);
    }

    @Override
    public boolean disableUser(SSOUser user) throws ActorException {
        throw new ActorException("legacyActor not implement disableUser()!");
    }

    @Override
    public boolean enableUser(SSOUser user) throws ActorException {
        throw new ActorException("legacyActor not implement enableUser()!");
    }

    @Override
    public FormValues extractExtraInput(HttpServletRequest request) throws ActorException {
        String sourceName = request.getParameter("sourceName");
        FormValues values = new FormValues();
        values.put("sourceName", sourceName);
        return values;
    }

    @Override
    public String extractUserName(HttpServletRequest request) throws ActorException {
        return this.legacyActor.extractUserName(request);
    }

    @Override
    public String extractUserPwd(HttpServletRequest request) throws ActorException {
        return this.legacyActor.extractUserPwd(request);
    }

    @Override
    public void loadAnonymous(HttpServletRequest request) throws ActorException {
        this.legacyActor.loadAnonymous(request);
    }

    @Override
    public void loadLoginUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        this.legacyActor.loadUserInfoToSession(user.getProperties(), request.getSession(), request);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        this.legacyActor.logout(request.getSession());
    }

    @Override
    public boolean removeUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.removeUser(user.getUserName(), request);
    }

    @Override
    public boolean unremoveUser(SSOUser user, HttpServletRequest request) throws ActorException {
        throw new ActorException("legacyActor not implement unremoveUser()!");
    }

    @Override
    public boolean updateUser(SSOUser user, HttpServletRequest request) throws ActorException {
        return this.legacyActor.updateUser(user.getUserName(), user.getProperties(), request);
    }

    @Override
    public boolean userExist(SSOUser user) throws ActorException {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(160);
        sb.append("legacyActorClassName=").append(this.legacyActorClassName);
        sb.append("; legacyActor=").append(this.legacyActor);
        sb.append(". this=").append(super.toString());
        return sb.toString();
    }

    @Override
    public String getSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) throws ActorException {
        HttpSession session = request.getSession(create);
        if (session == null) {
            return null;
        }
        return session.getId();
    }

    @Override
    public boolean useStandardHttpSession() {
        return true;
    }

    @Override
    public boolean addGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement addGroup(),class name:" + this.legacyActorClassName);
    }

    @Override
    public boolean delGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement delGroup(),class name:" + this.legacyActorClassName);
    }

    @Override
    public boolean updateGroup(SSOGroup group, HttpServletRequest req) {
        throw new ActorException("legacyActor not implement updateGroup(),class name:" + this.legacyActorClassName);
    }

    @Override
    public boolean moveToGroup(SSOUser user, SSOGroup group) throws ActorException {
        throw new ActorException("legacyActor not implement moveToGroup(),class name:" + this.legacyActorClassName);
    }

    @Override
    public boolean removeFromGroup(SSOUser user, SSOGroup group) throws ActorException {
        throw new ActorException("legacyActor not implement removeFromGroup(),class name:" + this.legacyActorClassName);
    }

    @Override
    public void stop() {
    }
}

