/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.xml;

import com.trs.dev4.jdk16.xml.Node;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractNode
implements Node {
    private int level;
    protected String nodeName;
    protected Map<String, Object> attributes;

    public AbstractNode(String nodeName) {
        this.nodeName = nodeName;
    }

    public void addAttribute(String name, int value) {
        this.addAttribute(name, new Integer(value));
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(name, (Object)value);
    }

    public void addAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if (value == null) {
            value = "";
        }
        this.attributes.put(name, value);
    }

    protected String getFmtWhiteSpace() {
        StringBuffer sb = new StringBuffer(32);
        int i = 0;
        while (i < this.getLevel()) {
            sb.append("    ");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getFmtWhiteSpace());
        sb.append("<").append(this.nodeName);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                Object value = this.attributes.get(key);
                sb.append(" ").append((Object)key).append("=\"").append(value).append("\"");
            }
        }
        if (!this.hasNodeValue()) {
            sb.append("/>");
        } else {
            sb.append(">").append(this.getNodeValue()).append("</").append(this.nodeName).append(">");
        }
        return sb.toString();
    }

    protected abstract boolean hasNodeValue();

    protected abstract String getNodeValue();

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return "AbstractNode [level=" + this.level + ", nodeName=" + this.nodeName + ", attributes=" + this.attributes + "]";
    }
}

