/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.view;

import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.xss.SafeHtmlUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.ServletWebRequest;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String> ignoreCaseParamNames = new HashMap<String, String>();
    private static final int DEFAULT_PAGESIZE = 20;
    private static final int DEFAULT_PAGENO = 0;
    private static final Logger LOG = Logger.getLogger(RequestWrapper.class);
    private static final String INFO_TIP_VIEW = "infoTip";
    private static final String ERROR_TIP_VIEW = "errorTip";
    private static final String PARAM_PAGESIZE = "ps";
    private static final String PARAM_PAGENO = "pn";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ID_ARRAY = "ids";
    private static final String PARAM_ORDER_FLAG = "oFlag";
    private static final String PRAM_ORDER_FIELD = "oField";
    private static final String PARAM_END_TIME = "endTime";
    private static final String PARAM_BEGIN_TIME = "beginTime";
    private static final String PARAM_TIME_FIELD = "tField";
    private static final String HQL_SEPARATOR = " ";
    private static final String ORDER_FLAG_DESC = "DESC";
    private static final String ORDER_FLAG_ASC = "ASC";
    private static final String PARAM_SEARCH_WORD = "sWord";
    private static final String PARAM_SEARCH_FIELD = "sField";
    private static final String DEFAULT_ORDER_BY = "id DESC";

    public RequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._getHttpServletRequest();
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public static RequestWrapper getWrapper(HttpServletRequest request) {
        if (request instanceof RequestWrapper) {
            return (RequestWrapper)request;
        }
        return new RequestWrapper(request);
    }

    public static RequestWrapper getWrapper(ServletWebRequest webReq) {
        HttpServletRequest request = webReq.getRequest();
        if (request instanceof RequestWrapper) {
            return (RequestWrapper)request;
        }
        return new RequestWrapper(request);
    }

    public int getInt(String paramName, int defVal) {
        String value = this.getParameter(paramName);
        if (StringHelper.isEmpty(value)) {
            return defVal;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (RuntimeException re) {
            return defVal;
        }
    }

    public int getInt(String paramName) {
        return this.getInt(paramName, 0);
    }

    public String getString(String paramName, String defVal) {
        String value = this.getParameter(paramName);
        return StringHelper.avoidEmpty(value, defVal);
    }

    public String getString(String paramName) {
        return this.getString(paramName, "");
    }

    public double getDouble(String paramName, double defVal) {
        String value = this.getParameter(paramName);
        if (StringHelper.isEmpty(value)) {
            return defVal;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (RuntimeException re) {
            return defVal;
        }
    }

    public double getDouble(String paramName) {
        return this.getDouble(paramName, 0.0);
    }

    public boolean getBoolean(String paramName, boolean defVal) {
        String value = this.getParameter(paramName);
        if (StringHelper.isEmpty(value)) {
            return defVal;
        }
        try {
            return "true".equals(value) || "1".equals(value);
        }
        catch (RuntimeException re) {
            return defVal;
        }
    }

    public boolean getBoolean(String paramName) {
        return this.getBoolean(paramName, false);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCaseParamNames.clear();
        if (!ignoreCase) {
            return;
        }
        Enumeration enums = this.getParameterNames();
        while (enums.hasMoreElements()) {
            String paramName = (String)enums.nextElement();
            this.ignoreCaseParamNames.put(paramName.toLowerCase(), paramName);
        }
    }

    public String getRemoteAddr() {
        HttpServletRequest request = this._getHttpServletRequest();
        String remoteAddr = request.getHeader("x-forwarded-for");
        if (StringHelper.isEmpty(remoteAddr) || "Unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = request.getHeader("Proxy-Client-IP");
        }
        if (StringHelper.isEmpty(remoteAddr) || "Unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringHelper.isEmpty(remoteAddr) || "Unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public String getParameter(String arg0) {
        HttpServletRequest request = this._getHttpServletRequest();
        String value = null;
        value = request.getParameter(arg0);
        if (value != null) {
            return value;
        }
        String newParamName = this.ignoreCaseParamNames.get(arg0.toLowerCase());
        if (newParamName != null && !arg0.equals(newParamName)) {
            value = request.getParameter(newParamName);
            return value;
        }
        return null;
    }

    public String getParameter(String arg0, int maxLen) {
        return this.getParameter(arg0, maxLen, true);
    }

    public String getParameter(String arg0, int maxLen, boolean xssCheck) {
        String value = this.getParameter(arg0);
        String string = value = xssCheck ? SafeHtmlUtil.getSafeHtml(value) : value;
        if (value.length() > maxLen) {
            return value.substring(0, maxLen - 1);
        }
        return value;
    }

    public String[] getParameterValues(String arg0) {
        HttpServletRequest request = this._getHttpServletRequest();
        String[] result = request.getParameterValues(arg0);
        if (result != null && result.length > 0) {
            return result;
        }
        String newParamName = this.ignoreCaseParamNames.get(arg0.toLowerCase());
        if (newParamName != null && !arg0.equals(newParamName)) {
            return request.getParameterValues(newParamName);
        }
        return result;
    }

    public SearchFilter getSearchFilter(boolean isOwner) {
        SearchFilter sf = this.getPageSearchFiler();
        String key = this.getSearchField();
        String value = this.getSearchWord();
        String opreator = StringHelper.avoidEmpty(this.getSearchOperator(), "=");
        if (!StringHelper.isEmpty(key) && !StringHelper.isEmpty(value)) {
            sf.setCacheable(false);
            sf.addCondition(opreator, key, value);
        }
        this.buildTimeField(sf);
        this.buildOrderField(sf);
        return sf;
    }

    public SearchFilter getSearchFilter() {
        return this.getSearchFilter(false);
    }

    private void buildTimeField(SearchFilter sf) {
        String timeField = this.getTimeField();
        if (StringHelper.isEmpty(timeField)) {
            return;
        }
        long beginTime = DateUtil.getDateAsMillis(this.getBeginTime());
        long endTime = DateUtil.getDateAsMillis(this.getEndTime());
        if (beginTime != -1L && endTime != -1L) {
            sf.addBetweenCondition(timeField, beginTime, endTime);
        } else if (beginTime != -1L) {
            sf.addGreaterThanEquals(timeField, beginTime);
        } else {
            sf.addLesserThanEquals(timeField, endTime);
        }
        sf.setCacheable(false);
    }

    private void buildOrderField(SearchFilter sf) {
        String orderField = this.getOrderField();
        if (StringHelper.isEmpty(orderField)) {
            return;
        }
        String orderFlag = this.getOrderFlag();
        sf.setOrderBy(String.valueOf(orderField) + HQL_SEPARATOR + (orderFlag.equalsIgnoreCase(ORDER_FLAG_ASC) ? ORDER_FLAG_ASC : ORDER_FLAG_DESC));
        if (StringHelper.isEmpty(sf.getOrderBy())) {
            sf.setOrderBy(DEFAULT_ORDER_BY);
        }
        sf.setCacheable(false);
    }

    public String getTimeField() {
        return RequestUtil.getParameterAndTrim((HttpServletRequest)this, PARAM_TIME_FIELD);
    }

    public String getBeginTime() {
        return RequestUtil.getParameterAndTrim(this._getHttpServletRequest(), PARAM_BEGIN_TIME);
    }

    public String getEndTime() {
        return RequestUtil.getParameterAndTrim((HttpServletRequest)this, PARAM_END_TIME);
    }

    public String getOrderField() {
        return RequestUtil.getParameterAndTrim((HttpServletRequest)this, PRAM_ORDER_FIELD);
    }

    public String getOrderFlag() {
        return RequestUtil.getParameterAsTrimed((HttpServletRequest)this, PARAM_ORDER_FLAG, ORDER_FLAG_ASC);
    }

    public SearchFilter getPageSearchFiler() {
        int pageNo = this.getPageNo();
        int pageSize = this.getPageSize();
        SearchFilter sf = SearchFilter.getSearchFilter(pageNo, pageSize);
        if (pageNo != 0 || pageSize != 20) {
            sf.setCacheable(false);
        }
        if (StringHelper.isEmpty(sf.getOrderBy())) {
            sf.setOrderBy(DEFAULT_ORDER_BY);
        }
        return sf;
    }

    public String getSearchOperator() {
        return RequestUtil.getParameterAsTrimed((HttpServletRequest)this, "sOpr", null);
    }

    public boolean isSearchOperator(String operator) {
        String actual = this.getSearchOperator();
        return actual == null ? false : actual.equals(operator);
    }

    public int getId() {
        return RequestUtil.getParameterAsInt((HttpServletRequest)this, PARAM_ID, 0);
    }

    public int[] getIdArray() {
        String ids = RequestUtil.getParameterAndTrim((HttpServletRequest)this, PARAM_ID_ARRAY);
        return StringHelper.split2IntArray(ids);
    }

    public String getSearchField() {
        return RequestUtil.getParameterAsTrimed((HttpServletRequest)this, PARAM_SEARCH_FIELD, null);
    }

    public boolean isSearchField(String field) {
        String actual = this.getSearchField();
        return actual == null ? false : actual.equals(field);
    }

    public String getSearchWord() {
        return RequestUtil.getParameterAsTrimed((HttpServletRequest)this, PARAM_SEARCH_WORD, "");
    }

    public int getPageNo() {
        return RequestUtil.getParameterAsInt((HttpServletRequest)this, PARAM_PAGENO, 0);
    }

    public int getPageSize() {
        return RequestUtil.getParameterAsInt((HttpServletRequest)this, PARAM_PAGESIZE, 20);
    }

    public int getFormId() {
        return RequestUtil.getParameterAsInt((HttpServletRequest)this, "element.id", 0);
    }

    public String buildView(String view) {
        return view;
    }

    public String buildInfoTipView(String title, String message, ModelMap model, String flag) {
        model.addAttribute((Object)title);
        model.addAttribute((Object)message);
        return String.valueOf(flag) + "/" + INFO_TIP_VIEW;
    }

    public String buildErrorTipView(String title, String message, ModelMap model, String flag) {
        model.addAttribute((Object)title);
        model.addAttribute((Object)message);
        return String.valueOf(flag) + "/" + ERROR_TIP_VIEW;
    }

    public String getUserNameFromHost(String domain) {
        int iFirstDot;
        LOG.debug((Object)("Domain:" + domain));
        if (StringHelper.isEmpty(domain)) {
            return null;
        }
        String serverName = this.getRequest().getServerName();
        LOG.debug((Object)("ServerName:" + serverName));
        if (serverName.equalsIgnoreCase(domain)) {
            return null;
        }
        String userName = null;
        if (serverName.endsWith(domain) && (iFirstDot = serverName.indexOf(46)) > 0) {
            userName = serverName.substring(0, iFirstDot);
            LOG.debug((Object)("UserName(" + userName + ") parsed from remoteHost(" + serverName + ") with domain(" + domain + ")."));
        }
        return userName;
    }
}

