/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import com.trs.dev4.jdk16.utils.EnvConst;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayUtil {
    public static Integer[] toIntegerArray(int[] values) {
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = new Integer(values[i]);
            ++i;
        }
        return result;
    }

    public static Object[] toBooleanArray(boolean[] values) {
        if (values == null) {
            return null;
        }
        Object[] result = new Boolean[values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Boolean(values[i]);
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(Integer[] values) {
        if (values == null) {
            return null;
        }
        int[] result = new int[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(String[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> temps = new ArrayList<Integer>();
        int i = 0;
        while (i < values.length) {
            try {
                temps.add(Integer.valueOf(values[i]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return ArrayUtil.toIntArray(temps.toArray(new Integer[0]));
    }

    public static String[] keysToString(Map<String, ? extends Object> map) {
        return map.keySet().toArray(new String[0]);
    }

    public static String[] listToString(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] intArray = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            intArray[i] = list.get(i);
            ++i;
        }
        return intArray;
    }

    public static boolean compareArrayValue(int[] a, int[] b) {
        if (a.length == b.length && a.length != 0) {
            int i = 0;
            while (i < a.length) {
                boolean flag = false;
                int j = 0;
                while (j < b.length) {
                    if (a[i] == b[j]) {
                        flag = true;
                    }
                    ++j;
                }
                if (!flag) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static int[] getArrayValuesExceeded(int[] a, int[] b) {
        ArrayList<Integer> arrayValuesExceededIntegerList = new ArrayList<Integer>();
        int i = 0;
        while (i < a.length) {
            boolean flag = false;
            int j = 0;
            while (j < b.length) {
                if (a[i] == b[j]) {
                    flag = true;
                }
                ++j;
            }
            if (!flag) {
                arrayValuesExceededIntegerList.add(a[i]);
            }
            ++i;
        }
        return ArrayUtil.toIntArray(arrayValuesExceededIntegerList);
    }

    public static <T> boolean contain(T[] anArray, T anElement) {
        if (anArray == null) {
            return false;
        }
        int i = 0;
        while (i < anArray.length) {
            if (anArray[i].equals(anElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean prefixMatch(String[] anArray, String anElement) {
        if (anArray == null) {
            return false;
        }
        int i = 0;
        while (i < anArray.length) {
            if (anArray[i] != null && anArray.length != 0 && anElement.startsWith(anArray[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toString(Object[] aryObjects) {
        if (aryObjects == null) {
            return "null";
        }
        int maxIndex = aryObjects.length - 1;
        if (maxIndex < 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(maxIndex + 1).append(" elements: [");
        sb.append(EnvConst.NEWLINE);
        int i = 0;
        while (i < maxIndex) {
            sb.append(i).append(":").append(aryObjects[i]);
            sb.append(EnvConst.NEWLINE);
            ++i;
        }
        sb.append(maxIndex).append(":").append(aryObjects[maxIndex]);
        sb.append("]");
        return sb.toString();
    }

    public static String toString(int[] values) {
        return ArrayUtil.toString((Object[])ArrayUtil.toIntegerArray(values));
    }

    public static String toString(boolean[] values) {
        return ArrayUtil.toString(ArrayUtil.toBooleanArray(values));
    }

    public static int[] createSequencedPositiveIntArray(int length) {
        int[] result = new int[length];
        int i = 0;
        while (i < result.length) {
            result[i] = i + 1;
            ++i;
        }
        return result;
    }

    public static <T> T[] expand(T[] srcArray, T[] deltaArray) {
        AssertUtil.notNull(srcArray, "srcArray is null.");
        AssertUtil.notNull(deltaArray, "deltaArray is null.");
        int originLength = srcArray.length;
        Object destArray = Array.newInstance(srcArray.getClass().getComponentType(), originLength + deltaArray.length);
        System.arraycopy(srcArray, 0, destArray, 0, originLength);
        System.arraycopy(deltaArray, 0, destArray, originLength, deltaArray.length);
        return (Object[])destArray;
    }

    public static int[] expand(int[] srcArray, int[] deltaArray) {
        AssertUtil.notNull(srcArray, "srcArray is null.");
        AssertUtil.notNull(deltaArray, "deltaArray is null.");
        int originLength = srcArray.length;
        Object destArray = Array.newInstance(srcArray.getClass().getComponentType(), originLength + deltaArray.length);
        System.arraycopy(srcArray, 0, destArray, 0, originLength);
        System.arraycopy(deltaArray, 0, destArray, originLength, deltaArray.length);
        return (int[])destArray;
    }

    public static <T> boolean equals(T[] oneArray, T[] anotherArray) {
        return Arrays.equals(oneArray, anotherArray);
    }

    public static <T> boolean equalsIgnoreOrder(T[] oneArray, T[] anotherArray) {
        List<T> oneList = Arrays.asList(oneArray);
        List<T> anotherList = Arrays.asList(anotherArray);
        return CollectionUtil.equalsRegardlessOfOrder(oneList, anotherList);
    }

    public static boolean isEmpty(Object[] objArray) {
        return objArray == null || objArray.length == 0;
    }
}

