/*
 * Decompiled with CFR 0.152.
 */
package com.trs.deployer.factory;

import com.trs.deployer.domain.IDeployerHandler;
import com.trs.infra.discover.DiscoveryFactory;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.util.DiscoveryServletHelper;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DeployerHandlerFactory {
    private static Logger logger = Logger.getLogger(DeployerHandlerFactory.class);

    public static List getDeployerHandlers(int n) {
        Iterator iterator = DeployerHandlerFactory.getAllHandlers();
        ArrayList<IDeployerHandler> arrayList = new ArrayList<IDeployerHandler>();
        if (iterator == null) {
            return arrayList;
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                IDeployerHandler iDeployerHandler = (IDeployerHandler)Class.forName(string).newInstance();
                if (n >= iDeployerHandler.getVersionNumber()) continue;
                arrayList.add(iDeployerHandler);
            }
            catch (Exception exception) {
                logger.error((Object)"\u6839\u636e\u7c7b\u540d\u521b\u5efa\u5b9e\u4f8b\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static List getDeployerHandlers(int n, int n2) {
        List list = DeployerHandlerFactory.getDeployerHandlers(n);
        for (int i = list.size() - 1; i >= 0; --i) {
            IDeployerHandler iDeployerHandler = (IDeployerHandler)list.get(i);
            if (iDeployerHandler.getType() == n2) continue;
            list.remove(iDeployerHandler);
        }
        return list;
    }

    public static List getDeployerHandler(String[] stringArray, int n, int n2) {
        Object object;
        int n3;
        List list = DeployerHandlerFactory.getDeployerHandlers(n, n2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (stringArray == null || stringArray.length == 0) {
            return list;
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            IDeployerHandler iDeployerHandler;
            object = stringArray[n3];
            try {
                iDeployerHandler = (IDeployerHandler)Class.forName((String)object).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            if (n >= iDeployerHandler.getVersionNumber() || n2 != iDeployerHandler.getType()) continue;
            arrayList.add(iDeployerHandler);
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            object = (IDeployerHandler)list.get(n3);
            boolean bl = false;
            String string = object.getClass().getName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private static Iterator getAllHandlers() {
        String string = DeployerHandlerFactory.class.getResource("/").getPath();
        File[] fileArray = new File[]{new File(string)};
        String string2 = CMyString.setStrEndWith((String)ConfigServer.getServer().getInitProperty("WCM_PATH"), (char)File.separatorChar);
        File[] fileArray2 = new File[]{new File(string2 + "WEB-INF" + File.separator + "lib")};
        IDiscovery iDiscovery = DiscoveryServletHelper.getDiscovery();
        if (iDiscovery == null) {
            iDiscovery = DiscoveryFactory.create((File[])fileArray2, (File[])fileArray);
            DiscoveryServletHelper.setDiscovery((IDiscovery)iDiscovery);
        }
        Iterator iterator = iDiscovery.getImplementors(IDeployerHandler.class.getName());
        return iterator;
    }
}

