/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.impl;

import com.trs.infra.session.impl.ChainNode;
import java.util.Iterator;

class ChainList {
    private String name;
    private String alias;
    private ChainNode pole;
    private int size;

    public ChainList(String name) {
        this(name, null);
    }

    public ChainList(String name, String nick) {
        this.name = name;
        this.alias = nick;
        this.size = 0;
        this.pole.next = this.pole = new ChainNode();
        this.pole.prev = this.pole;
    }

    public synchronized void add(ChainNode node) {
        if (node.list != null) {
            return;
        }
        ChainNode tail = this.pole.prev;
        node.list = this;
        tail.next = node;
        node.prev = tail;
        node.next = this.pole;
        this.pole.prev = node;
        ++this.size;
    }

    public synchronized boolean cut(ChainNode node) {
        if (this.size == 0) {
            return false;
        }
        if (node.list == null || node.list != this) {
            return false;
        }
        node.list = null;
        node.next.prev = node.prev;
        node.prev.next = node.next;
        node.prev = null;
        node.next = null;
        --this.size;
        return true;
    }

    public boolean cutByValue(Object value) {
        if (value == null) {
            return false;
        }
        ChainNode poleLocal = this.pole;
        ChainNode peek = poleLocal.next;
        while (peek != poleLocal) {
            if (peek.value == value) {
                return this.cut(peek);
            }
            peek = peek.next;
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public String alias() {
        return this.alias;
    }

    public synchronized int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            ChainNode peek;
            {
                this.peek = ChainList.this.pole;
            }

            public boolean hasNext() {
                return this.peek.next != ChainList.this.pole;
            }

            public Object next() {
                this.peek = this.peek.next;
                return this.peek.value;
            }

            public void remove() {
            }
        };
    }
}

