/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.shell;

import com.trs.infra.cluster.debug.DebugManagerImpl;
import com.trs.infra.cluster.debug.DebugMessage;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.shell.ClusterConsole;
import com.trs.infra.cluster.shell.Command;

class SendDebug
extends Command {
    SendDebug() {
        super("senddebug", "send debug message.");
        this.argNames = new String[]{"LoopCount", "LoopInterval", "Message"};
    }

    void execute() {
        int count = this.parseInt(this.argValues[0], 10);
        int interval = this.parseInt(this.argValues[1], 100);
        String temp = this.argValues[2];
        System.out.println("Sending message....");
        ClusterContextImpl ctxt = ClusterConsole.context;
        DebugManagerImpl dmi = (DebugManagerImpl)ctxt.getDebugManager();
        int c = 0;
        while (count-- > 0) {
            DebugMessage msg = dmi.buildDebugMessage();
            if (temp != null && temp.trim().length() > 0) {
                msg.setMessageBody(temp);
            }
            ctxt.send(msg);
            if (++c == 100) {
                c = 0;
                System.out.println("100 message sened.");
            }
            if (count <= 0) continue;
            this.sleepSomeMillis(interval);
        }
        System.out.println("Debug message sended.");
        this.sleepSomeMillis(10000);
        dmi.debug();
    }
}

