/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.ack;

import com.trs.infra.cluster.ACK;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.ack.ACKImplResultImp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ACKImpl
implements ACK {
    private List expects;
    private List results;
    private ACK.State state;
    private long stateTime;
    private Throwable tracer;
    private long waitTime;

    public ACKImpl(List expects) {
        this.expects = expects;
        this.results = new ArrayList(expects.size());
        this.state(ACK.State.NEW);
    }

    public Iterator expects() {
        return this.expects.iterator();
    }

    public ACK.State state() {
        return this.state;
    }

    public void state(ACK.State state) {
        this.state = state;
        this.stateTime = System.currentTimeMillis();
    }

    public long stateTime() {
        return this.stateTime;
    }

    public Throwable waitTracer() {
        return this.tracer;
    }

    public void waitFor() {
        this.waitFor(0, 0L);
    }

    public void waitFor(boolean onlyFirst) {
        if (onlyFirst) {
            this.waitFor(1, 0L);
        } else {
            this.waitFor(0, 0L);
        }
    }

    public synchronized boolean waitFor(int responseCount, long maxTimeMillis) {
        if (this.state == ACK.State.FINISH) {
            return true;
        }
        if (this.state == ACK.State.FAIL) {
            return false;
        }
        long startTime = maxTimeMillis <= 0L ? 0L : System.currentTimeMillis();
        this.waitTime = maxTimeMillis <= 0L ? 0L : maxTimeMillis;
        int expectsCount = this.expects.size();
        int respCount = responseCount > expectsCount ? expectsCount : responseCount;
        while (true) {
            try {
                this.wait(this.waitTime);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            if (this.state == ACK.State.FINISH) {
                return true;
            }
            if (this.state == ACK.State.FAIL) {
                return false;
            }
            if (this.results.size() == expectsCount || respCount > 0 && this.results.size() >= respCount) {
                return true;
            }
            if (this.waitTime <= 0L) continue;
            this.waitTime = maxTimeMillis - (System.currentTimeMillis() - startTime);
            if (this.waitTime < 0L) break;
        }
        return false;
    }

    public ACK.Result result(boolean max_min) {
        this.waitFor(0, 0L);
        ACK.Result maxminResult = null;
        Iterator itr = this.results.iterator();
        while (itr.hasNext()) {
            Object resultValue;
            ACK.Result result = (ACK.Result)itr.next();
            if (result == null || (resultValue = result.getValue()) == null || !(resultValue instanceof Comparable)) continue;
            Comparable compareValue = (Comparable)resultValue;
            if (maxminResult == null) {
                maxminResult = result;
                continue;
            }
            if (max_min) {
                if (compareValue.compareTo(maxminResult.getValue()) <= 0) continue;
                maxminResult = result;
                continue;
            }
            if (compareValue.compareTo(maxminResult.getValue()) >= 0) continue;
            maxminResult = result;
        }
        return maxminResult;
    }

    public ACK.Result result(int ordinal) {
        if (this.results.size() <= ordinal) {
            this.waitFor(ordinal, 0L);
        }
        return (ACK.Result)this.results.get(ordinal);
    }

    public int resultCount() {
        if (this.state == ACK.State.NEW) {
            throw new IllegalStateException("Message need ACK not send yet.");
        }
        return this.results.size();
    }

    public Iterator results() {
        if (this.state == ACK.State.NEW) {
            throw new IllegalStateException("Message need ACK not send yet.");
        }
        return this.results.iterator();
    }

    public synchronized boolean result(ACK.Result result) {
        this.results.add(result);
        this.notifyAll();
        if (this.results.size() == this.expects.size()) {
            this.state(ACK.State.FINISH);
            return true;
        }
        if (this.waitTime < 0L) {
            this.state(ACK.State.FAIL);
            return true;
        }
        return false;
    }

    public synchronized boolean revokeExpected(Member member) {
        boolean expected = false;
        int i = this.expects.size() - 1;
        while (i >= 0 && !expected) {
            ACK.Expect expect = (ACK.Expect)this.expects.get(i);
            expected = member.equals(expect.getMember());
            --i;
        }
        if (expected) {
            boolean acked = false;
            int i2 = this.results.size() - 1;
            while (i2 >= 0 && !acked) {
                ACK.Result result = (ACK.Result)this.results.get(i2);
                acked = member.equals(result.getMember());
                --i2;
            }
            return acked ? false : this.result(new ACKImplResultImp(member));
        }
        return false;
    }
}

