/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.ui.context.Theme;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ThemeResolver;

public abstract class RequestContextUtils {
    public static WebApplicationContext getWebApplicationContext(ServletRequest request) throws IllegalStateException {
        return RequestContextUtils.getWebApplicationContext(request, null);
    }

    public static WebApplicationContext getWebApplicationContext(ServletRequest request, ServletContext servletContext) throws IllegalStateException {
        WebApplicationContext webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: not in a DispatcherServlet request?");
            }
            webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(servletContext);
            if (webApplicationContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
            }
        }
        return webApplicationContext;
    }

    public static LocaleResolver getLocaleResolver(HttpServletRequest request) throws IllegalStateException {
        LocaleResolver localeResolver = (LocaleResolver)request.getAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE);
        if (localeResolver == null) {
            throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
        }
        return localeResolver;
    }

    public static Locale getLocale(HttpServletRequest request) throws IllegalStateException {
        return RequestContextUtils.getLocaleResolver(request).resolveLocale(request);
    }

    public static ThemeResolver getThemeResolver(HttpServletRequest request) throws IllegalStateException {
        ThemeResolver themeResolver = (ThemeResolver)request.getAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE);
        if (themeResolver == null) {
            throw new IllegalStateException("No ThemeResolver found: not in a DispatcherServlet request?");
        }
        return themeResolver;
    }

    public static Theme getTheme(HttpServletRequest request) throws IllegalStateException {
        WebApplicationContext context = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        String themeName = RequestContextUtils.getThemeResolver(request).resolveThemeName(request);
        return context.getTheme(themeName);
    }

    public static MultipartResolver getMultipartResolver(ServletRequest request) {
        return (MultipartResolver)request.getAttribute(DispatcherServlet.MULTIPART_RESOLVER_ATTRIBUTE);
    }
}

