/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.support;

import javax.ejb.EnterpriseBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.access.ContextJndiBeanFactoryLocator;

abstract class AbstractEnterpriseBean
implements EnterpriseBean {
    public static final String BEAN_FACTORY_PATH_ENVIRONMENT_KEY = "java:comp/env/ejb/BeanFactoryPath";
    private BeanFactoryLocator beanFactoryLocator;
    private String beanFactoryLocatorKey;
    private BeanFactoryReference beanFactoryReference;

    AbstractEnterpriseBean() {
    }

    public void setBeanFactoryLocator(BeanFactoryLocator beanFactoryLocator) {
        this.beanFactoryLocator = beanFactoryLocator;
    }

    public void setBeanFactoryLocatorKey(String factoryKey) {
        this.beanFactoryLocatorKey = factoryKey;
    }

    void loadBeanFactory() throws BeansException {
        if (this.beanFactoryLocator == null) {
            this.beanFactoryLocator = new ContextJndiBeanFactoryLocator();
        }
        if (this.beanFactoryLocatorKey == null) {
            this.beanFactoryLocatorKey = BEAN_FACTORY_PATH_ENVIRONMENT_KEY;
        }
        this.beanFactoryReference = this.beanFactoryLocator.useBeanFactory(this.beanFactoryLocatorKey);
    }

    void unloadBeanFactory() throws FatalBeanException {
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactoryReference.getFactory();
    }

    public void ejbRemove() {
        this.onEjbRemove();
        this.unloadBeanFactory();
    }

    protected void onEjbRemove() {
    }
}

