/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ClassFilters;

class UnionPointcut
implements Pointcut,
Serializable {
    private final Pointcut a;
    private final Pointcut b;
    private MethodMatcher mm;

    public UnionPointcut(Pointcut a, Pointcut b) {
        this.a = a;
        this.b = b;
        this.mm = new PointcutUnionMethodMatcher();
    }

    public ClassFilter getClassFilter() {
        return ClassFilters.union(this.a.getClassFilter(), this.b.getClassFilter());
    }

    public MethodMatcher getMethodMatcher() {
        return this.mm;
    }

    private class PointcutUnionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private PointcutUnionMethodMatcher() {
        }

        public boolean matches(Method m, Class targetClass) {
            return UnionPointcut.this.a.getClassFilter().matches(targetClass) && UnionPointcut.this.a.getMethodMatcher().matches(m, targetClass) || UnionPointcut.this.b.getClassFilter().matches(targetClass) && UnionPointcut.this.b.getMethodMatcher().matches(m, targetClass);
        }

        public boolean isRuntime() {
            return UnionPointcut.this.a.getMethodMatcher().isRuntime() || UnionPointcut.this.b.getMethodMatcher().isRuntime();
        }

        public boolean matches(Method m, Class targetClass, Object[] args) {
            return UnionPointcut.this.a.getMethodMatcher().matches(m, targetClass, args) || UnionPointcut.this.b.getMethodMatcher().matches(m, targetClass, args);
        }
    }
}

