/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParserUtils {
    private static DocumentBuilderFactory dbf = null;
    private static List allocatedBuildersList = new ArrayList(10);
    static /* synthetic */ Class class$org$xml$sax$InputSource;

    public static synchronized void refreshDocumentBuilderFactory(String factoryClassName, boolean namespaceAware, boolean validating) {
        XMLParserUtils.refreshDocumentBuilderFactory(factoryClassName, namespaceAware, validating, false);
    }

    public static synchronized void refreshDocumentBuilderFactory(String factoryClassName, boolean namespaceAware, boolean validating, boolean expandEntityReferences) {
        if (factoryClassName != null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", factoryClassName);
        }
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        dbf.setValidating(validating);
        dbf.setExpandEntityReferences(expandEntityReferences);
        try {
            if (dbf.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactory")) {
                dbf.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (dbf.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactory")) {
                dbf.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public static synchronized DocumentBuilder getXMLDocBuilder() throws IllegalArgumentException {
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalArgumentException(pce.toString());
        }
    }

    public static synchronized DocumentBuilder getXMLDocBuilderFromPool() {
        DocumentBuilder builder = null;
        int size = allocatedBuildersList.size();
        if (size > 0) {
            builder = (DocumentBuilder)allocatedBuildersList.get(size - 1);
            allocatedBuildersList.remove(size - 1);
        } else {
            builder = XMLParserUtils.getXMLDocBuilder();
        }
        return builder;
    }

    public static synchronized void returnDocumentBuilderToPool(DocumentBuilder builder) {
        if (builder != null) {
            allocatedBuildersList.add(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilderFromPool();
        Document doc = null;
        try {
            doc = xdb.newDocument();
        }
        finally {
            XMLParserUtils.returnDocumentBuilderToPool(xdb);
        }
        return doc;
    }

    public static Document parse(Reader xmlReader) throws IOException, SAXException {
        return XMLParserUtils.parse(new InputSource(xmlReader), true);
    }

    public static Document parse(String xmlText) throws IOException, SAXException {
        return XMLParserUtils.parse(new InputSource(xmlText), true);
    }

    public static Document parse(String xmlText, boolean useDocumentBuilder) throws IOException, SAXException {
        return XMLParserUtils.parse(new InputSource(new StringReader(xmlText)), useDocumentBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputSource xmlSource, boolean useDocumentBuilder) throws IOException, SAXException {
        if (!useDocumentBuilder) {
            try {
                Class<?> domResultClass = Class.forName("javax.xml.transform.dom.DOMResult");
                Class<?> transformerFactoryClass = Class.forName("javax.xml.transform.TransformerFactory");
                Class<?> transformerClass = Class.forName("javax.xml.transform.Transformer");
                Class<?> saxSourceClass = Class.forName("javax.xml.transform.sax.SAXSource");
                Class<?> sourceClass = Class.forName("javax.xml.transform.Source");
                Class<?> resultClass = Class.forName("javax.xml.transform.Result");
                Object output = domResultClass.newInstance();
                Object source = saxSourceClass.newInstance();
                Method method = transformerFactoryClass.getDeclaredMethod("newInstance", new Class[0]);
                Object xformFactory = method.invoke(null, new Object[0]);
                method = transformerFactoryClass.getDeclaredMethod("newTransformer", new Class[0]);
                Object idTransform = method.invoke(xformFactory, new Object[0]);
                method = saxSourceClass.getDeclaredMethod("setInputSource", class$org$xml$sax$InputSource == null ? (class$org$xml$sax$InputSource = XMLParserUtils.class$("org.xml.sax.InputSource")) : class$org$xml$sax$InputSource);
                method.invoke(source, xmlSource);
                method = transformerClass.getDeclaredMethod("transform", sourceClass, resultClass);
                method.invoke(idTransform, source, output);
                method = domResultClass.getDeclaredMethod("getNode", new Class[0]);
                return (Document)method.invoke(output, new Object[0]);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilderFromPool();
        Document doc = null;
        try {
            doc = xdb.parse(xmlSource);
        }
        finally {
            XMLParserUtils.returnDocumentBuilderToPool(xdb);
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        XMLParserUtils.refreshDocumentBuilderFactory(null, true, false, false);
    }
}

