/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;
import org.apache.soap.util.net.HTTPUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TransportMessage
implements Serializable {
    protected String contentType = null;
    protected int offset = 0;
    protected byte[] bytes = null;
    protected String envelope = null;
    protected Hashtable headers = null;
    protected SOAPContext ctx = null;
    protected boolean rootPartIsEnvelope;
    protected Document envelopeDocument = null;
    protected Envelope soapEnvelope = null;

    public TransportMessage() {
    }

    public TransportMessage(String envelope, SOAPContext ctx, Hashtable headers) {
        this.envelope = envelope;
        this.rootPartIsEnvelope = false;
        this.ctx = ctx;
        this.headers = headers != null ? headers : new Hashtable();
    }

    public TransportMessage(InputStream is, int contentLength, String contentType, SOAPContext ctx, Hashtable headers) throws IOException, SOAPException {
        this.headers = headers != null ? headers : new Hashtable();
        this.ctx = ctx;
        this.contentType = contentType;
        this.bytes = new byte[contentLength >= 0 ? contentLength : 4096];
        if (contentLength != 0) {
            byte[] newbuf;
            int offset = 0;
            int bytesRead = 0;
            while ((contentLength < 0 || offset < contentLength) && bytesRead >= 0) {
                bytesRead = is.read(this.bytes, offset, this.bytes.length - offset);
                if (bytesRead <= 0 || contentLength >= 0 || (offset += bytesRead) < this.bytes.length) continue;
                newbuf = new byte[this.bytes.length * 2];
                System.arraycopy(this.bytes, 0, newbuf, 0, this.bytes.length);
                this.bytes = newbuf;
            }
            if (contentLength < 0) {
                if (offset < this.bytes.length) {
                    newbuf = new byte[offset];
                    System.arraycopy(this.bytes, 0, newbuf, 0, offset);
                    this.bytes = newbuf;
                }
            } else if (offset < contentLength) {
                throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Premature end of stream. Data is truncated. Read " + offset + " bytes successfully, expected " + contentLength);
            }
        }
    }

    public void editIncoming(EnvelopeEditor editor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(editor, true);
    }

    public void editOutgoing(EnvelopeEditor editor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(editor, false);
    }

    protected void editEnvelope(EnvelopeEditor editor, boolean isIncoming) throws SOAPException, IOException, MessagingException {
        if (editor != null) {
            if (this.getEnvelope() == null) {
                return;
            }
            StringWriter tout = new StringWriter();
            if (isIncoming) {
                editor.editIncoming(this.getEnvelopeReader(), tout);
            } else {
                editor.editOutgoing(this.getEnvelopeReader(), tout);
            }
            tout.flush();
            this.envelope = tout.toString();
            this.rootPartIsEnvelope = false;
        }
    }

    public String read() throws MessagingException, IOException, SOAPException {
        ContentType rootContentType;
        byte[] rootBytes;
        ContentType cType = null;
        if (this.contentType != null) {
            int pos = this.contentType.indexOf(";;");
            if (pos != -1) {
                this.contentType = this.contentType.substring(0, pos) + this.contentType.substring(pos + 1);
            }
            cType = MimeUtils.getContentType(this.contentType);
        }
        if (cType == null) {
            if (this.ctx.getOneWay()) {
                return null;
            }
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Missing content type.");
        }
        String encoding = HTTPUtils.getHeaderValue(this.headers, "Accept-Encoding");
        if (encoding != null) {
            this.ctx.setAcceptGzip(encoding.indexOf("gzip") != -1);
        }
        encoding = HTTPUtils.getHeaderValue(this.headers, "Content-Encoding");
        boolean gzip = false;
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            gzip = true;
        }
        this.ctx.setGzip(gzip);
        if (gzip) {
            int bytesread;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
            GZIPInputStream gzis = new GZIPInputStream(bais);
            byte[] newbytes = new byte[this.bytes.length * 4];
            int totalread = 0;
            while ((bytesread = gzis.read(newbytes, totalread, newbytes.length - totalread)) != -1) {
                if ((totalread += bytesread) < newbytes.length) continue;
                byte[] newerbytes = new byte[totalread * 4];
                System.arraycopy(newbytes, 0, newerbytes, 0, totalread);
                newbytes = newerbytes;
            }
            gzis.close();
            bais.close();
            this.bytes = new byte[totalread];
            System.arraycopy(newbytes, 0, this.bytes, 0, totalread);
        }
        if (!Constants.CTYPE_MULTIPART.match(cType)) {
            rootBytes = this.bytes;
            rootContentType = cType;
            if (Constants.CTYPE_TEXT_ALL.match(rootContentType)) {
                String charset = rootContentType.getParameter("charset");
                if (charset == null || charset.equals("")) {
                    charset = "iso-8859-1";
                }
                this.envelope = new String(rootBytes, MimeUtility.javaCharset((String)charset));
                this.ctx.setRootPart(this.envelope, this.contentType);
            } else {
                this.ctx.setRootPart(this.bytes, this.contentType);
            }
            return this.envelope;
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(this.bytes, this.contentType);
        this.ctx.readMultipart(ds);
        MimeBodyPart rootPart = this.ctx.getRootPart();
        rootContentType = MimeUtils.getContentType(rootPart.getContentType());
        ByteArrayDataSource bads = new ByteArrayDataSource(rootPart.getInputStream(), null);
        rootBytes = bads.toByteArray();
        if (Constants.CTYPE_TEXT_ALL.match(rootContentType)) {
            String charset = rootContentType.getParameter("charset");
            if (charset == null || charset.equals("")) {
                charset = "iso-8859-1";
            }
            this.envelope = new String(rootBytes, MimeUtility.javaCharset((String)charset));
        }
        return this.envelope;
    }

    public Envelope unmarshall(DocumentBuilder xdb) throws SOAPException {
        try {
            this.envelopeDocument = xdb.parse(new InputSource(this.getEnvelopeReader()));
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: " + e, e);
        }
        if (this.envelopeDocument == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: received empty document");
        }
        this.soapEnvelope = Envelope.unmarshall(this.envelopeDocument.getDocumentElement());
        return this.soapEnvelope;
    }

    public void save() throws MessagingException, IOException {
        String rootContentType = null;
        if (this.getEnvelope() != null && !this.rootPartIsEnvelope) {
            rootContentType = "text/xml;charset=utf-8";
            this.ctx.setRootPart(this.envelope, "text/xml;charset=utf-8");
            this.rootPartIsEnvelope = true;
        } else {
            rootContentType = this.ctx.getRootPartContentType();
            if (rootContentType == null) {
                rootContentType = "text/xml;charset=utf-8";
            }
        }
        if (this.ctx.getCount() == 1) {
            this.bytes = this.envelope.getBytes(MimeUtils.getEncoding(rootContentType, "UTF8"));
            this.offset = 0;
            this.contentType = rootContentType;
        } else {
            ByteArrayOutputStream payload = new ByteArrayOutputStream(65536);
            this.ctx.writeTo(payload);
            this.bytes = payload.toByteArray();
            StringBuffer namebuf = new StringBuffer(64);
            StringBuffer valuebuf = new StringBuffer(64);
            boolean parsingName = true;
            this.offset = 0;
            while (this.offset < this.bytes.length) {
                if (this.bytes[this.offset] == 10) {
                    if (this.offset + 1 < this.bytes.length && (this.bytes[this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9)) {
                        while (++this.offset + 1 < this.bytes.length && (this.bytes[this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9)) {
                        }
                    } else {
                        if (namebuf.length() == 0) {
                            ++this.offset;
                            break;
                        }
                        String name = namebuf.toString();
                        if (name.equals("Content-Type")) {
                            this.contentType = valuebuf.toString();
                            if (this.ctx.getCount() > 1) {
                                String rootCID = this.ctx.getRootPart().getContentID();
                                this.contentType = this.contentType + "; type=\"text/xml\"; start=\"" + rootCID + '\"';
                            }
                        }
                        namebuf = new StringBuffer(64);
                        valuebuf = new StringBuffer(64);
                        parsingName = true;
                    }
                } else if (this.bytes[this.offset] != 13) {
                    if (parsingName) {
                        if (this.bytes[this.offset] == 58) {
                            parsingName = false;
                            ++this.offset;
                        } else {
                            namebuf.append((char)this.bytes[this.offset]);
                        }
                    } else {
                        valuebuf.append((char)this.bytes[this.offset]);
                    }
                }
                ++this.offset;
            }
        }
        this.headers.put("Accept-Encoding", "gzip");
        if (Boolean.TRUE.equals(this.ctx.getGzip())) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bytes.length);
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            gzos.write(this.bytes, this.offset, this.bytes.length - this.offset);
            gzos.close();
            baos.close();
            this.bytes = baos.toByteArray();
            this.offset = 0;
            this.headers.put("Content-Encoding", "gzip");
        }
    }

    public SOAPContext getSOAPContext() {
        return this.ctx;
    }

    public String getEnvelope() {
        if (this.envelope == null) {
            this.envelope = this.ctx.getEnvelope();
        }
        return this.envelope;
    }

    public Reader getEnvelopeReader() {
        if (this.getEnvelope() == null) {
            return null;
        }
        return new StringReader(this.envelope);
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
        this.rootPartIsEnvelope = false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.bytes.length - this.offset;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        outStream.write(this.bytes, this.offset, this.bytes.length - this.offset);
        outStream.flush();
    }

    public void setBytes(byte[] data) {
        this.offset = 0;
        this.bytes = data;
    }

    public void readFully(InputStream is) throws IOException {
        this.offset = 0;
        ByteArrayDataSource bads = new ByteArrayDataSource(is, null);
        this.bytes = bads.toByteArray();
    }

    public byte[] getBytes() {
        if (this.offset != 0) {
            byte[] data = new byte[this.bytes.length - this.offset];
            System.arraycopy(this.bytes, this.offset, data, 0, data.length);
            this.bytes = data;
            this.offset = 0;
        }
        return this.bytes;
    }
}

