/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.taglib.DataAware;
import de.laures.cewolf.taglib.util.DatasetProductionTimeStore;
import de.laures.cewolf.taglib.util.KeyGenerator;
import de.laures.cewolf.util.Assert;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.general.Dataset;

public class DataContainer
implements DataAware,
Serializable {
    private static final transient Log log = LogFactory.getLog((Class)(class$de$laures$cewolf$taglib$ChartImageDefinition == null ? (class$de$laures$cewolf$taglib$ChartImageDefinition = DataContainer.class$("de.laures.cewolf.taglib.ChartImageDefinition")) : class$de$laures$cewolf$taglib$ChartImageDefinition));
    private transient Dataset data;
    private transient DatasetProducer producer;
    private Map datasetProductionParams;
    private long datasetProduceTime;
    private boolean useCache = true;
    static /* synthetic */ Class class$de$laures$cewolf$taglib$ChartImageDefinition;

    public void setDataProductionConfig(DatasetProducer dsp, Map params, boolean useCache) {
        log.debug((Object)"setDataProductionConfig");
        this.producer = dsp;
        this.datasetProductionParams = params;
        this.useCache = useCache;
        this.checkDataProductionNeed();
    }

    public Object getDataset() throws DatasetProduceException {
        Assert.check(this.producer != null, "you need to specifiy a producer for the data of the chart.");
        log.debug((Object)"getting data..");
        if (this.data == null) {
            log.debug((Object)("producing new dataset for " + this.producer.getProducerId()));
            this.data = (Dataset)this.producer.produceDataset(this.datasetProductionParams);
            DatasetProductionTimeStore dataCache = DatasetProductionTimeStore.getInstance();
            dataCache.addEntry(this.producer.getProducerId(), this.datasetProductionParams, new Date(this.datasetProduceTime));
        }
        Assert.check(this.data != null, "your producer of type " + this.producer.getClass().getName() + " produced a null dataset.");
        return this.data;
    }

    private void checkDataProductionNeed() {
        log.debug((Object)("checking data actuality..." + this.producer + ", " + this.datasetProductionParams));
        String prodId = this.producer.getProducerId();
        log.debug((Object)(prodId + ", " + KeyGenerator.generateKey((Serializable)((Object)this.datasetProductionParams))));
        log.debug((Object)("useCache = " + this.useCache));
        DatasetProductionTimeStore dataCache = DatasetProductionTimeStore.getInstance();
        if (this.useCache && dataCache.containsEntry(prodId, this.datasetProductionParams)) {
            Date produceTime = dataCache.getProductionTime(prodId, this.datasetProductionParams);
            log.debug((Object)"cached data available.");
            if (!this.producer.hasExpired(this.datasetProductionParams, produceTime)) {
                log.debug((Object)"cached data is still valid.");
                this.datasetProduceTime = produceTime.getTime();
                return;
            }
            dataCache.removeEntry(prodId, this.datasetProductionParams);
        }
        this.datasetProduceTime = System.currentTimeMillis();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

