/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version.config;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.IConfigElement;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class RelationObjectVersionConfig
implements IConfigElement {
    private String name;
    private String id;
    private String classname;
    private String desc;
    private String excludefields;
    private String relationkey;
    private boolean isValid;
    private boolean isVerify = false;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getExcludefields() {
        return this.excludefields;
    }

    public void setExcludefields(String excludefields) {
        this.excludefields = excludefields;
    }

    public String getRelationkey() {
        return this.relationkey;
    }

    public void setRelationkey(String relationkey) {
        this.relationkey = relationkey;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String[] getExcludeFields() {
        String sExcludeFields = this.getExcludefields();
        if (sExcludeFields != null && !CMyString.isEmpty(sExcludeFields)) {
            return sExcludeFields.split(",");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws WCMException {
        if (this.isVerify) {
            return this.isValid;
        }
        RelationObjectVersionConfig relationObjectVersionConfig = this;
        synchronized (relationObjectVersionConfig) {
            if (this.isVerify) {
                return this.isValid;
            }
            this.isValid = this.doVerify();
            this.isVerify = true;
            return this.isValid;
        }
    }

    private boolean doVerify() throws WCMException {
        try {
            CMSBaseObjs cmsObjs = CMSBaseObjs.createInstance(ContextHelper.getLoginUser(), this.classname);
            DBManager oManager = DBManager.getDBManager();
            String sTableName = ((CMSObj)cmsObjs.getElementClass().newInstance()).getDbTableName();
            String[] excludeFields = this.getExcludeFields();
            if (excludeFields != null) {
                for (int i = 0; i < excludeFields.length; ++i) {
                    if (oManager.getFieldInfo(sTableName, excludeFields[i].trim().toUpperCase()) != null) continue;
                    throw new WCMException("\u9a8c\u8bc1" + cmsObjs.getElementClass().getClass().getName() + "\u6392\u9664\u5b57\u6bb5" + excludeFields[i] + "\u9519\u8bef");
                }
            }
            if (oManager.getFieldInfo(sTableName, this.relationkey.trim().toUpperCase()) == null) {
                throw new WCMException("\u9a8c\u8bc1" + cmsObjs.getElementClass().getClass().getName() + "\u5916\u952e" + this.relationkey + "\u9519\u8bef");
            }
            return true;
        }
        catch (Exception e) {
            throw new WCMException("\u5173\u8054\u5bf9\u8c61\u914d\u7f6e\u9519\u8bef", e);
        }
    }
}

