/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishContentImplBase;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.NewRuleOfDetailPageHelper;
import com.trs.components.wcm.publish.PreNextPageRefresher;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.element.IRelateResource;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PublishContentDocumentImpl
extends PublishContentImplBase {
    private static Logger logger = Logger.getLogger(PublishContentDocumentImpl.class);
    private Document m_doc = null;
    private int m_nModal = 0;
    private int m_nStatusInHome = 0;
    private int m_nStatusInCurrentFolder = 0;
    private AppendixMgr m_appendixmgr;
    private String m_sImgScaleSuffix = null;
    private static Set IMAGE_SUFFIX_SET = new HashSet(8);
    private FileNamedStyle m_oCurrFileNameStyle = null;

    public PublishContentDocumentImpl() {
    }

    public PublishContentDocumentImpl(Document _doc) {
        this.setSubstance(_doc);
    }

    @Override
    public void setFolder(IPublishFolder _folder) {
        super.setFolder(_folder);
        this.m_nModal = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getModal() throws WCMException {
        if (this.m_doc.getId() == 0) {
            this.m_nModal = 1;
        }
        if (this.m_nModal == 0) {
            Number value = (Number)this.m_doc.getProperty("MODAL");
            if (value != null) {
                this.m_nModal = Math.abs(value.intValue());
            } else {
                PublishContentDocumentImpl publishContentDocumentImpl = this;
                synchronized (publishContentDocumentImpl) {
                    if (this.m_nModal <= 0) {
                        this.loadPropertiesInChnlDoc();
                    }
                }
            }
        }
        return this.m_nModal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPublishedInHome() throws WCMException {
        if (this.m_nStatusInHome == 0) {
            PublishContentDocumentImpl publishContentDocumentImpl = this;
            synchronized (publishContentDocumentImpl) {
                if (this.m_nStatusInHome != 10) {
                    this.findStatusInHome();
                }
            }
        }
        return this.m_nStatusInHome == 10;
    }

    private void loadPropertiesInChnlDoc() throws WCMException {
        if (this.getFolder() != null) {
            int nFolderId = this.getFolder().getId();
            if (nFolderId == this.m_doc.getChannelId()) {
                this.m_nModal = 1;
                return;
            }
        } else {
            this.m_nModal = 1;
            return;
        }
        String SQL = "SELECT MODAL FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?";
        DBManager dbManager = DBManager.getDBManager();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("SELECT MODAL FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?");
            oPreStmt.setInt(1, this.m_doc.getId());
            oPreStmt.setInt(2, this.getFolder().getId());
            oPreStmt.setMaxRows(1);
            rsData = oPreStmt.executeQuery();
            this.m_nModal = rsData != null && rsData.next() ? Math.abs(rsData.getInt(1)) : 2;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to load the doucment properties from database table WCMChnlDoc!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private synchronized void findStatusInHome() throws WCMException {
        String SQL = "SELECT DOCSTATUS FROM WCMDOCUMENT WHERE DOCID=?";
        DBManager dbManager = DBManager.getDBManager();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("SELECT DOCSTATUS FROM WCMDOCUMENT WHERE DOCID=?");
            oPreStmt.setInt(1, this.m_doc.getId());
            oPreStmt.setMaxRows(1);
            rsData = oPreStmt.executeQuery();
            if (rsData != null && rsData.next()) {
                this.m_nStatusInHome = rsData.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to find the doucment status in its home!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private synchronized void findStatusInCurrentFolder() throws WCMException {
        Channel channel = (Channel)this.getFolder().getSubstance();
        if (channel.isOnlySearch()) {
            channel = this.m_doc.getChannel();
        }
        if (channel == null) {
            return;
        }
        String SQL = "SELECT DOCSTATUS FROM WCMCHNLDOC WHERE DOCID=? and CHNLID=?";
        DBManager dbManager = DBManager.getDBManager();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("SELECT DOCSTATUS FROM WCMCHNLDOC WHERE DOCID=? and CHNLID=?");
            oPreStmt.setInt(1, this.m_doc.getId());
            oPreStmt.setInt(2, channel.getId());
            oPreStmt.setMaxRows(1);
            rsData = oPreStmt.executeQuery();
            if (rsData != null && rsData.next()) {
                this.m_nStatusInCurrentFolder = rsData.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to find the doucment status in its home!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    @Override
    public int getBodyType() {
        if (this.m_doc.getType() == 40 && this.isSWFModeContent()) {
            return 20;
        }
        return this.m_doc.getType();
    }

    @Override
    public void setPublishStatus(int _nStatus) throws WCMException {
        int pubStatus;
        int nStatusId;
        switch (_nStatus) {
            case 10: {
                nStatusId = 16;
                pubStatus = MetaDataConstants.PubStatusEnum.NOTPUBLISHED.value;
                break;
            }
            case 50: {
                nStatusId = 10;
                pubStatus = MetaDataConstants.PubStatusEnum.PUBLISHED.value;
                break;
            }
            default: {
                return;
            }
        }
        Channel channel = (Channel)this.getFolder().getSubstance();
        if (channel.isOnlySearch()) {
            channel = this.m_doc.getChannel();
        }
        if (channel == null) {
            return;
        }
        boolean bIsEntity = channel.getId() == this.m_doc.getChannelId();
        boolean bIsDelete = _nStatus == 10;
        DBManager dbMgr = DBManager.getDBManager();
        Connection conn = dbMgr.getConnection();
        Statement preStm = null;
        try {
            String sUpdateSQL = null;
            sUpdateSQL = "update WCMChnlDoc set DOCStatus=?, PUBSTATUS = ? where DocId=? and ChnlId=? and not DocStatus=? and DocStatus>0";
            preStm = conn.prepareStatement(sUpdateSQL);
            preStm.setInt(1, nStatusId);
            preStm.setInt(2, pubStatus);
            preStm.setInt(3, this.getId());
            preStm.setInt(4, channel.getId());
            preStm.setInt(5, nStatusId);
            preStm.executeUpdate();
            preStm.close();
            if (bIsEntity) {
                sUpdateSQL = "update WCMDocument set DOCStatus=? where DocId=? and DocChannel=? and not DocStatus=? and DocStatus>0";
                preStm = conn.prepareStatement(sUpdateSQL);
                preStm.setInt(1, nStatusId);
                preStm.setInt(2, this.getId());
                preStm.setInt(3, channel.getId());
                preStm.setInt(4, nStatusId);
                preStm.executeUpdate();
                preStm.close();
            }
            if (bIsEntity && bIsDelete) {
                sUpdateSQL = "update WCMChnlDoc set DOCStatus=?, PUBSTATUS = ? where DocId=? and DocStatus=? and PUBSTATUS = ? and Modal=2 ";
                preStm = conn.prepareStatement(sUpdateSQL);
                preStm.setInt(1, nStatusId);
                preStm.setInt(2, pubStatus);
                preStm.setInt(3, this.getId());
                preStm.setInt(4, 10);
                preStm.setInt(5, MetaDataConstants.PubStatusEnum.PUBLISHED.value);
                preStm.executeUpdate();
                preStm.close();
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label1", "\u66f4\u65b0DocStatus\u5931\u8d25\uff01"), e);
        }
        finally {
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            dbMgr.freeConnection(conn);
        }
        if (bIsDelete) {
            boolean bPublishRelDocOnDestroy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("PUBLISH_RELDOC_ON_DESTROY", "false"));
            if (bPublishRelDocOnDestroy) {
                this.publishRelDocumentsByRelation(1);
                this.publishRelDocumentsByRelation(3);
                String sDocKeywords = this.m_doc.getKeywords();
                if (sDocKeywords != null && (sDocKeywords = sDocKeywords.trim()).length() > 0) {
                    String[] pDocKeywords = sDocKeywords.split(";");
                    this.publishRelDocumentsByKeywords(pDocKeywords, 1);
                    this.publishRelDocumentsByKeywords(pDocKeywords, 3);
                }
            }
            PreNextPageRefresher refresher = new PreNextPageRefresher(this.m_doc);
            refresher.refresh();
        }
    }

    private void publishRelDocumentsByKeywords(String[] _pKeywords, int _nModal) throws WCMException {
        StringBuffer sbDocKeyWordWhere = new StringBuffer();
        sbDocKeyWordWhere.append("select 1 from WCMDocKeyword where WCMDocKeyword.DocKeyWord in(");
        boolean bFindKeyword = false;
        for (int i = 0; i < _pKeywords.length; ++i) {
            if (_pKeywords[i].trim().length() == 0) continue;
            bFindKeyword = true;
            sbDocKeyWordWhere.append("?,");
        }
        if (!bFindKeyword) {
            return;
        }
        sbDocKeyWordWhere.setLength(sbDocKeyWordWhere.length() - 1);
        sbDocKeyWordWhere.append(")");
        DBManager dbMgr = DBManager.getDBManager();
        String sWhere = "exists(" + sbDocKeyWordWhere + " and WCMDocKeyword.DocId=WCMChnlDoc.DocId) and Modal=? and DocStatus=" + 10 + " and DocChannel>0";
        String sSelectFields = _nModal == 1 ? "DocId" : "DocId,ChnlId";
        WCMFilter filter = new WCMFilter("WCMChnlDoc", sWhere, "", sSelectFields);
        for (int i = 0; i < _pKeywords.length; ++i) {
            filter.addSearchValues(_pKeywords[i]);
        }
        filter.addSearchValues(_nModal);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        String strSQL = filter.toSQL();
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            DBManager.setParameters(oStmt, filter);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                int nDocId = rsData.getInt(1);
                int nCurrChannelId = _nModal == 1 ? 0 : rsData.getInt(2);
                this.publishDocumentSelf(nDocId, nCurrChannelId);
            }
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void publishRelDocumentsByRelation(int _nModal) throws WCMException {
        DBManager dbMgr = DBManager.getDBManager();
        String sWhere = "DocId in(select DocId from WCMRelation where WCMRelation.RelDocId=?) and Modal=? and DocStatus=10 and DocChannel>0";
        String sSelectFields = _nModal == 1 ? "DocId" : "DocId,ChnlId";
        WCMFilter filter = new WCMFilter("WCMChnlDoc", sWhere, "", sSelectFields);
        filter.addSearchValues(this.m_doc.getId());
        filter.addSearchValues(_nModal);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        String strSQL = filter.toSQL();
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            DBManager.setParameters(oStmt, filter);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                int nDocId = rsData.getInt(1);
                int nCurrChannelId = _nModal == 1 ? 0 : rsData.getInt(2);
                this.publishDocumentSelf(nDocId, nCurrChannelId);
            }
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void publishDocumentSelf(int _nDocId, int _nChannelId) throws WCMException {
        Document document = Document.findById(_nDocId, "DocId,DocTitle,DocChannel");
        int nModal = 1;
        Channel currChannel = null;
        if (_nChannelId > 0) {
            currChannel = Channel.findById(_nChannelId);
            nModal = 3;
        } else {
            currChannel = document.getChannel();
        }
        if (currChannel == null || currChannel.isDeleted()) {
            return;
        }
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(currChannel);
        PublishContentDocumentImpl content = new PublishContentDocumentImpl(document);
        content.setFolder(folder);
        content.m_nModal = nModal;
        content.m_nStatusInCurrentFolder = 10;
        content.m_nStatusInHome = 10;
        PublishServer.getInstance().publishContent((IPublishContent)content, 8);
    }

    @Override
    public int getType() {
        return 605;
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_doc;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_doc = (Document)_cmsObj;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_doc = Document.findById(_nId);
        return this.m_doc != null;
    }

    @Override
    public int getId() {
        return this.m_doc == null ? 0 : this.m_doc.getId();
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) {
        this.m_doc = (Document)_cmsObj;
    }

    @Override
    public IPublishFolder getOriginalHome() throws WCMException {
        if (this.getModal() == 1 && this.m_folder != null) {
            return this.m_folder;
        }
        if (this.getFolder() != null && this.m_doc.getChannelId() == this.getFolder().getId() && this.getFolder().getType() == 101) {
            return this.getFolder();
        }
        Channel docChannel = this.m_doc.getChannel();
        if (docChannel == null) {
            return null;
        }
        return new PublishFolderChannelImpl(docChannel);
    }

    @Override
    public CMyDateTime getCreatedTime() {
        return this.m_doc.getCrTime();
    }

    @Override
    public void setPublishTime(CMyDateTime _dtTime) throws WCMException {
        DBManager dbMgr = DBManager.getDBManager();
        Connection conn = dbMgr.getConnection();
        Statement preStm = null;
        try {
            Timestamp tsPublish = _dtTime.toTimestamp();
            String[] sUpdateSQL = new String[4];
            sUpdateSQL[0] = "update WCMChnlDoc set DOCPUBTIME=? where DocId=? and ChnlId=?";
            sUpdateSQL[1] = "update WCMChnlDoc set DOCFirstPUBTIME=? where DocId=? and ChnlId=? and DOCFirstPUBTIME is null";
            if (this.getFolder().getId() == this.m_doc.getChannelId()) {
                sUpdateSQL[2] = "update WCMDocument  set DOCPUBTIME=? where DocId=? and DocChannel=?";
                sUpdateSQL[3] = "update WCMDocument set DOCFirstPUBTIME=? where DocId=? and DocChannel=? and DOCFirstPUBTIME is null";
            }
            for (int i = 0; i < sUpdateSQL.length; ++i) {
                if (sUpdateSQL[i] == null) continue;
                preStm = conn.prepareStatement(sUpdateSQL[i]);
                preStm.setTimestamp(1, tsPublish);
                preStm.setInt(2, this.getId());
                preStm.setInt(3, this.getFolder().getId());
                preStm.executeUpdate();
                preStm.close();
                preStm = null;
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label2", "\u66f4\u65b0DocPubTime\u548cDocPubURL\u5931\u8d25\uff01"), e);
        }
        finally {
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            dbMgr.freeConnection(conn);
        }
    }

    @Override
    public void setPublishTimeAndURL(CMyDateTime _time, String _url) throws WCMException {
        boolean zIsEntity = this.getFolder().getId() == this.m_doc.getChannelId();
        boolean zIsDelete = _time == null && _url == null;
        String sURL = _url;
        Timestamp tsPublish = null;
        DBManager dbMgr = DBManager.getDBManager();
        Connection conn = dbMgr.getConnection();
        Statement preStm = null;
        try {
            if (_time != null) {
                tsPublish = _time.toTimestamp();
            }
            String sUpdateSQL = null;
            sUpdateSQL = "update WCMChnlDoc set DOCPUBTIME=?, DocPubURL=? where DocId=? and ChnlId=?";
            preStm = conn.prepareStatement(sUpdateSQL);
            preStm.setTimestamp(1, tsPublish);
            preStm.setString(2, sURL);
            preStm.setInt(3, this.getId());
            preStm.setInt(4, this.getFolder().getId());
            preStm.executeUpdate();
            preStm.close();
            sUpdateSQL = "update WCMChnlDoc set DOCFirstPUBTIME=? where DocId=? and ChnlId=? and DOCFirstPUBTIME is null";
            preStm = conn.prepareStatement(sUpdateSQL);
            preStm.setTimestamp(1, tsPublish);
            preStm.setInt(2, this.getId());
            preStm.setInt(3, this.getFolder().getId());
            preStm.executeUpdate();
            preStm.close();
            if (zIsEntity) {
                sUpdateSQL = "update WCMDOCUMENT set DOCPUBTIME=?, DOCPUBURL=? where DOCID=?";
                preStm = conn.prepareStatement(sUpdateSQL);
                preStm.setTimestamp(1, tsPublish);
                preStm.setString(2, sURL);
                preStm.setInt(3, this.getId());
                preStm.executeUpdate();
                preStm.close();
                sUpdateSQL = "update WCMDOCUMENT set DOCFIRSTPUBTIME=? where DOCID=? and DOCFIRSTPUBTIME is null";
                preStm = conn.prepareStatement(sUpdateSQL);
                preStm.setTimestamp(1, tsPublish);
                preStm.setInt(2, this.getId());
                preStm.executeUpdate();
                preStm.close();
            }
            if (zIsEntity && zIsDelete) {
                sUpdateSQL = "update WCMChnlDoc set DOCPUBTIME=?, DocPubURL=? where DocId=? and Modal=2";
                preStm = conn.prepareStatement(sUpdateSQL);
                preStm.setTimestamp(1, tsPublish);
                preStm.setString(2, sURL);
                preStm.setInt(3, this.getId());
                preStm.executeUpdate();
                preStm.close();
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label2", "\u66f4\u65b0DocPubTime\u548cDocPubURL\u5931\u8d25\uff01"), e);
        }
        finally {
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            dbMgr.freeConnection(conn);
        }
    }

    @Override
    public boolean validateCanDoPub() throws WCMException {
        int nStatusInCurrentFolder;
        if (this.getFolder() == null) {
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label3", "\u6ca1\u6709\u627e\u5230[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label4", "]\u7684\u6240\u5c5e\u680f\u76ee\uff01"));
        }
        Channel channel = (Channel)this.getFolder().getSubstance();
        if (!channel.isCanPub()) {
            throw new BizError("[" + channel.getDispDesc() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label5", "]\u8bbe\u7f6e\u4e0d\u53ef\u53d1\u5e03\uff01\u6240\u4ee5") + this.m_doc + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label6", "\u4e0d\u80fd\u53d1\u5e03\uff01"));
        }
        if (this.getDetailTemplate() == null) {
            throw new BizError("[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label7", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        boolean bStatusCanDoPub = false;
        int nModal = this.getModal();
        if (nModal == 2) {
            IPublishFolder originalFolder = this.getOriginalHome();
            channel = (Channel)originalFolder.getSubstance();
            if (!channel.isCanPub()) {
                throw new BizError("[" + channel.getDispDesc() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label5", "]\u8bbe\u7f6e\u4e0d\u53ef\u53d1\u5e03\uff01\u6240\u4ee5") + this.m_doc + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label6", "\u4e0d\u80fd\u53d1\u5e03\uff01"));
            }
            WCMPubStatusConfig statusConfig = WCMPubStatusConfig.findOf((originalFolder = originalFolder.getRoot()).getType(), originalFolder.getId());
            if (statusConfig == null) {
                bStatusCanDoPub = false;
            } else {
                boolean bl = bStatusCanDoPub = ("," + statusConfig.getStatusesCanDoPub() + ",").indexOf("," + this.m_doc.getStatusId() + ",") >= 0;
            }
            if (!bStatusCanDoPub) {
                Status docStatus = Status.findById(this.m_doc.getStatusId());
                String sStatusDisp = docStatus == null ? I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5") : docStatus.getDisp();
                throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + sStatusDisp + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
            }
        }
        if (Status.findById(nStatusInCurrentFolder = this.getCurrentStatusId()) == null) {
            String sStatusDisp = I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5");
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + sStatusDisp + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
        }
        if (nStatusInCurrentFolder == 10) {
            return true;
        }
        try {
            IPublishFolder root = this.getFolder().getRoot();
            WCMPubStatusConfig statusConfig = WCMPubStatusConfig.findOf(root.getType(), root.getId());
            bStatusCanDoPub = statusConfig == null ? false : ("," + statusConfig.getStatusesCanDoPub() + ",").indexOf("," + nStatusInCurrentFolder + ",") >= 0;
        }
        catch (Exception e) {
            bStatusCanDoPub = false;
        }
        if (!bStatusCanDoPub) {
            Status docStatus = Status.findById(nStatusInCurrentFolder);
            String sStatusDisp = docStatus == null ? I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5") : docStatus.getDisp();
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + sStatusDisp + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
        }
        return true;
    }

    private int getCurrentStatusId() throws WCMException {
        if (this.m_nStatusInCurrentFolder == 0) {
            this.findStatusInCurrentFolder();
        }
        return this.m_nStatusInCurrentFolder;
    }

    @Override
    public boolean isValidElement() {
        try {
            this.validateCanDoPub();
        }
        catch (WCMDatainvalidException e) {
            return false;
        }
        catch (WCMException e) {
            logger.error((Object)(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label11", "\u5224\u65ad\u53d1\u5e03\u5143\u7d20:") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label12", "\u7684\u6709\u6548\u6027\u5931\u8d25!")), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean isLink() {
        return this.m_doc.getType() == 30;
    }

    @Override
    public String getLinkUrl() {
        return CMyString.showNull(this.m_doc.getPropertyAsString("DOCLINK"));
    }

    @Override
    public boolean isFile() {
        if (this.m_doc.getType() != 40) {
            return false;
        }
        return !this.isSWFModeContent();
    }

    private boolean isSWFModeContent() {
        String sFileName = this.getFileName();
        int nPos = sFileName.lastIndexOf(46);
        String sFileExt = CMyFile.excludeFileExt(sFileName);
        if (!sFileExt.equals("swf") && nPos > 0) {
            String sSWFFileName = sFileName.substring(0, nPos + 1) + "swf";
            try {
                sSWFFileName = FilesMan.getFilesMan().mapFilePath(sSWFFileName, 0) + sSWFFileName;
                if (CMyFile.fileExists(sSWFFileName)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public String getFileName() {
        return this.m_doc.getPropertyAsString("DOCFILENAME");
    }

    @Override
    public void validateCanDoPreview() throws WCMException {
        IPublishFolder folder = null;
        switch (this.getModal()) {
            case 1: 
            case 2: {
                folder = this.getOriginalHome();
                break;
            }
            case 3: {
                folder = this.getFolder();
                break;
            }
            default: {
                throw new BizError("[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label13", "]\u4e0d\u53ef\u8bc6\u522b\u7684\u6587\u6863\u6a21\u5f0f!"));
            }
        }
        if (folder == null) {
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label3", "\u6ca1\u6709\u627e\u5230[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label4", "]\u7684\u6240\u5c5e\u680f\u76ee\uff01"));
        }
        FolderPublishConfig folderConfig = FolderPublishConfig.findOf(folder);
        if (folderConfig == null) {
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label14", "]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"));
        }
        if (this.isFile() || this.isLink()) {
            return;
        }
        if (this.getDetailTemplate() == null) {
            throw new BizError(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label7", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
    }

    @Override
    public boolean canDoPreview() {
        try {
            IPublishFolder folder = null;
            switch (this.getModal()) {
                case 1: 
                case 2: {
                    folder = this.getOriginalHome();
                    break;
                }
                case 3: {
                    folder = this.getFolder();
                    break;
                }
                default: {
                    return false;
                }
            }
            FolderPublishConfig folderConfig = FolderPublishConfig.findOf(folder);
            if (folderConfig == null) {
                return false;
            }
            if (this.isFile() || this.isLink()) {
                return true;
            }
            return this.getDetailTemplate() != null;
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label15", "\u5224\u65ad ") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label16", " \u662f\u5426\u53ef\u4ee5\u9884\u89c8\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)e);
            return false;
        }
    }

    @Override
    public Iterator getRelatedResources() throws WCMException {
        List htmlResources;
        if (this.m_doc == null) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        int nModal = this.getModal();
        if (this.m_doc.getType() == 20 && nModal != 2 && (htmlResources = this.m_doc.getHTMLWCMFiles(true)) != null && htmlResources.size() > 0) {
            files.addAll(htmlResources);
        }
        if (this.m_doc.getType() == 40 && nModal != 2 && this.isSWFModeContent()) {
            String sFileName = this.getFileName();
            files.add(sFileName);
            int nPos = sFileName.lastIndexOf(46);
            files.add(sFileName.substring(0, nPos + 1) + "swf");
        }
        if (this.m_appendixmgr == null) {
            this.m_appendixmgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        }
        Appendixes appendixes = this.m_appendixmgr.getAppendixes(this.m_doc, -1);
        for (int i = 0; i < appendixes.size(); ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            files.add(appendix.getFile());
            if (appendix.getFlag() != 20) continue;
            files.addAll(this.getScaleFileForImg(appendix.getFile()));
        }
        if (this.getModal() != 2) {
            IDiscovery discovery;
            String pics;
            Channel channel = this.m_doc.getChannel();
            if (channel.getSite().getPropertyAsInt("SiteType", 0) == 1 && !CMyString.isEmpty(pics = this.m_doc.getRelateWords())) {
                files.addAll(Arrays.asList(CMyString.split(pics, ",")));
            }
            if ((discovery = WCMDiscoveryFactory.getDiscovery()) != null) {
                Iterator impls = discovery.getImplementors(IRelateResource.class.getName());
                Class<?> clazz = null;
                IRelateResource resource = null;
                while (impls.hasNext()) {
                    try {
                        clazz = Class.forName((String)impls.next());
                        resource = (IRelateResource)clazz.newInstance();
                        List resourceNames = resource.getResourceNames(this);
                        files.addAll(resourceNames);
                        for (int i = 0; i < resourceNames.size(); ++i) {
                            String sFileName = (String)resourceNames.get(i);
                            if (!this.isImgFile(sFileName)) continue;
                            files.addAll(this.getScaleFileForImg(sFileName));
                        }
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"get relate files fail.", (Throwable)ex);
                    }
                }
            }
        }
        return files.iterator();
    }

    private boolean isImgFile(String sFileName) {
        if (IMAGE_SUFFIX_SET.size() == 0) {
            IMAGE_SUFFIX_SET.add("png");
            IMAGE_SUFFIX_SET.add("jpg");
            IMAGE_SUFFIX_SET.add("jpeg");
            IMAGE_SUFFIX_SET.add("gif");
            IMAGE_SUFFIX_SET.add("bmp");
        }
        String sFileExt = CMyFile.extractFileExt(sFileName);
        return sFileName != null && IMAGE_SUFFIX_SET.contains(sFileExt.toLowerCase());
    }

    private List getScaleFileForImg(String sFileName) throws WCMException {
        ArrayList<String> scaleFileList = new ArrayList<String>();
        if (CMyString.isEmpty(this.m_sImgScaleSuffix)) {
            this.m_sImgScaleSuffix = ConfigServer.getServer().getSysConfigValue("IMG_SCALE_FILE_SUFFIX", "r65");
        }
        if (CMyString.isEmpty(this.m_sImgScaleSuffix)) {
            return scaleFileList;
        }
        String[] scaleFileSuffixs = this.m_sImgScaleSuffix.split(",");
        String sOriFileName = CMyFile.excludeFileExt(sFileName);
        String sFileExt = CMyFile.extractFileExt(sFileName);
        String sScaleFileName = "";
        String sSuffixs = "";
        for (int i = 0; i < scaleFileSuffixs.length; ++i) {
            sSuffixs = scaleFileSuffixs[i];
            sScaleFileName = sOriFileName + "_" + sSuffixs + "." + sFileExt;
            scaleFileList.add(sScaleFileName);
        }
        return scaleFileList;
    }

    @Override
    public boolean isCanDoSave(User _loginUser) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, null, this.m_doc, 32);
    }

    public String toString() {
        return String.valueOf(this.m_doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileNamedStyle getFileNamedStyle() {
        FileNamedStyle oFileNamedStyle = PublishServerConfigMapper.getDetailFileNamedStyle("CommonFileNamedStyle");
        try {
            String sPublishFileName;
            if (!this.enableNewRule()) {
                return oFileNamedStyle;
            }
            if (DBManager.getDBManager().getFieldInfo("WCMDOCUMENT", "PublishFileName") == null) {
                return oFileNamedStyle;
            }
            if (!this.m_doc.containsProperty("PublishFileName")) {
                int nDocId = this.m_doc.getId();
                this.m_doc.loadById(nDocId, "PublishFileName");
                this.m_doc.setId(nDocId);
            }
            if ((sPublishFileName = this.m_doc.getPropertyAsString("PublishFileName", "").trim()).length() == 0) {
                return oFileNamedStyle;
            }
            if (this.m_oCurrFileNameStyle == null) {
                PublishContentDocumentImpl publishContentDocumentImpl = this;
                synchronized (publishContentDocumentImpl) {
                    if (this.m_oCurrFileNameStyle == null) {
                        sPublishFileName = NewRuleOfDetailPageHelper.filterSpecialChar(sPublishFileName);
                        FileNamedStyle oNewFileNamedStyle = new FileNamedStyle();
                        oNewFileNamedStyle.setPattern(sPublishFileName);
                        oNewFileNamedStyle.setDirByDate(false);
                        this.m_oCurrFileNameStyle = oNewFileNamedStyle;
                    }
                }
            }
            return this.m_oCurrFileNameStyle;
        }
        catch (Exception e) {
            logger.error((Object)"Fail?", (Throwable)e);
            return oFileNamedStyle;
        }
    }

    private boolean enableNewRule() {
        try {
            int nCurrSiteId = 0;
            nCurrSiteId = this.m_folder == null || this.getModal() == 2 ? this.getOriginalHome().getRoot().getId() : this.m_folder.getRoot().getId();
            return NewRuleOfDetailPageHelper.enableNewRule(nCurrSiteId);
        }
        catch (Exception e) {
            logger.error((Object)"Why fail?", (Throwable)e);
            return false;
        }
    }

    public String getRealFileName() throws WCMException {
        String fileName = this.m_doc.getPropertyAsString("DOCFILENAME");
        String siteId = this.getFolder().getRoot().getId() + "";
        String configValue = ConfigServer.getServer().getSysConfigValue("SITEIDS_NEW_RULE_FOR_DETIAL", "-1");
        String[] siteIds = configValue.split(",");
        boolean useNewRule = "*".equalsIgnoreCase(configValue);
        for (int i = 0; i < siteIds.length; ++i) {
            if (!siteIds[i].equalsIgnoreCase(siteId)) continue;
            useNewRule = true;
            break;
        }
        if (useNewRule) {
            String publishFileName;
            Document fulldoc = Document.findById(this.m_doc.getDocId());
            if (fulldoc == null) {
                fulldoc = this.m_doc;
            }
            if ((publishFileName = fulldoc.getPropertyAsString("PUBLISHFILENAME")) != null && !CMyString.isEmpty(publishFileName)) {
                fileName = PublishPathCompass.makeDetailPageFileName(this) + fileName.substring(fileName.indexOf("."));
            }
        }
        return fileName;
    }
}

