/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployDetail;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TemplateEmployCacheMgrImpl
implements ITemplateEmployCacheMgr {
    private static Logger logger = Logger.getLogger(TemplateEmployCacheMgrImpl.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public Template getDetailTemplate(IPublishElement _employer) throws WCMException {
        return this.getDetailTemplate(_employer.getType(), _employer.getId());
    }

    @Override
    public Template getDefaultOutlineTemplate(IPublishFolder _folder) throws WCMException {
        TemplateEmployDetail detail = this.getTemplateEmployCache(_folder.getType(), _folder.getId());
        if (detail == null) {
            return null;
        }
        return detail.getDefaultOutlineTemplate();
    }

    @Override
    public Templates getOutlineTemplates(IPublishFolder _folder) throws WCMException {
        TemplateEmployDetail detail = this.getTemplateEmployCache(_folder.getType(), _folder.getId());
        if (detail == null) {
            return new Templates(User.getSystem());
        }
        return detail.getOutlineTemplates();
    }

    private String getKey(int employType, int employId) {
        return this.getKey() + "." + employType + "." + employId;
    }

    private String getKey() {
        return TemplateEmployCacheMgrImpl.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        TemplateEmployCacheMgrImpl templateEmployCacheMgrImpl = this;
        synchronized (templateEmployCacheMgrImpl) {
            if (cache.exists(this.getKey()).booleanValue()) {
                return true;
            }
            ArrayList<Integer> typeList = new ArrayList<Integer>(4);
            DBManager dbMgr = DBManager.getDBManager();
            Connection conn = null;
            PreparedStatement preStmt = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"get EMPLOYERTYPE...");
            }
            String sSQL = "select distinct EMPLOYERTYPE from WCMTEMPLATEEMPLOY";
            try {
                conn = dbMgr.getConnection();
                preStmt = conn.prepareStatement("select distinct EMPLOYERTYPE from WCMTEMPLATEEMPLOY");
                ResultSet rsEmployerType = preStmt.executeQuery();
                while (rsEmployerType.next()) {
                    typeList.add(new Integer(rsEmployerType.getInt(1)));
                }
                rsEmployerType.close();
                preStmt.close();
                preStmt = null;
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label1", "\u8bfb\u53d6\u96c7\u4e3b\u7c7b\u578b\u6570\u636e\u5931\u8d25!"), e);
            }
            finally {
                if (preStmt != null) {
                    try {
                        preStmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    dbMgr.freeConnection(conn);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"get EMPLOYERTYPE end!");
            }
            String sGetTemplateEmploysSQL = "select * from WCMTEMPLATEEMPLOY where EMPLOYERTYPE=?";
            try {
                conn = dbMgr.getConnection();
                ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
                preStmt = conn.prepareStatement("select * from WCMTEMPLATEEMPLOY where EMPLOYERTYPE=?");
                for (int i = typeList.size() - 1; i >= 0; --i) {
                    Integer iEmployTypeKey = (Integer)typeList.get(i);
                    preStmt.setInt(1, iEmployTypeKey);
                    preStmt.setFetchSize(1000);
                    ResultSet rsEmploys = preStmt.executeQuery();
                    while (rsEmploys.next()) {
                        Integer iEmployerIdKey = new Integer(rsEmploys.getInt("EMPLOYERID"));
                        TemplateEmployDetail detail = (TemplateEmployDetail)cache.get(this.getKey(iEmployTypeKey, iEmployerIdKey));
                        if (detail == null) {
                            detail = new TemplateEmployDetail();
                        }
                        detail.putEmploy(rsEmploys.getInt("TEMPLATEEMPLOYID"), rsEmploys.getInt("TEMPLATETYPE"), (Template)currCachedPOMgr.getObjFromBuffer((Class)Template.class, new Integer(rsEmploys.getInt("TEMPLATEID"))), rsEmploys.getInt("ISDEFAULT") == 1);
                        cache.set(this.getKey(iEmployTypeKey, iEmployerIdKey), detail);
                    }
                    rsEmploys.close();
                }
                preStmt.close();
                preStmt = null;
            }
            catch (SQLException e) {
                throw new WCMException(I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label2", "\u8bfb\u53d6\u6570\u636e\u5931\u8d25!"), e);
            }
            finally {
                if (preStmt != null) {
                    try {
                        preStmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    dbMgr.freeConnection(conn);
                }
            }
            cache.set(this.getKey(), "true");
        }
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label4", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        TemplateEmploy employ = (TemplateEmploy)_oObjAdded;
        this.putEmployInCache(employ);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label5", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        TemplateEmploy employ = (TemplateEmploy)_oObjDeleted;
        this.removeEmployFromCache(employ);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label6", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!_oObjModified.isModified()) {
            return;
        }
        TemplateEmploy employ = (TemplateEmploy)_oObjModified;
        if (employ.isChangeProperty("TEMPLATEID") || employ.isChangeProperty("TEMPLATETYPE")) {
            this.removeEmployFromCache(employ);
        }
        TemplateEmploy newEmploy = new TemplateEmploy();
        newEmploy.setProperties(employ.getProperties());
        newEmploy.setProperties(employ.getNewProperties());
        this.putEmployInCache(newEmploy);
    }

    private TemplateEmployDetail getTemplateEmployCache(int _nPublishElementType, int _nPublishElementId) throws WCMException {
        TemplateEmployDetail detail = (TemplateEmployDetail)cache.get(this.getKey(_nPublishElementType, _nPublishElementId));
        return detail;
    }

    private void putEmployInCache(TemplateEmploy _employ) throws WCMException {
        Integer keyType = new Integer(_employ.getEmployerType());
        Integer key = new Integer(_employ.getEmployerId());
        TemplateEmployDetail detail = (TemplateEmployDetail)cache.get(this.getKey(keyType, key));
        if (detail == null) {
            detail = new TemplateEmployDetail(_employ);
        } else {
            detail.putEmploy(_employ);
        }
        cache.set(this.getKey(keyType, key), detail);
    }

    private void removeEmployFromCache(TemplateEmploy employ) throws WCMException {
        Integer keyType = new Integer(employ.getEmployerType());
        Integer key = new Integer(employ.getEmployerId());
        TemplateEmployDetail detail = (TemplateEmployDetail)cache.get(this.getKey(keyType, key));
        if (detail == null) {
            return;
        }
        detail.removeEmploy(employ);
        cache.set(this.getKey(keyType, key), detail);
        if (detail.isEmpty()) {
            cache.clear(this.getKey(keyType, key));
        }
    }

    @Override
    public Template getDetailTemplate(int _nPublishElementType, int _nPublishElementId) throws WCMException {
        TemplateEmployDetail detail = this.getTemplateEmployCache(_nPublishElementType, _nPublishElementId);
        if (detail == null) {
            return null;
        }
        return detail.getDefaultDetailTemplate();
    }
}

