/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet.acl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.conjection.persistent.EntryConfig;
import com.trs.infra.common.WCMException;
import com.trs.presentation.util.RequestHelper;
import com.trs.servlet.Acl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginSetting
extends Acl {
    @Override
    protected boolean check(HttpServletRequest request, HttpServletResponse response) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        if (loginUser.isAdministrator()) {
            return true;
        }
        RequestHelper helper = new RequestHelper(request, response, request.getSession().getServletContext());
        int nId = helper.getInt("EntryConfigId", 0);
        EntryConfig config = EntryConfig.findById(nId);
        int nType = config == null ? 0 : config.getType();
        int nRigthIndex = 0;
        switch (nType) {
            case 5: {
                nRigthIndex = 55;
                break;
            }
            case 4: {
                nRigthIndex = 53;
                break;
            }
            case 6: {
                nRigthIndex = 58;
                break;
            }
            case 8: {
                nRigthIndex = 60;
                break;
            }
            case 3: {
                nRigthIndex = 54;
                break;
            }
            case 7: {
                nRigthIndex = 59;
                break;
            }
            default: {
                nRigthIndex = 56;
            }
        }
        return AuthServer.hasExtendedRight(loginUser, nRigthIndex);
    }
}

