/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyXMLElement;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMyXMLHandler
extends DefaultHandler {
    private LinkedList m_lStack;
    private CMyXMLElement m_oRootConfig;
    private boolean m_bParsingProperty;
    private boolean m_bIsProperty;
    private StringBuffer m_sbValue;
    private String m_sPropertiesTag = "PROPERTIES";
    private Class m_oConfigClass = CMyXMLElement.class;

    public CMyXMLHandler() {
        this.init();
    }

    public CMyXMLHandler(Class _class) throws Exception {
        this.setConfigClass(_class);
        this.init();
    }

    private void init() {
        this.m_lStack = new LinkedList();
        this.m_bParsingProperty = false;
        this.m_bIsProperty = false;
        this.m_sbValue = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_bParsingProperty && this.m_bIsProperty && this.m_sbValue != null) {
            this.m_sbValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String sTemp = qName.toUpperCase();
        if (sTemp.equals(this.m_sPropertiesTag)) {
            this.m_bParsingProperty = false;
            return;
        }
        if (this.m_bParsingProperty) {
            this.m_bIsProperty = false;
            String sValue = this.m_sbValue.toString();
            this.getFirstFromStatck().setProperty(sTemp, sValue);
            this.m_sbValue.delete(0, this.m_sbValue.length());
            return;
        }
        this.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_bParsingProperty) {
            this.m_bIsProperty = true;
            return;
        }
        String sTemp = qName.toUpperCase();
        if (sTemp.equals(this.m_sPropertiesTag)) {
            if (this.m_oRootConfig == null) {
                throw new SAXException(I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label2", "\u683c\u5f0f\u4e0d\u5bf9\uff01"));
            }
            this.m_bParsingProperty = true;
            return;
        }
        CMyXMLElement oConfig = this.createNewConfig();
        oConfig.setName(sTemp);
        if (this.getRootConfig() == null) {
            this.setRootConfig(oConfig);
        } else {
            this.getFirstFromStatck().addChild(oConfig);
        }
        this.push(oConfig);
        int nLength = attributes.getLength();
        for (int i = 0; i < nLength; ++i) {
            String name = attributes.getQName(i).toUpperCase();
            String value = attributes.getValue(i);
            try {
                oConfig.setProperty(name, value);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label3", "\u8bbe\u7f6e[") + sTemp + I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label1", "]\u7684[") + name.toUpperCase() + I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label4", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
            }
        }
    }

    public CMyXMLElement getRootConfig() {
        return this.m_oRootConfig;
    }

    private CMyXMLElement createNewConfig() {
        try {
            return (CMyXMLElement)this.getConfigClass().newInstance();
        }
        catch (Exception ex) {
            return new CMyXMLElement();
        }
    }

    public Class getConfigClass() {
        return this.m_oConfigClass;
    }

    public void setConfigClass(Class configClass) {
        this.m_oConfigClass = configClass;
    }

    public void setRootConfig(CMyXMLElement rootConfig) {
        this.m_oRootConfig = rootConfig;
    }

    private void push(CMyXMLElement _currConfig) {
        this.m_lStack.addFirst(_currConfig);
    }

    private CMyXMLElement pop() {
        return (CMyXMLElement)this.m_lStack.removeFirst();
    }

    private CMyXMLElement getFirstFromStatck() {
        return (CMyXMLElement)this.m_lStack.getFirst();
    }
}

