/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.ObjectLCMonitorServer;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class BaseObj
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger s_logger = Logger.getLogger(BaseObj.class);
    protected boolean m_bCheckPropertyValid = true;
    protected Hashtable<String, Object> m_hProperties = null;
    private Hashtable<String, Object> m_hNewProperties = null;
    protected int id = 0;
    protected boolean bAddMode = true;
    protected String sClobFields_toUpdate = null;
    private int nUpdateClobCount;
    private String sTextFieldsList = null;
    private boolean bIsLoadText = false;
    protected boolean m_bFromClone = false;
    protected boolean IS_ENGVERSION = false;
    private boolean m_bEnableListener = true;
    private boolean m_bGetPropertyFromNew = false;
    private static final int[] TYPES_ALLOW_NULL = new int[]{4, 2, 8, 5, 6, -5, 3};
    private boolean m_bLoadNewPropertyById = false;
    private Map<String, Object> m_hExtProperties = new HashMap<String, Object>();

    public abstract int getWCMType();

    public abstract String getDbTableName();

    public abstract String getIdFieldName();

    public Integer getKey() {
        return new Integer(this.id);
    }

    public final boolean isCached() {
        try {
            return BaseObj.getCachedPOMgr().isCached(this.getClass());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setEnableListener(boolean bIsEnable) {
        if (!bIsEnable && this.isCached()) {
            s_logger.info((Object)"\u4f60\u6b63\u5728\u5bf9\u7f13\u51b2\u5bf9\u8c61\u8bbe\u7f6e\u4e3a\u4e0d\u542f\u7528\u76d1\u542c\u5668\uff0c\u7531\u4e8e\u7f13\u51b2\u5bf9\u8c61\u7684\u552f\u4e00\u6027\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u5230\u5176\u4ed6\u5730\u65b9\u5bf9\u8be5\u5bf9\u8c61\u7684\u4f7f\u7528");
        }
        this.m_bEnableListener = bIsEnable;
    }

    public boolean isEnableListener() {
        return this.m_bEnableListener;
    }

    public String getClassName(boolean _bIncludePackage) {
        int nPos;
        String sClassName = this.getClass().getName();
        if (!_bIncludePackage && (nPos = sClassName.lastIndexOf(46)) >= 0) {
            sClassName = sClassName.substring(nPos + 1);
        }
        return sClassName;
    }

    public int getId() {
        return this.id;
    }

    public Hashtable<String, Object> getAllProperty() {
        if (this.sTextFieldsList != null) {
            try {
                this.loadTextsFromDB(true);
            }
            catch (WCMException ex) {
                s_logger.error((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label1", "\u88c5\u8f7d\u5927\u5b57\u6bb5[") + this.sTextFieldsList + I18NMessage.get(BaseObj.class, "BaseObj.label2", "]\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01")), (Throwable)ex);
            }
        }
        return this.getProperties();
    }

    protected void clearProperties() {
        if (this.m_hProperties != null) {
            this.m_hProperties.clear();
        }
    }

    protected void clearNewProperties() {
        if (this.m_hNewProperties != null) {
            this.m_hNewProperties.clear();
        }
        this.m_hNewProperties = null;
    }

    public Hashtable<String, Object> getNewProperties() {
        return this.getNewProperties(false);
    }

    private Hashtable<String, Object> getNewProperties(boolean _bNeedCheckInit) {
        if (this.m_hNewProperties == null && _bNeedCheckInit) {
            this.m_hNewProperties = new Hashtable();
        }
        return this.m_hNewProperties;
    }

    public boolean isModified() {
        return this.isModified(false);
    }

    public boolean isModified(boolean zDeep) {
        if (this.isAddMode()) {
            return this.getProperties() != null;
        }
        Hashtable<String, Object> hProperties = this.getNewProperties();
        if (hProperties != null && hProperties.size() > 0) {
            if (zDeep) {
                Hashtable<String, Object> oldProperties = this.getProperties(true);
                Enumeration<String> enKeys = hProperties.keys();
                while (enKeys.hasMoreElements()) {
                    String oKey = enKeys.nextElement();
                    Object oVal = hProperties.get(oKey);
                    if (oVal.equals(oldProperties.get(oKey))) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean setProperties(Hashtable<String, Object> _properties) {
        if (_properties == null) {
            return false;
        }
        this.getProperties(true).putAll(_properties);
        return true;
    }

    protected boolean resetProperties(Hashtable<String, Object> _properties) {
        if (_properties == null) {
            return false;
        }
        this.clearProperties();
        return this.setProperties(_properties);
    }

    public boolean isGetPropertyFromNew() {
        return this.m_bGetPropertyFromNew;
    }

    public void setGetPropertyFromNew(boolean _bGetPropertyFromNew) {
        this.m_bGetPropertyFromNew = !this.isAddMode() && _bGetPropertyFromNew;
    }

    public Object getProperty(String _sName) {
        if (_sName == null || this.getProperties() == null) {
            return null;
        }
        _sName = _sName.toUpperCase();
        Object objValue = null;
        if (this.m_bGetPropertyFromNew && this.m_hNewProperties != null) {
            objValue = this.m_hNewProperties.get(_sName);
        }
        if (objValue == null) {
            objValue = this.m_hProperties.get(_sName);
        }
        if (objValue == null || objValue instanceof NullValue) {
            return null;
        }
        if (objValue instanceof CDBText && !((CDBText)objValue).isLoaded()) {
            try {
                if (this.loadTextsFromDB(false)) {
                    objValue = this.getProperties().get(_sName.toUpperCase());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                objValue = null;
            }
        }
        return objValue;
    }

    public Object getNewProperty(String _sName) {
        if (this.getNewProperties() == null || _sName == null) {
            return null;
        }
        _sName = _sName.toUpperCase();
        Object value = this.getNewProperties().get(_sName);
        if (value instanceof NullValue) {
            return null;
        }
        return value;
    }

    public String getPropertyAsString(String _sName) {
        Object objValue = this.getProperty(_sName);
        if (objValue == null) {
            return null;
        }
        return objValue.toString();
    }

    public String getFinalPropertyAsString(String _sName) {
        return this.getFinalPropertyAsString(_sName, null);
    }

    public String getFinalPropertyAsString(String _sName, String _sDefaultValue) {
        if (this.isAddMode()) {
            return this.getPropertyAsString(_sName, _sDefaultValue);
        }
        return CMyString.showNull(this.getNewPropertyAsString(_sName), _sDefaultValue);
    }

    public String getPropertyAsString(String _sName, String _sDefaultValue) {
        Object objValue = this.getProperty(_sName);
        if (objValue == null) {
            return _sDefaultValue;
        }
        if (objValue instanceof CMyDateTime && ((CMyDateTime)objValue).isNull()) {
            return _sDefaultValue;
        }
        return objValue.toString();
    }

    public boolean containsProperty(String _sName) {
        if (_sName == null || this.getProperties() == null) {
            return false;
        }
        return this.getProperties().containsKey(_sName.toUpperCase());
    }

    public boolean containsNewProperty(String _sName) {
        if (_sName == null || this.getNewProperties() == null) {
            return false;
        }
        return this.getNewProperties().containsKey(_sName.toUpperCase());
    }

    public CMyDateTime getPropertyAsDateTime(String _sName) {
        Object objValue = this.getProperty(_sName);
        if (objValue instanceof CMyDateTime) {
            return (CMyDateTime)objValue;
        }
        CMyDateTime dtValue = new CMyDateTime();
        if (this.isNullValue(objValue)) {
            return dtValue;
        }
        try {
            dtValue.setDateTimeWithString(objValue.toString());
            return dtValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CMyDateTime();
        }
    }

    public long getPropertyAsLong(String _sName, long _lDefault) {
        Object objValue = this.getProperty(_sName);
        if (this.isNullValue(objValue)) {
            return _lDefault;
        }
        if (objValue instanceof Number) {
            return ((Number)objValue).longValue();
        }
        return Long.parseLong(objValue.toString());
    }

    public int getPropertyAsInt(String _sName, int _nDefault) {
        Object objValue = this.getProperty(_sName);
        if (this.isNullValue(objValue)) {
            return _nDefault;
        }
        if (objValue instanceof Number) {
            return ((Number)objValue).intValue();
        }
        return Integer.parseInt(objValue.toString());
    }

    private boolean isNullValue(Object objValue) {
        return objValue == null || objValue instanceof NullValue;
    }

    public boolean getPropertyAsBoolean(String _sName, boolean _bDefault) {
        int nValue = this.getPropertyAsInt(_sName, _bDefault ? 1 : 0);
        return nValue != 0;
    }

    protected boolean loadTextsFromDB(boolean _bCheckIfNeedLoad) throws WCMException {
        try {
            String _sTextFields;
            if (_bCheckIfNeedLoad) {
                int nPos = this.sTextFieldsList.indexOf(44);
                String sTextField = nPos > 0 ? this.sTextFieldsList.substring(0, nPos) : this.sTextFieldsList;
                try {
                    CDBText dbText = (CDBText)this.getProperty(sTextField);
                    if (dbText != null && dbText.isLoaded()) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                _sTextFields = this.sTextFieldsList;
            } else {
                StringBuffer sFieldsList = new StringBuffer(20);
                Enumeration<String> enKeys = this.getProperties().keys();
                String sKey = "";
                Object objValue = null;
                while (enKeys.hasMoreElements()) {
                    sKey = enKeys.nextElement();
                    objValue = this.getProperties().get(sKey);
                    if (objValue == null || !(objValue instanceof CDBText) || ((CDBText)objValue).isLoaded()) continue;
                    sFieldsList.append(sKey + ",");
                }
                if (sFieldsList.toString().length() <= 0) {
                    return false;
                }
                _sTextFields = sFieldsList.substring(0, sFieldsList.toString().length() - 1);
            }
            return this.loadTextsFromDB(_sTextFields);
        }
        catch (Exception ex) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label3", "\u88c5\u8f7d\u5927\u6587\u672c\u5b57\u6bb5\u65f6\u5931\u8d25(") + this.getClass().getName() + "loadTextFromDB)", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadTextsFromDB(String _sTextFields) throws WCMException {
        boolean bl;
        Connection oConn = null;
        boolean bOk = false;
        Statement oStmt = null;
        String strSQL = null;
        String strSelect = CMyString.filterForSQL2(this.getIdFieldName() + "," + _sTextFields);
        try {
            strSQL = "select " + strSelect + " from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=?";
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setInt(1, this.id);
            ResultSet rsData = oStmt.executeQuery();
            if (rsData.next()) {
                StringTokenizer stFields = new StringTokenizer(_sTextFields, ",");
                while (stFields.hasMoreElements()) {
                    String sField = (String)stFields.nextElement();
                    CDBText dbText = new CDBText(this.getDBManager().getDBType());
                    dbText.readFromRs(rsData, sField);
                    this.getProperties(true).put(sField, dbText);
                }
                bOk = true;
            }
            rsData.close();
            bl = bOk;
        }
        catch (Exception ex) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label4", "\u88c5\u8f7d\u5927\u6587\u672c\u5b57\u6bb5\u65f6\u5931\u8d25(SQL=") + strSQL + ")", ex);
            }
            catch (Throwable throwable) {
                try {
                    if (oStmt != null) {
                        oStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                throw throwable;
            }
        }
        try {
            if (oStmt != null) {
                oStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        return bl;
    }

    public boolean refreshProperty(String _sName, Object _oValue) throws WCMException {
        return this.refreshProperty(_sName, _oValue, true);
    }

    public boolean refreshProperty(String _sName, Object _oValue, boolean _bSendMsgOfCluster) throws WCMException {
        if (_sName == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label5", "\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a(") + this.getClass().getName() + ".refreshProperty)");
        }
        _sName = _sName.toUpperCase();
        this.checkPropertyValid(_sName, _oValue);
        this.getProperties(true).put(_sName, _oValue);
        if (_bSendMsgOfCluster && this.isCached() && _oValue instanceof Long) {
            try {
                IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                String[] pParameters = new String[]{String.valueOf(this.getWCMType()), this.getKey().toString(), _sName, _oValue.toString()};
                clusterMsgCenter.send("PO.RP", pParameters);
            }
            catch (Exception e) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
            }
        }
        if (this.isCached()) {
            BaseObj.getCachedPOMgr().refreshCache(this);
        }
        return true;
    }

    public boolean refreshProperty(String _sName, long _lValue) throws WCMException {
        return this.refreshProperty(_sName, new Long(_lValue));
    }

    public boolean refreshProperty(String _sName, boolean _bValue) throws WCMException {
        return this.refreshProperty(_sName, new Long(_bValue ? 1L : 0L));
    }

    public void refreshProperty(BaseObj _newObj) {
        this.getProperties(true).putAll(_newObj.getNewProperties(true));
    }

    private boolean checkPropertyValid(String _sName, Object _oValue) throws WCMException {
        if (this.isNullValue(_oValue)) {
            return true;
        }
        FieldInfo fi = this.getDBManager().getFieldInfo(this.getDbTableName(), _sName);
        if (fi == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + _sName + I18NMessage.get(BaseObj.class, "BaseObj.label7", "\u5728\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        boolean blTypeValid = false;
        boolean blValueValid = true;
        switch (fi.getDataType().getType()) {
            case 1: 
            case 12: {
                blTypeValid = _oValue instanceof String;
                if (!blTypeValid) break;
                int nLen = ((String)_oValue).length();
                if (nLen == 0) {
                    blValueValid = fi.isNullable();
                    break;
                }
                blValueValid = fi.getDataLength() == 0 ? true : nLen <= fi.getDataLength();
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                blTypeValid = _oValue instanceof Number;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                blTypeValid = _oValue instanceof CMyDateTime;
                if (!blTypeValid) break;
                blValueValid = fi.isNullable() || !((CMyDateTime)_oValue).isNull();
                break;
            }
            case -1: 
            case 2005: {
                blTypeValid = _oValue instanceof CDBText;
                if (!blTypeValid) break;
                blValueValid = fi.isNullable() || !((CDBText)_oValue).isNull();
                break;
            }
            default: {
                blTypeValid = false;
            }
        }
        if (!blTypeValid) {
            String sValueClassName = "null";
            if (_oValue != null) {
                sValueClassName = _oValue.getClass().getName();
            }
            throw new WCMException(1103, I18NMessage.get(BaseObj.class, "BaseObj.label8", "\u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff1a") + _sName + I18NMessage.get(BaseObj.class, "BaseObj.label9", "\u5e94\u4e3a") + fi.getDataTypeName() + I18NMessage.get(BaseObj.class, "BaseObj.label10", "\u578b[TypeId=") + fi.getDataType().getType() + "][Value.class=" + sValueClassName + "]");
        }
        if (!blValueValid) {
            throw new WCMException(1104, CMyString.format(I18NMessage.get(BaseObj.class, "BaseObj.label11", "\u5c5e\u6027{0}\u503c[{1}]\u4e0d\u6ee1\u8db3\u9650\u5236\u8981\u6c42({2})"), new String[]{_sName, _oValue.toString(), this.getClass().getName()}));
        }
        return true;
    }

    public boolean setProperty(String _sName, long _lValue) throws WCMException {
        return this.setProperty(_sName, new Long(_lValue));
    }

    public boolean setProperty(String _sName, boolean _bValue) throws WCMException {
        return this.setProperty(_sName, new Long(_bValue ? 1L : 0L));
    }

    public boolean setProperty(String _sName, Object _oValue, boolean _bCheckPropValid) throws WCMException {
        Object oValue = _oValue != null && _oValue instanceof Integer ? new Long(((Integer)_oValue).intValue()) : _oValue;
        _sName = _sName.toUpperCase();
        if (this.m_bCheckPropertyValid && _bCheckPropValid) {
            this.checkPropertyValid(_sName, oValue);
        }
        (this.isAddMode() ? this.getProperties(true) : this.getNewProperties(true)).put(_sName, oValue == null ? this.makeNullValue(_sName) : oValue);
        return true;
    }

    private Object makeNullValue(String _sName) throws WCMException {
        FieldInfo fi = this.getDBManager().getFieldInfo(this.getDbTableName(), _sName);
        if (fi == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + _sName + I18NMessage.get(BaseObj.class, "BaseObj.label7", "\u5728\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        return new NullValue(fi.getDataType().getType());
    }

    public boolean setProperty(String _sName, Object _oValue) throws WCMException {
        return this.setProperty(_sName, _oValue, true);
    }

    public Object removeProperty(String _sName) {
        if (_sName == null) {
            return null;
        }
        _sName = _sName.toUpperCase();
        if (this.isAddMode()) {
            return this.getProperties().remove(_sName);
        }
        if (this.getNewProperties() != null) {
            return this.getNewProperties().remove(_sName);
        }
        if (this.isCached()) {
            return null;
        }
        return this.getProperties().remove(_sName);
    }

    public boolean setTextProperty(String _sName, String _sText) throws WCMException {
        return this.setProperty(_sName, new CDBText(this.getDBManager().getDBType(), _sText));
    }

    public boolean setPropertyWithString(String _sName, String _sValue) throws WCMException {
        return this.setProperty(_sName, this.transformStringToObject(_sName, _sValue), false);
    }

    private Object transformStringToObject(String _sFieldName, String _sValue) throws WCMException {
        if (_sValue == null) {
            return null;
        }
        FieldInfo fi = this.getDBManager().getFieldInfo(this.getDbTableName(), _sFieldName);
        if (fi == null) {
            throw new WCMException(1101, I18NMessage.get(BaseObj.class, "BaseObj.label6", "\u5c5e\u6027") + _sFieldName + I18NMessage.get(BaseObj.class, "BaseObj.label13", "\u5728\u8868[") + this.getDbTableName() + I18NMessage.get(BaseObj.class, "BaseObj.label14", "]\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728(") + this.getClass().getName() + ".setProperty)");
        }
        int nType = fi.getDataType().getType();
        if (this.isNullValue(_sValue, nType)) {
            return new NullValue(nType);
        }
        Object oValue = _sValue;
        try {
            switch (nType) {
                case 2: 
                case 3: {
                    _sValue = _sValue.trim();
                    if (fi.getDataScale() == 0) {
                        oValue = new Long(_sValue);
                        break;
                    }
                    oValue = new Double(_sValue);
                    break;
                }
                case 6: 
                case 8: {
                    _sValue = _sValue.trim();
                    oValue = new Double(_sValue);
                    break;
                }
                case 1: 
                case 12: {
                    oValue = _sValue == null ? "" : _sValue;
                    break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    _sValue = _sValue.trim();
                    oValue = new Long(_sValue);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    _sValue = _sValue.trim();
                    oValue = new CMyDateTime();
                    if (_sValue != null && _sValue.trim().length() > 0) {
                        ((CMyDateTime)oValue).setDateTimeWithString(_sValue.trim());
                    }
                    break;
                }
                case -1: 
                case 2005: {
                    oValue = new CDBText(this.getDBManager().getDBType(), _sValue);
                    break;
                }
                default: {
                    oValue = _sValue == null ? "" : _sValue;
                    break;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(BaseObj.class, "BaseObj.label15", "\u65e0\u6548\u7684\u5c5e\u6027\u503c(") + _sFieldName + I18NMessage.get(BaseObj.class, "BaseObj.label16", "):\u7c7b\u578b\u5e94\u4e3a") + fi.getDataTypeName() + "(" + this.getClass().getName() + ".setProperty); nType=" + nType);
            ex.printStackTrace();
            oValue = null;
        }
        return oValue;
    }

    private boolean isNullValue(String _sValue, int nType) {
        if (_sValue != null && _sValue.length() > 0) {
            return false;
        }
        for (int i = 0; i < TYPES_ALLOW_NULL.length; ++i) {
            if (nType != TYPES_ALLOW_NULL[i]) continue;
            return true;
        }
        return false;
    }

    public AttributesString getAttributesString() {
        String sAttribute = this.getAttribute();
        return new AttributesString(sAttribute);
    }

    public AttributesString getNewAttributesString() {
        String sAttribute = this.getNewAttribute();
        return new AttributesString(sAttribute);
    }

    public String getAttribute() {
        if (this.getProperty("Attribute") == null) {
            return "";
        }
        return (String)this.getProperty("Attribute");
    }

    public String getNewAttribute() {
        if (this.getNewPropertyAsString("Attribute") == null) {
            return "";
        }
        return this.getNewPropertyAsString("Attribute");
    }

    public String getAttributeValue(String _sName) {
        AttributesString aAttributesString = this.getAttributesString();
        if (aAttributesString == null) {
            return "";
        }
        return aAttributesString.getAttributeValue(_sName);
    }

    public String getNewAttributeValue(String _sName) {
        AttributesString newAttributesString = this.getNewAttributesString();
        if (newAttributesString == null) {
            return "";
        }
        return newAttributesString.getAttributeValue(_sName);
    }

    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("Attribute", _attribute);
    }

    public boolean setAttribute(AttributesString _attribute) throws WCMException {
        if (_attribute == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label17", "\u65e0\u6548\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61(") + this.getClass().getName() + ".setAttribute)");
        }
        return this.setAttribute(_attribute.toString());
    }

    public boolean setAttribute(String _sName, String _sValue) throws WCMException {
        String sTemp;
        AttributesString aAttributesString = this.getAttributesString();
        if (!this.isAddMode() && (sTemp = (String)this.getNewProperty("ATTRIBUTE")) != null) {
            aAttributesString.setAttributes(sTemp);
        }
        aAttributesString.putAttributeValue(_sName, _sValue);
        return this.setAttribute(aAttributesString);
    }

    public CMyDateTime getCrTime() {
        return (CMyDateTime)this.getProperty("CRTIME");
    }

    protected boolean setCrTime() throws WCMException {
        return this.setProperty("CRTIME", CMyDateTime.now());
    }

    public boolean isValidInstance() {
        return !this.bAddMode && this.id > 0;
    }

    public boolean isAddMode() {
        return this.bAddMode;
    }

    public final void readFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        this.readFromRs(_rsData, _rsmdData, this.getIdFieldName());
    }

    public final void readFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData, String _sIdName) throws WCMException {
        try {
            if (_rsData == null) {
                return;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        Double dValue = new Double(_rsData.getDouble(i));
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 1: 
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(this.getDBManager().getDBType());
                        if (this.bIsLoadText || this.isCached()) {
                            ((CDBText)objValue).readFromRs(_rsData, i);
                        }
                        if (this.isCached()) break;
                        this.sTextFieldsList = (this.sTextFieldsList == null ? "" : this.sTextFieldsList + ",") + sFieldName;
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                if (this.m_bLoadNewPropertyById) {
                    this.getNewProperties(true).put(sFieldName, objValue);
                    continue;
                }
                this.getProperties(true).put(sFieldName, objValue);
            }
            if (!this.m_bLoadNewPropertyById) {
                this.id = this.getPropertyAsInt(_sIdName, 0);
                this.bAddMode = false;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label18", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".readFromRs).", ex);
        }
    }

    public boolean equals(int _id) {
        return !this.bAddMode && this.id == _id;
    }

    public boolean equals(Object _another) {
        if (_another == null) {
            return false;
        }
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof BaseObj)) {
            return false;
        }
        if (this.bAddMode) {
            return false;
        }
        BaseObj anotherObj = (BaseObj)_another;
        return this.getWCMType() == anotherObj.getWCMType() && this.id == anotherObj.getId();
    }

    public Hashtable<String, Object> cloneProperties() {
        Hashtable<String, Object> hMyProperties = this.getAllProperty();
        return hMyProperties == null ? null : (Hashtable)hMyProperties.clone();
    }

    public synchronized Object clone() {
        BaseObj newObj = null;
        try {
            newObj = (BaseObj)this.getClass().newInstance();
            newObj.setProperties(this.getProperties());
            newObj.setNewProperties(this.getNewProperties());
            newObj.id = this.id;
            newObj.bAddMode = this.bAddMode;
            newObj.m_bFromClone = true;
            return newObj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public synchronized BaseObj cloneToNewObj() throws WCMException {
        BaseObj newObj = null;
        try {
            newObj = (BaseObj)this.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new WCMException(1351, I18NMessage.get(BaseObj.class, "BaseObj.label19", "\u4ea7\u751f\u5f53\u524d\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25\uff01"), ex);
        }
        newObj.bAddMode = true;
        newObj.setProperties(this.getAllProperty());
        newObj.removeProperty(this.getIdFieldName());
        newObj.removeProperty("CRTIME");
        return newObj;
    }

    public synchronized BaseObj cloneToNewWCMObj() throws WCMException {
        return this.cloneToNewObj();
    }

    public abstract boolean isValid() throws WCMException;

    public boolean checkExists(String _sCondition) throws WCMException {
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsCount = null;
        String strSQL = "select count(*) from " + this.getDbTableName() + " where " + _sCondition;
        boolean blExists = false;
        try {
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.createStatement();
            rsCount = oStmt.executeQuery(strSQL);
            rsCount.next();
            blExists = rsCount.getInt(1) > 0;
            rsCount.close();
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label20", "\u5728\u6570\u636e\u4e2d\u68c0\u67e5\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519(") + this.getClass().getName() + ".checkExists)", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label20", "\u5728\u6570\u636e\u4e2d\u68c0\u67e5\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519(") + this.getClass().getName() + ".checkExists)", ex);
        }
        finally {
            try {
                if (oStmt != null) {
                    oStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
        return blExists;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert() throws WCMException {
        ObjectLCMonitorServer aMonitor3333332;
        Connection oConn;
        block18: {
            if (!this.isAddMode()) throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            if (!this.isValid()) throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            if (this.getProperties() == null) {
                throw new WCMException(1105, I18NMessage.get(BaseObj.class, "BaseObj.label21", "\u6dfb\u52a0\u7684\u5bf9\u8c61\u65e0\u6548(") + this.getClass().getName() + ".insert)");
            }
            oConn = null;
            Statement oPreStmt = null;
            try {
                this.getNextId(oConn);
                this.setProperty(this.getIdFieldName(), new Long(this.id));
                if (this.isEnableListener() && (aMonitor3333332 = ObjectLCMonitorServer.getMonitorServer()).isDoNotify(-1, this)) {
                    aMonitor3333332.notifyOnBeforeAddObj(this);
                }
                oConn = this.getDBManager().getConnection();
                oPreStmt = oConn.prepareStatement(this.createInsertSQL());
                this.setParameters((PreparedStatement)oPreStmt);
                oPreStmt.executeUpdate();
                this.bAddMode = false;
                if (this.sClobFields_toUpdate != null) {
                    this.updateClobFields(oConn, true);
                }
                if (oPreStmt == null) break block18;
            }
            catch (SQLException ex) {
                try {
                    throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label22", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25(") + this.getClass().getName() + ".insert).", ex);
                    catch (Exception ex2) {
                        throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label22", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25(") + this.getClass().getName() + ".insert).", ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (oPreStmt != null) {
                        try {
                            oPreStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (oConn == null) throw throwable;
                    this.getDBManager().freeConnection(oConn);
                    throw throwable;
                }
            }
            try {
                oPreStmt.close();
            }
            catch (Exception aMonitor3333332) {
                // empty catch block
            }
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        if (this.isCached()) {
            this.loadFromDB();
            BaseObj.getCachedPOMgr().notifyOnAddObj(this);
        }
        if (this.isEnableListener() && (aMonitor3333332 = ObjectLCMonitorServer.getMonitorServer()).isDoNotify(1, this)) {
            aMonitor3333332.notifyOnAddObj(this);
        }
        try {
            IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            clusterMsgCenter.send(this.getWCMType(), this.getId(), 1, null);
            return;
        }
        catch (Exception e) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws WCMException {
        if (!this.isModified()) {
            return;
        }
        try {
            if (!this.isValid()) {
                return;
            }
            ObjectLCMonitorServer aMonitor = ObjectLCMonitorServer.getMonitorServer();
            if (this.isEnableListener() && aMonitor.isDoNotify(5, this)) {
                aMonitor.notifyOnModifyObj(this, 5);
            }
            Connection oConn = null;
            Statement oPreStmt = null;
            try {
                oConn = this.getDBManager().getConnection();
                String strSQL = this.createUpdateSQL();
                if (strSQL != null) {
                    oPreStmt = oConn.prepareStatement(strSQL);
                    int index = this.setParameters((PreparedStatement)oPreStmt);
                    oPreStmt.setInt(index, this.id);
                    oPreStmt.executeUpdate();
                }
                if (this.sClobFields_toUpdate != null) {
                    this.updateClobFields(oConn, false);
                }
            }
            catch (SQLException ex) {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label23", "\u66f4\u65b0\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".update)", ex);
            }
            catch (Exception ex) {
                throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label23", "\u66f4\u65b0\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".update)", ex);
            }
            finally {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
            }
            this.updateOthersAfterModified();
            boolean bAnalyzeNotLog = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ANALYZE_NOT_LOG", "false").trim());
            int nObjType = this.getWCMType();
            boolean bAnalyzeCurrObj = false;
            if (bAnalyzeNotLog && this.isEnableListener()) {
                String[] pListnerObjectIds = ConfigServer.getServer().getSysConfigValue("ANALYZE_NOT_LOG_OBJTYPES", "605").split(",");
                for (int i = 0; i < pListnerObjectIds.length; ++i) {
                    String sObjectId = pListnerObjectIds[i].trim();
                    if (!sObjectId.equals("" + nObjType)) continue;
                    bAnalyzeCurrObj = true;
                    break;
                }
            }
            if (bAnalyzeCurrObj) {
                try {
                    String QUERY_EXISTS_LOG = "select 1 from WCMLog where LOGOBJTYPE=? and LogObjId=? and  ExecTime=0";
                    int nResult = this.getDBManager().sqlExecuteIntQuery("select 1 from WCMLog where LOGOBJTYPE=? and LogObjId=? and  ExecTime=0", new int[]{nObjType, this.getId()});
                    if (nResult != 1) {
                        s_logger.warn((Object)("[" + this + "] not record log!!!!!"), (Throwable)new Exception());
                    }
                }
                catch (Exception e) {
                    s_logger.error((Object)"\u5224\u65ad\u65e5\u5fd7\u662f\u5426\u9700\u8981\u8ddf\u8e2a\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
            if (this.isCached()) {
                BaseObj.getCachedPOMgr().notifyOnModifyObj(this, 2);
            }
            if (this.isEnableListener() && aMonitor.isDoNotify(2, this)) {
                aMonitor.notifyOnModifyObj(this, 2);
            }
            try {
                IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                clusterMsgCenter.send(this, 2);
            }
            catch (Exception e) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
            }
            this.setProperties(this.getNewProperties());
        }
        finally {
            this.clearNewProperties();
        }
    }

    protected void updateOthersAfterModified() {
    }

    public synchronized void cancelUpdate() {
        this.clearNewProperties();
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
    }

    protected String createInsertSQL() throws WCMException {
        String sTableName = this.getDbTableName();
        FieldInfo fi = null;
        boolean bFirst = true;
        Enumeration<String> enumKey = null;
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
        String strSQL = "INSERT INTO " + sTableName + "(";
        String strValues = " VALUES(";
        enumKey = this.getProperties().keys();
        while (enumKey.hasMoreElements()) {
            String sValue;
            String sKey = enumKey.nextElement();
            fi = this.getDBManager().getFieldInfo(sTableName, sKey);
            if (fi == null) {
                s_logger.warn((Object)("The field[" + sTableName + "." + sKey + "] not exists! Ignore to insert!"));
                continue;
            }
            switch (fi.getDataType().getType()) {
                case 2005: {
                    this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                    ++this.nUpdateClobCount;
                    int nDBType = this.getDBManager().getDBTypeAsInt();
                    if (nDBType == 6 || nDBType == 3 || nDBType == 5) {
                        sValue = "clob('')";
                        break;
                    }
                    if (nDBType == 7 || nDBType == 10) {
                        sValue = "' '";
                        break;
                    }
                    sValue = "empty_clob()";
                    break;
                }
                case -1: {
                    int nDBType = this.getDBManager().getDBTypeAsInt();
                    if (nDBType == 3 || nDBType == 5 || nDBType == 7) {
                        this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                        ++this.nUpdateClobCount;
                        if (nDBType == 7) {
                            sValue = "' '";
                            break;
                        }
                        sValue = "clob('')";
                        break;
                    }
                    sValue = "?";
                    break;
                }
                default: {
                    sValue = "?";
                }
            }
            if (bFirst) {
                strSQL = strSQL + sKey;
                strValues = strValues + sValue;
                bFirst = false;
                continue;
            }
            strSQL = strSQL + "," + sKey;
            strValues = strValues + "," + sValue;
        }
        if (bFirst) {
            return null;
        }
        return strSQL + ") " + strValues + ")";
    }

    protected int setParameters(PreparedStatement _oPreStmt) throws WCMException {
        if (_oPreStmt == null) {
            return 0;
        }
        FieldInfo fi = null;
        String sTableName = this.getDbTableName();
        DBType currDbType = this.getDBManager().getDBType();
        String sKey = null;
        Object value = null;
        int index = 1;
        try {
            Hashtable<String, Object> thePropertys = this.isAddMode() ? this.getProperties() : this.getNewProperties();
            Enumeration<String> enumKey = thePropertys.keys();
            while (enumKey.hasMoreElements()) {
                sKey = enumKey.nextElement();
                fi = this.getDBManager().getFieldInfo(sTableName, sKey);
                if (fi == null) {
                    s_logger.warn((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label24", "\u5b57\u6bb5[") + sKey + I18NMessage.get(BaseObj.class, "BaseObj.label25", "]\u5728\u8868[") + sTableName + I18NMessage.get(BaseObj.class, "BaseObj.label26", "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\uff01")));
                    continue;
                }
                value = thePropertys.get(sKey);
                if (value instanceof NullValue) {
                    _oPreStmt.setNull(index++, ((NullValue)value).getDataType());
                    continue;
                }
                if (value instanceof Long) {
                    _oPreStmt.setLong(index++, (Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    _oPreStmt.setDouble(index++, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    _oPreStmt.setInt(index++, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    value = currDbType.encodeStrToWrite((String)value);
                    currDbType.setStringFieldValue(_oPreStmt, index++, (String)value, fi.isNullable());
                    continue;
                }
                if (value instanceof CMyDateTime) {
                    _oPreStmt.setTimestamp(index++, ((CMyDateTime)value).toTimestamp());
                    continue;
                }
                if (value instanceof CDBText) {
                    if (!currDbType.canWriteTextDirectly()) continue;
                    _oPreStmt.setString(index++, currDbType.encodeStrToWrite(((CDBText)value).getText()));
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(BaseObj.class, "BaseObj.label27", "\u672a\u77e5\u7684\u5bf9\u8c61") + sKey + I18NMessage.get(BaseObj.class, "BaseObj.label28", "\u5c5e\u6027\u7c7b\u578b\uff1a(") + this.getClass().getName() + ".setParameters)");
            }
        }
        catch (SQLException ex) {
            String sContextInfo = "";
            if (value != null && value instanceof NullValue) {
                sContextInfo = "Is Null Value FieldName=" + sKey + ", Value.Type=" + ((NullValue)value).getDataType();
            } else if (value != null) {
                sContextInfo = "FieldName=" + sKey + ", Value.Type=" + value.getClass();
            }
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label29", "\u5199\u5165\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38(") + sContextInfo + ")", ex);
        }
        catch (Exception ex) {
            String sContextInfo = "";
            if (value != null && value instanceof NullValue) {
                sContextInfo = "Is Null Value FieldName=" + sKey + ", Value.Type=" + ((NullValue)value).getDataType();
            } else if (value != null) {
                sContextInfo = "TableName=" + this.getDbTableName() + ", FieldName=" + sKey + ", Value.Type=" + value.getClass();
            }
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label30", "\u5199\u5165\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519(") + sContextInfo + ")", ex);
        }
        return index;
    }

    protected synchronized void updateClobFields(Connection _oConn, boolean _blIsAddNew) throws WCMException {
        if (this.sClobFields_toUpdate == null) {
            return;
        }
        boolean bUpdateClobNewMode = true;
        if (bUpdateClobNewMode) {
            this.updClob(_oConn, _blIsAddNew);
            return;
        }
        String sIdFieldName = this.getIdFieldName();
        CDBText clobText = null;
        try {
            if (this.nUpdateClobCount == 1) {
                clobText = (CDBText)(_blIsAddNew ? this.getProperties() : this.getNewProperties()).get(this.sClobFields_toUpdate);
                if (clobText == null) {
                    return;
                }
                this.getDBManager().getDBType().setClob(_oConn, this.getDbTableName(), sIdFieldName + "=" + this.getId(), sIdFieldName, this.sClobFields_toUpdate, clobText.getText());
            } else {
                StringTokenizer stClobs = new StringTokenizer(this.sClobFields_toUpdate, ",");
                String[] asFieldsAndValues = new String[this.nUpdateClobCount * 2];
                int index = 0;
                while (stClobs.hasMoreElements()) {
                    String sClobName = (String)stClobs.nextElement();
                    clobText = (CDBText)(_blIsAddNew ? this.getProperties() : this.getNewProperties()).get(sClobName);
                    asFieldsAndValues[index++] = sClobName;
                    asFieldsAndValues[index++] = clobText.getText();
                }
                this.getDBManager().getDBType().setClob(_oConn, this.getDbTableName(), sIdFieldName + "=" + this.getId(), sIdFieldName, asFieldsAndValues);
            }
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label31", "\u66f4\u65b0CLOB\u5b57\u6bb5\u503c\u65f6\u51fa\u9519(") + this.getClass().getName() + ".updateClobFields)", ex);
        }
    }

    private void updClob(Connection _oConn, boolean _blIsAddNew) throws WCMException {
        String sIdFieldName = this.getIdFieldName();
        try {
            Hashtable<String, Object> props;
            DBType dbType = this.getDBManager().getDBType();
            Hashtable<String, Object> hashtable = props = _blIsAddNew ? this.getProperties() : this.getNewProperties();
            if (this.nUpdateClobCount == 1) {
                CDBText clobText = (CDBText)props.get(this.sClobFields_toUpdate);
                if (clobText == null) {
                    return;
                }
                dbType.setClob(_oConn, this.getDbTableName(), sIdFieldName, this.id, this.sClobFields_toUpdate, clobText.getText());
            } else {
                StringTokenizer stClobs = new StringTokenizer(this.sClobFields_toUpdate, ",");
                String[] asFieldsAndValues = new String[this.nUpdateClobCount * 2];
                int index = 0;
                while (stClobs.hasMoreElements()) {
                    String sClobName = (String)stClobs.nextElement();
                    CDBText clobText = (CDBText)props.get(sClobName);
                    asFieldsAndValues[index++] = sClobName;
                    asFieldsAndValues[index++] = clobText.getText();
                }
                dbType.setClob(_oConn, this.getDbTableName(), sIdFieldName, this.id, asFieldsAndValues);
            }
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(BaseObj.class, "BaseObj.label31", "\u66f4\u65b0CLOB\u5b57\u6bb5\u503c\u65f6\u51fa\u9519(") + this.getClass().getName() + ".updateClobFields)", ex);
        }
    }

    protected synchronized String createUpdateSQL() throws WCMException {
        boolean bFirst = true;
        FieldInfo fi = null;
        String sTableName = this.getDbTableName();
        this.sClobFields_toUpdate = null;
        this.nUpdateClobCount = 0;
        String strSQL = "UPDATE " + sTableName + " SET  ";
        Enumeration<String> enumKey = this.getNewProperties().keys();
        block4: while (enumKey.hasMoreElements()) {
            String sKey = enumKey.nextElement();
            fi = this.getDBManager().getFieldInfo(sTableName, sKey);
            if (fi == null) {
                s_logger.warn((Object)("The field[" + sTableName + "." + sKey + "] not exists! Ignore to update!"));
                continue;
            }
            if (bFirst) {
                bFirst = false;
            } else {
                strSQL = strSQL + ",";
            }
            switch (fi.getDataType().getType()) {
                case 2005: {
                    this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                    ++this.nUpdateClobCount;
                    int nDBType = this.getDBManager().getDBTypeAsInt();
                    if (nDBType == 6 || nDBType == 3 || nDBType == 5) {
                        strSQL = strSQL + sKey + "=clob('')";
                        continue block4;
                    }
                    if (nDBType == 7 || nDBType == 10) {
                        strSQL = strSQL + sKey + "=' '";
                        continue block4;
                    }
                    strSQL = strSQL + sKey + "=empty_clob()";
                    continue block4;
                }
                case -1: {
                    int nDBType = this.getDBManager().getDBTypeAsInt();
                    if (nDBType == 3 || nDBType == 5 || nDBType == 7) {
                        if (nDBType == 7) {
                            strSQL = strSQL + sKey + "=' '";
                        }
                        strSQL = strSQL + sKey + "=clob('')";
                        continue block4;
                    }
                    strSQL = strSQL + sKey + "=?";
                    continue block4;
                }
            }
            strSQL = strSQL + sKey + "=?";
        }
        if (bFirst) {
            return null;
        }
        strSQL = strSQL + " where " + this.getIdFieldName() + "=?";
        return strSQL;
    }

    /*
     * Loose catch block
     */
    public boolean reload() throws WCMException {
        boolean bl;
        ResultSet rsData;
        Statement oStmt;
        Connection oConn;
        block27: {
            block25: {
                boolean bl2;
                block26: {
                    if (!this.isValidInstance()) {
                        return false;
                    }
                    oConn = null;
                    oStmt = null;
                    rsData = null;
                    String strSQL = "select * from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=" + this.getId();
                    oConn = this.getDBManager().getConnection();
                    oStmt = oConn.createStatement();
                    oStmt.setMaxRows(1);
                    rsData = oStmt.executeQuery(strSQL);
                    if (rsData.next()) break block25;
                    bl2 = false;
                    if (rsData == null) break block26;
                    try {
                        rsData.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oStmt != null) {
                    try {
                        oStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                return bl2;
            }
            this.readFromRs(rsData, null);
            bl = true;
            if (rsData == null) break block27;
            try {
                rsData.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oStmt != null) {
            try {
                oStmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        return bl;
        catch (Exception ex) {
            try {
                throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label32", "\u91cd\u65b0\u88c5\u8f7d\u5bf9\u8c61\u6570\u636e\u5931\u8d25(") + this.getClass().getName() + ".reload)", ex);
            }
            catch (Throwable throwable) {
                if (rsData != null) {
                    try {
                        rsData.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oStmt != null) {
                    try {
                        oStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                throw throwable;
            }
        }
    }

    public int delete() throws WCMException {
        ObjectLCMonitorServer aMonitor = ObjectLCMonitorServer.getMonitorServer();
        int nEventType = 3;
        if (this.isEnableListener() && aMonitor.isDoNotify(nEventType, this)) {
            aMonitor.notifyOnDelObj(this, nEventType);
        }
        this.deleteOthersBeforeDelete();
        Connection oConn = null;
        Statement oStmt = null;
        int nDelCount = 0;
        if (!this.isValidInstance()) {
            return 0;
        }
        try {
            oConn = this.getDBManager().getConnection();
            String strSQL = "delete from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=" + this.id;
            oStmt = oConn.createStatement();
            nDelCount = oStmt.executeUpdate(strSQL);
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label33", "\u4ece\u6570\u636e\u5e93\u4e2d\u5220\u9664\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".delete)", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label33", "\u4ece\u6570\u636e\u5e93\u4e2d\u5220\u9664\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519(") + this.getClass().getName() + ".delete)", ex);
        }
        finally {
            try {
                if (oStmt != null) {
                    oStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
        nEventType = 4;
        boolean bIsCached = this.isCached();
        if (bIsCached) {
            BaseObj.getCachedPOMgr().notifyOnDelObj(this, nEventType);
        }
        if (this.isEnableListener() && aMonitor.isDoNotify(nEventType, this)) {
            aMonitor.notifyOnDelObj(this, nEventType);
        }
        try {
            IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            clusterMsgCenter.send(this, 3);
        }
        catch (Exception e) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
        }
        return nDelCount;
    }

    protected void deleteOthersBeforeDelete() {
    }

    protected synchronized int getNextId() throws WCMException {
        Connection oConn = null;
        try {
            oConn = this.getDBManager().getConnection();
            int n = this.getNextId(oConn);
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label34", "\u83b7\u53d6\u4e0b\u4e00\u4e2a\u53ef\u7528\u7684ID\u503c\u5931\u8d25(") + this.getClass().getName() + ".getNextId)", ex);
        }
        finally {
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    protected synchronized int getNextId(Connection _oConn) throws WCMException {
        return this.getNextId(_oConn, this.getDbTableName(), this.getIdFieldName());
    }

    protected synchronized int getNextId(Connection _oConn, String _sTableName, String _sIdFieldName) throws WCMException {
        if (this.id <= 0) {
            int nNextId = this.getDBManager().getDBIdManager().getNextId(_sTableName, _sIdFieldName, _oConn, true);
            if (nNextId <= 0) {
                throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label35", "\u83b7\u53d6\u7684ID\u503c\u65e0\u6548\uff1a") + nNextId + "(" + this.getClass().getName() + ".getNextId)");
            }
            this.id = nNextId;
        }
        return this.id;
    }

    public boolean setProperty(String _sName, double _dValue) throws WCMException {
        return this.setProperty(_sName, new Double(_dValue));
    }

    public double getPropertyAsDouble(String _sName, double _dDefault) {
        Object objValue = this.getProperty(_sName);
        return this.isNullValue(objValue) ? _dDefault : (Double)objValue;
    }

    public boolean isChangeProperty(String _sName) {
        if (this.m_hNewProperties == null || this.m_hNewProperties.isEmpty()) {
            return false;
        }
        Object sNewValue = this.m_hNewProperties.get(_sName = _sName.toUpperCase());
        if (sNewValue == null) {
            return false;
        }
        Object sOldValue = this.m_hProperties.get(_sName);
        return !sNewValue.equals(sOldValue);
    }

    public void setLoadText(boolean _isLoadText) {
        this.bIsLoadText = _isLoadText;
    }

    public void save() throws WCMException {
        if (this.isAddMode()) {
            this.insert();
        } else {
            this.update();
        }
    }

    public static BaseObj createNewInstance(Class _classWCMObj) throws WCMException {
        if (_classWCMObj == null) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label36", "\u4f20\u5165\u7684Class\u5bf9\u8c61\u6709\u8bef\uff01"));
        }
        try {
            return (BaseObj)_classWCMObj.newInstance();
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(BaseObj.class, "BaseObj.label37", "\u4ea7\u751fClass[") + _classWCMObj.getName() + I18NMessage.get(BaseObj.class, "BaseObj.label38", "]\u5b9e\u4f8b\u5931\u8d25\uff01"), ex);
        }
    }

    public static BaseObj createNewInstance(String _sClassName) throws WCMException {
        Class<?> classWCMObj = null;
        try {
            classWCMObj = Class.forName(_sClassName);
        }
        catch (Exception ex) {
            throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label39", "\u4ea7\u751f[") + _sClassName + I18NMessage.get(BaseObj.class, "BaseObj.label40", "]Class\u5931\u8d25\uff01"), ex);
        }
        return BaseObj.createNewInstance(classWCMObj);
    }

    public void setNextId() throws WCMException {
        this.getNextId();
    }

    public void releaseProperty(String _sName) throws WCMException {
        try {
            if (this.getProperties() == null || this.isCached()) {
                return;
            }
            Object objValue = this.getProperty(_sName);
            if (objValue == null) {
                return;
            }
            if (objValue instanceof CDBText) {
                objValue = null;
                this.getProperties().put(_sName.toUpperCase(), new CDBText(this.getDBManager().getDBTypeAsInt()));
            } else {
                this.getProperties().remove(_sName.toUpperCase());
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObj.class, "BaseObj.label41", "\u6e05\u7a7a\u5c5e\u6027\u5931\u8d25(") + this.getClass().getName() + ".releaseProperty)", ex);
        }
    }

    protected static ICachedPOMgr getCachedPOMgr() throws WCMException {
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (currCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        return currCachedPOMgr;
    }

    public int getNewPropertyAsInt(String _sPropertyName, int _nDefault) {
        Object objValue = this.getNewProperty(_sPropertyName);
        return objValue == null ? _nDefault : ((Number)objValue).intValue();
    }

    public String getNewPropertyAsString(String _sPropertyName) {
        Object oValue = this.getNewProperty(_sPropertyName);
        if (oValue == null) {
            return null;
        }
        return oValue.toString();
    }

    protected DBManager getDBManager() {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new Error(I18NMessage.get(BaseObj.class, "BaseObj.label42", "\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u5e38\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    protected boolean loadFromDB() throws WCMException {
        return this.loadFromDB("*");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadFromDB(String _sSelectFields) throws WCMException {
        boolean bl;
        String strSQL;
        ResultSet rsData;
        Statement oStmt;
        Connection oConn;
        block29: {
            block27: {
                boolean bl2;
                block28: {
                    String sSelectField;
                    if (this.getId() <= 0) {
                        throw new WCMException(10, I18NMessage.get(BaseObj.class, "BaseObj.label43", "\u6ca1\u6709\u8bbe\u7f6eID\uff01"));
                    }
                    String string = sSelectField = _sSelectFields == null ? "*" : _sSelectFields.trim();
                    if (sSelectField.length() <= 0) {
                        sSelectField = "*";
                    }
                    oConn = null;
                    oStmt = null;
                    rsData = null;
                    ResultSetMetaData rsmdData = null;
                    strSQL = "";
                    strSQL = "select " + sSelectField + " from " + this.getDbTableName() + " where " + this.getIdFieldName() + "=?";
                    oConn = this.getDBManager().getConnection();
                    oStmt = oConn.prepareStatement(strSQL);
                    oStmt.setInt(1, this.id);
                    oStmt.setMaxRows(1);
                    rsData = oStmt.executeQuery();
                    if (!rsData.next()) break block27;
                    rsmdData = rsData.getMetaData();
                    this.readFromRs(rsData, rsmdData);
                    bl2 = true;
                    if (rsData == null) break block28;
                    try {
                        rsData.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oStmt != null) {
                    try {
                        oStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                return bl2;
            }
            bl = false;
            if (rsData == null) break block29;
            try {
                rsData.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oStmt != null) {
            try {
                oStmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        return bl;
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObj.class, "BaseObj.label44", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25(") + this.getClass().getName() + ".loadFromDB)\uff1aSQL=" + strSQL, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(BaseObj.class, "BaseObj.label44", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25(") + this.getClass().getName() + ".loadFromDB)\uff1aSQL=" + strSQL, ex2);
                }
            }
            catch (Throwable throwable) {
                if (rsData != null) {
                    try {
                        rsData.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oStmt != null) {
                    try {
                        oStmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                throw throwable;
            }
        }
    }

    public Hashtable<String, Object> getProperties() {
        return this.getProperties(false);
    }

    protected Hashtable<String, Object> getProperties(boolean _bNeedCheckInit) {
        if (this.m_hProperties == null && _bNeedCheckInit) {
            this.m_hProperties = new Hashtable();
        }
        return this.m_hProperties;
    }

    public void setNewProperties(Hashtable<String, Object> newProperties) {
        if (newProperties == null) {
            return;
        }
        this.getNewProperties(true).putAll(newProperties);
    }

    public void setId(int _nId) {
        this.id = _nId;
    }

    public synchronized boolean loadById(int _nId, String _sSelectFields) throws WCMException {
        return this.loadById(_nId, _sSelectFields, false);
    }

    public synchronized boolean loadById(int _nId, String _sSelectFields, boolean _bLoadNewProperty) throws WCMException {
        this.id = _nId;
        this.bAddMode = false;
        this.m_bLoadNewPropertyById = _bLoadNewProperty;
        boolean bResult = this.loadFromDB(_sSelectFields);
        this.m_bLoadNewPropertyById = false;
        return bResult;
    }

    public static BaseObj findById(int _nObjType, int _nId) throws WCMException {
        Class currClass = ObjectTypesFinder.findObjectClassByType(_nObjType);
        if (currClass == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + _nObjType + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        return BaseObj.findById(currClass, _nId);
    }

    public static BaseObj findById(Class _objClass, int _nId) throws WCMException {
        if (_nId <= 0 || _objClass == null) {
            return null;
        }
        if (BaseObj.getCachedPOMgr().isCached(_objClass)) {
            return BaseObj.getCachedPOMgr().getObjFromBuffer(_objClass, _nId);
        }
        BaseObj currObj = null;
        try {
            currObj = (BaseObj)_objClass.newInstance();
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(BaseObj.class, "BaseObj.label47", "\u6307\u5b9a\u7684Class[") + _objClass + I18NMessage.get(BaseObj.class, "BaseObj.label48", "]\u4e0d\u662fBaseObj\u7684\u5b50\u7c7b\uff01")), (Throwable)ex);
            return null;
        }
        currObj.id = _nId;
        if (currObj.loadFromDB()) {
            return currObj;
        }
        return null;
    }

    public static BaseObj findByKey(Class _objClass, Object _oKey) throws WCMException {
        Integer oKey = (Integer)_oKey;
        if (BaseObj.getCachedPOMgr().isCached(_objClass)) {
            return BaseObj.getCachedPOMgr().getObjFromBuffer(_objClass, _oKey);
        }
        return BaseObj.findById(_objClass, (int)oKey);
    }

    public Map<String, Object> getExtProperties() {
        return this.m_hExtProperties;
    }

    public void setExtProperty(String _sName, Object _oValue) {
        if (CMyString.isEmpty(_sName)) {
            return;
        }
        this.m_hExtProperties.put(_sName.toUpperCase(), _oValue);
    }

    public Object getExtProperty(String _sName) {
        if (CMyString.isEmpty(_sName)) {
            return null;
        }
        return this.m_hExtProperties.get(_sName.toUpperCase());
    }
}

