/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.index.LuceneContext;
import com.trs.index.domain.IndexTmpMgr;
import com.trs.index.persistent.IndexTemp;
import com.trs.index.persistent.IndexTemps;
import com.trs.index.util.IndexUtil;
import com.trs.index.vo.IndexField;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.NRTManager;

public class IndexMrg {
    private static Logger m_oLogger = Logger.getLogger(IndexMrg.class);
    private static final IndexTmpMgr m_oIndexTempMgr = (IndexTmpMgr)DreamFactory.createObjectById("IndexTmpMgr");

    public void addIndex(IndexField fields, boolean inDatabase, int operType) throws WCMException {
        try {
            if (inDatabase) {
                m_oLogger.debug((Object)"\u63d2\u5165\u6570\u636e\u5e93");
                IndexTemp indexTemp = new IndexTemp();
                indexTemp.setRecID(((Long)fields.getProperty("RECID")).intValue());
                indexTemp.setOperator(operType);
                m_oIndexTempMgr.add(indexTemp);
            }
            NRTManager nrtMgr = LuceneContext.getInstance().getNRTManager();
            Document doc = IndexUtil.field2Doc(fields);
            m_oLogger.debug((Object)"\u65b0\u589e\u7d22\u5f15");
            nrtMgr.addDocument(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteIndex(int id, boolean inDatabase, int operType) {
        try {
            if (inDatabase) {
                IndexTemp indexTemp = new IndexTemp();
                indexTemp.setRecID(id);
                indexTemp.setOperator(operType);
                m_oIndexTempMgr.add(indexTemp);
            }
            m_oLogger.debug((Object)"\u5220\u9664\u7d22\u5f15");
            LuceneContext.getInstance().getNRTManager().deleteDocuments(new Term("RECID", id + ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateIndex(IndexField fields, boolean inDatabase, int operType) {
        try {
            if (inDatabase) {
                IndexTemp indexTemp = new IndexTemp();
                indexTemp.setRecID(((Long)fields.getProperty("RECID")).intValue());
                indexTemp.setOperator(IndexUtil.INDEX_UPD);
                m_oIndexTempMgr.add(indexTemp);
            }
            m_oLogger.debug((Object)"\u66f4\u65b0\u7d22\u5f15");
            NRTManager nrtMgr = LuceneContext.getInstance().getNRTManager();
            Document doc = IndexUtil.field2Doc(fields);
            nrtMgr.updateDocument(new Term("RECID", fields.getProperty("RECID") + ""), doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateSetIndex() {
        IndexTemps indexTemps = m_oIndexTempMgr.getAll();
        m_oLogger.info((Object)"\u5f00\u8bfb\u53d6\u6570\u636e\u5e93\u4e2d\u7684\u7f13\u5b58\u7d22\u5f15");
        for (int i = 0; i < indexTemps.size(); ++i) {
            IndexTemp indexTemp = (IndexTemp)indexTemps.getAt(i);
            int recId = indexTemp.getRecID();
            int oper = indexTemp.getOperator();
            try {
                ChnlDoc chnlDoc = ChnlDoc.findById(recId);
                if (chnlDoc == null) continue;
                IndexField indexField = IndexUtil.chnlDoc2Field(chnlDoc);
                if (oper == IndexUtil.INDEX_ADD) {
                    this.deleteIndex(recId, false, IndexUtil.INDEX_DEL);
                    this.addIndex(indexField, false, IndexUtil.INDEX_ADD);
                } else if (oper == IndexUtil.INDEX_DEL) {
                    this.deleteIndex(recId, false, IndexUtil.INDEX_DEL);
                } else {
                    this.updateIndex(indexField, false, IndexUtil.INDEX_UPD);
                }
                indexTemp.delete();
                continue;
            }
            catch (WCMException e) {
                e.printStackTrace();
            }
        }
        LuceneContext.getInstance().commitIndex();
        m_oLogger.info((Object)"\u6784\u5efa\u7d22\u5f15\u5b8c\u6bd5");
    }
}

