/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.stat.domain.ChartBuildException;
import com.trs.components.wcm.stat.domain.ChartOption;
import com.trs.components.wcm.stat.domain.ChartStyle;
import com.trs.components.wcm.stat.domain.IChartBuilder;
import com.trs.components.wcm.stat.domain.StatDataItem;
import com.trs.components.wcm.stat.domain.TimingChartData;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimingChartBuilder
implements IChartBuilder {
    @Override
    public JFreeChart buildChart(TimingChartData _oChartDataSet, ChartStyle _style, ChartOption _option) {
        XYDataset xydataset = null;
        try {
            _oChartDataSet.fill();
            xydataset = this.makeXYDataSet(_oChartDataSet.getDataSet(), _option);
        }
        catch (CMyException e) {
            throw new ChartBuildException(I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label1", "\u6784\u9020\u56fe\u8868\u6570\u636e\u96c6\u65f6\u51fa\u9519\uff01"), e);
        }
        if (CMyString.isEmpty(_style.getXDesc()) || CMyString.isEmpty(_style.getYDesc())) {
            _style.setXYAxisDescs(I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label2", "\u65f6\u95f4"), I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label3", "\u8ba1\u6570"));
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)_style.getChartTitle(), (String)_style.getXDesc(), (String)_style.getYDesc(), (XYDataset)xydataset, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xyplot = chart.getXYPlot();
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        int nPeriodType = _option.getPeriodType();
        int nPeriodInterval = _option.getPeriodInterval();
        String timeFormat = "yyyy-MM-dd";
        switch (nPeriodType) {
            case 1: {
                dateaxis.setTickUnit(new DateTickUnit(2, 7));
                timeFormat = "yy-MM-dd";
                break;
            }
            case 2: {
                dateaxis.setTickUnit(new DateTickUnit(1, nPeriodInterval));
                timeFormat = "yyyy-MM";
                break;
            }
            case 3: {
                dateaxis.setTickUnit(new DateTickUnit(0, nPeriodInterval));
                timeFormat = "yyyy";
                break;
            }
            default: {
                dateaxis.setTickUnit(new DateTickUnit(2, nPeriodInterval));
                timeFormat = "yy-MM-dd";
            }
        }
        dateaxis.setAutoTickUnitSelection(true);
        dateaxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(timeFormat));
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    public XYDataset makeXYDataSet(Object _dataset, ChartOption _option) throws CMyException {
        Map hDataset = null;
        if (_dataset == null || !(_dataset instanceof Map)) {
            return null;
        }
        hDataset = (Map)_dataset;
        TimeSeriesCollection result = new TimeSeriesCollection();
        Map hFlagedData = (Map)hDataset.get("values");
        if (hFlagedData == null || hFlagedData.isEmpty()) {
            return result;
        }
        hFlagedData = this.rearrageDataSet(hFlagedData, _option.getPeriodType(), _option.getPeriodInterval());
        Iterator flagedDatas = hFlagedData.entrySet().iterator();
        String sCurrStageField = _option.getCurrStageField();
        while (flagedDatas.hasNext()) {
            Map.Entry flagedData = flagedDatas.next();
            String sSeriesName = (String)flagedData.getKey();
            sSeriesName = TimingChartData.IS_DEBUG ? sSeriesName : this.getUserNameById((String)flagedData.getKey());
            ArrayList arItems = (ArrayList)flagedData.getValue();
            if (sSeriesName == null || arItems == null) continue;
            TimeSeries series = this.makeTimeSeries(sSeriesName);
            for (int nItemIndex = 0; nItemIndex < arItems.size(); ++nItemIndex) {
                StatDataItem item = (StatDataItem)arItems.get(nItemIndex);
                this.addTimeSeriesUniteData(series, item.getStatTimeAsString(), item.getData(sCurrStageField));
            }
            result.addSeries(series);
        }
        return result;
    }

    private Map rearrageDataSet(Map _raw, int _nPtype, int _nPint) {
        if (_nPtype == 0 && _nPint == 1) {
            return _raw;
        }
        Map result = _raw;
        return result;
    }

    private String getUserNameById(String _sUserId) {
        String result = null;
        try {
            User user = User.findById(Integer.parseInt(_sUserId));
            result = user.getName();
        }
        catch (Exception ex) {
            result = I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label4", "\u7528\u6237[ID=") + _sUserId + "]";
        }
        return result;
    }

    private TimeSeries makeTimeSeries(String _sSeriesDesc) {
        return new TimeSeries(_sSeriesDesc, FixedMillisecond.class);
    }

    private void addTimeSeriesUniteData(TimeSeries _series, String _sDateTime, int count) throws CMyException {
        CMyDateTime date = new CMyDateTime();
        date.setDateTimeWithString(_sDateTime, ChartOption.DEF_DATE_FORMAT);
        _series.add((RegularTimePeriod)new FixedMillisecond(date.getDateTime()), (double)count);
    }
}

