/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FilterXMLMaker {
    private List m_arFiles = new ArrayList();

    public List getRelateFiles() {
        return this.m_arFiles;
    }

    public String parseToXML(Filter _filter) throws WCMException {
        Element root = DocumentHelper.createElement((String)"Filter");
        root.addAttribute("name", _filter.getFilterName());
        root.addAttribute("viewName", _filter.getViewName());
        root.addAttribute("disabledoptions", _filter.getPropertyAsString("disabledoptions"));
        WCMFilter filterForOptionGroups = new WCMFilter("", "FILTERID=?", "FOrder");
        filterForOptionGroups.addSearchValues(_filter.getId());
        FilterOptionGroups groups = FilterOptionGroups.openWCMObjs(null, filterForOptionGroups);
        int nStepSize = groups.size();
        for (int nGroupIndex = 0; nGroupIndex < nStepSize; ++nGroupIndex) {
            FilterOptionGroup group = (FilterOptionGroup)groups.getAt(nGroupIndex);
            Element elGroup = this.makeXMLElement(group);
            root.add(elGroup);
        }
        return root.asXML();
    }

    private Element makeXMLElement(FilterOptionGroup _oOptionGroup) throws WCMException {
        Element elOptionGroup = DocumentHelper.createElement((String)"optiongroup");
        elOptionGroup.addAttribute("id", String.valueOf(_oOptionGroup.getId()));
        elOptionGroup.addAttribute("name", _oOptionGroup.getOptionGroupName());
        elOptionGroup.addAttribute("minValue", _oOptionGroup.getPropertyAsString("minValue"));
        elOptionGroup.addAttribute("max_Value", _oOptionGroup.getPropertyAsString("max_Value"));
        elOptionGroup.addAttribute("columnCount", _oOptionGroup.getPropertyAsString("columnCount"));
        elOptionGroup.addAttribute("optGroupType", _oOptionGroup.getPropertyAsString("OPTGROUPTYPE"));
        elOptionGroup.addAttribute("inputName", _oOptionGroup.getOptionGroupDesc());
        WCMFilter filterForOptions = new WCMFilter("", "GROUPID=?", "FOrder");
        filterForOptions.addSearchValues(_oOptionGroup.getId());
        FilterOptions oFilterOptions = FilterOptions.openWCMObjs(null, filterForOptions);
        int nOptionSize = oFilterOptions.size();
        for (int nOptionIndex = 0; nOptionIndex < nOptionSize; ++nOptionIndex) {
            FilterOption oOption = (FilterOption)oFilterOptions.getAt(nOptionIndex);
            Element elOption = this.makeXMLElement(oOption);
            elOptionGroup.add(elOption);
        }
        return elOptionGroup;
    }

    private Element makeXMLElement(FilterOption _option) throws WCMException {
        String sThirdPicFile;
        String sSecondPicFile;
        Element elOption = DocumentHelper.createElement((String)"option");
        String sFirstPicFile = _option.getFirstPic();
        if (!CMyString.isEmpty(sFirstPicFile)) {
            this.m_arFiles.add(sFirstPicFile);
        }
        if (!CMyString.isEmpty(sSecondPicFile = _option.getSecondPic())) {
            this.m_arFiles.add(sSecondPicFile);
        }
        if (!CMyString.isEmpty(sThirdPicFile = _option.getThirdPic())) {
            this.m_arFiles.add(sThirdPicFile);
        }
        elOption.addAttribute("id", String.valueOf(_option.getId()));
        elOption.addAttribute("seq", String.valueOf(_option.getOrder()));
        elOption.addAttribute("name", _option.getOptionName());
        elOption.addAttribute("uirelation", _option.getNotAllowedSelectOptions());
        elOption.addAttribute("pic1", sFirstPicFile);
        elOption.addAttribute("pic2", sSecondPicFile);
        elOption.addAttribute("pic3", sThirdPicFile);
        elOption.addAttribute("query", _option.getSearchCondition());
        return elOption;
    }
}

