/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Step;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class OptionGroup
extends CMSObj {
    public static final int OBJ_TYPE = 266112697;
    public static final String DB_TABLE_NAME = "XWCMOPTIONGROUP";
    public static final String DB_ID_NAME = "OPTIONGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 266112697;
    }

    public String getOptionGroupName() {
        return this.getPropertyAsString("OPTIONGROUPNAME");
    }

    public boolean setOptionGroupName(String _sOptionGroupName) throws WCMException {
        return this.setProperty("OPTIONGROUPNAME", _sOptionGroupName);
    }

    public String getOptionGroupDesc() {
        return this.getPropertyAsString("OPTIONGROUPDESC");
    }

    public boolean setOptionGroupDesc(String _sOptionGroupDesc) throws WCMException {
        return this.setProperty("OPTIONGROUPDESC", _sOptionGroupDesc);
    }

    public String getLastOptions() {
        return this.getPropertyAsString("LASTOPTIONS");
    }

    public boolean setLastOptions(String _sLastOptions) throws WCMException {
        return this.setProperty("LASTOPTIONS", _sLastOptions);
    }

    public int getStepId() {
        return this.getPropertyAsInt("STEPID", 0);
    }

    public boolean setStepId(int _nStepId) throws WCMException {
        return this.setProperty("STEPID", _nStepId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int _nAOrder) throws WCMException {
        return this.setProperty("AORDER", _nAOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONGROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(OptionGroup.class, "OptionGroup.label1", "\u5c5e\u6027OptionGroupName\u6ca1\u6709\u8bbe\u7f6e(OptionGroup.isValid)"));
            }
            if (this.getProperty("STEPID") == null) {
                throw new WCMException(1106, I18NMessage.get(OptionGroup.class, "OptionGroup.label2", "\u5c5e\u6027StepId\u6ca1\u6709\u8bbe\u7f6e(OptionGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(OptionGroup.class, "OptionGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(OptionGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("AORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "AORDER>=" + nMoveBeginAt + " AND AORDER <= " + nMoveEndAt + " and STEPID=" + this.getStepId();
        String sMoveSql = "UPDATE XWCMOPTIONGROUP SET AORDER = AORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(AORDER) from XWCMOPTIONGROUP where STEPID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMOPTIONGROUP where STEPID=?", new int[]{this.getStepId()});
    }

    public static final OptionGroup findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (OptionGroup)BaseObj.findById(OptionGroup.class, _nId);
    }

    public static final OptionGroup createNewInstance() throws WCMException {
        return (OptionGroup)BaseObj.createNewInstance(OptionGroup.class);
    }

    public static final OptionGroup findByKey(Object _oKey) throws WCMException {
        return (OptionGroup)BaseObj.findByKey(OptionGroup.class, _oKey);
    }

    public Step getStep() throws WCMException {
        return Step.findById(this.getStepId());
    }
}

