/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishTagContext {
    private static final Logger s_logger = Logger.getLogger(PublishTagContext.class);
    private PublishPageContext m_pageContext;
    private IPublishElement m_upperHost;
    private PublishTagContext m_parent;
    private Map m_extraAttributes;
    private IPublishFolder m_upperFolder = null;
    private TagItem m_oCurrTagItem = null;
    private HashMap m_mVariableArgument = null;
    private String m_sPrefixOfArgument = null;
    private ITagParser4List m_oTagParser4List;
    private int m_iSequenceNumber;
    public static final String ATTRNAME_CURR_NESTTAGITEM = "CURR.NEST.TEMPNAM";
    private TagItem m_oPreNestTemplateTagItem = null;
    private TagItem m_oCurrNestTemplateTagItem = null;

    public PublishTagContext(IPublishElement _upperHost, Map _extraAttributes, PublishPageContext _pageContext) {
        this(_upperHost, _extraAttributes, null, _pageContext);
    }

    public PublishTagContext(IPublishElement _upperHost, Map _extraAttributes, PublishTagContext _parent) {
        this(_upperHost, _extraAttributes, _parent, _parent.getPageContext());
    }

    private PublishTagContext(IPublishElement _upperHost, Map _displayStyles, PublishTagContext _parent, PublishPageContext _pageContext) {
        this.m_extraAttributes = _displayStyles;
        this.m_pageContext = _pageContext;
        this.m_parent = _parent;
        this.setUpperHost(_upperHost);
    }

    public PublishTagContext(PublishPageContext _pageContext) {
        this.m_oCurrTagItem = null;
        this.m_parent = null;
        this.m_pageContext = _pageContext;
        this.m_upperHost = _pageContext.getPageElement();
        try {
            this.m_mVariableArgument = this.m_upperHost.getTemplateArguments();
        }
        catch (Exception e) {
            s_logger.error((Object)I18NMessage.get(PublishTagContext.class, "PublishTagContext.label1", "\u83b7\u53d6\u53d1\u5e03\u5bf9\u8c61\u7684\u6a21\u677f\u53c2\u6570\u503c\u5217\u8868\u5931\u8d25"), (Throwable)e);
        }
        this.m_sPrefixOfArgument = null;
    }

    public PublishTagContext(PublishTagContext _parent, TagItem _tagItem) {
        this.init(_parent, _tagItem, null);
    }

    public PublishTagContext(PublishTagContext _parent, TagItem _tagItem, ITagParser4List _tagParser4List) {
        this.init(_parent, _tagItem, null);
        this.m_oTagParser4List = _tagParser4List;
    }

    public PublishTagContext(PublishTagContext _parent, TagItem _tagItem, IPublishElement _upperHost) {
        this.init(_parent, _tagItem, _upperHost);
    }

    private void init(PublishTagContext _parent, TagItem _tagItem, IPublishElement _upperHost) {
        this.m_parent = _parent;
        this.m_oCurrTagItem = _tagItem;
        this.m_upperHost = _upperHost;
        this.m_pageContext = _parent.getPageContext();
        this.m_oTagParser4List = _parent.getTagParser4List();
        this.m_mVariableArgument = _parent.m_mVariableArgument;
        this.m_sPrefixOfArgument = _parent.m_sPrefixOfArgument;
        this.m_oCurrNestTemplateTagItem = _parent.m_oCurrNestTemplateTagItem;
        this.m_oPreNestTemplateTagItem = _parent.m_oCurrNestTemplateTagItem;
    }

    public ITagParser4List getTagParser4List() {
        return this.m_oTagParser4List;
    }

    public IPublishElement getUpperHost() {
        if (this.m_upperHost == null && this.m_oTagParser4List != null) {
            try {
                this.m_oTagParser4List.substantiateContext(this);
            }
            catch (Exception e) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label2", "\u4f7f\u7528[") + this.m_oTagParser4List + I18NMessage.get(PublishTagContext.class, "PublishTagContext.label3", "]\u5b9e\u4f53\u5316[") + this + I18NMessage.get(PublishTagContext.class, "PublishTagContext.label4", "]\u65f6\u53d1\u751f\u9519\u8bef")), (Throwable)e);
            }
        }
        return this.m_upperHost;
    }

    public void setUpperHost(IPublishElement _upperHost) {
        this.m_upperHost = _upperHost;
    }

    public PublishTagContext getParent() {
        return this.m_parent;
    }

    public void setParent(PublishTagContext _parent) {
        this.m_parent = _parent;
    }

    public PublishPageContext getPageContext() {
        return this.m_pageContext;
    }

    public Map getExtraAttributes() {
        return this.m_extraAttributes;
    }

    public String getExtraAttribute(String _sName) {
        if (this.m_extraAttributes == null) {
            return null;
        }
        return (String)this.m_extraAttributes.get(_sName.toUpperCase());
    }

    public boolean getBooleanExtraAttribute(String _sName, boolean _bDefault) {
        String sValue = this.getExtraAttribute(_sName);
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }

    public void setExtraAttributes(Map _displayStyles) {
        this.m_extraAttributes = _displayStyles;
    }

    public boolean isPreview() {
        return this.m_pageContext.isPreview();
    }

    public IPublishFolder getPageFolder() {
        return this.m_pageContext.getPageFolder();
    }

    public IPublishElement getPageElement() {
        return this.m_pageContext.getPageElement();
    }

    public String getPageHttpPath() throws WCMException {
        return this.m_pageContext.getPageHttpPath();
    }

    public IPublishFolder getRoot() throws WCMException {
        return this.m_pageContext.getRoot();
    }

    public void addWarning(String _sObjName, int _nObjId, String _sDesc) throws WCMException {
        this.m_pageContext.addWarning(_sObjName, _nObjId, _sDesc);
    }

    public void addWarning(String _sDesc) throws WCMException {
        this.m_pageContext.addWarning(_sDesc);
    }

    public PublishPathCompass getPathCompass() {
        return this.m_pageContext.getPathCompass();
    }

    public FileDistributeShip getFileDistributeShip() {
        return this.m_pageContext.getFileDistributeShip();
    }

    public IPublishFolder getUpperFolder() {
        if (this.m_upperFolder == null) {
            this.m_upperFolder = this.findNearestUpperFolder();
        }
        return this.m_upperFolder;
    }

    public void setUpperFolder(IPublishFolder folder) {
        this.m_upperFolder = folder;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label5", "\u5207\u6362\u53d1\u5e03\u5bf9\u8c61\u7684\u76ee\u5f55\u5230:") + folder));
        }
    }

    private IPublishFolder findNearestUpperFolder() {
        PublishTagContext parent = this;
        do {
            IPublishFolder folder;
            if ((folder = parent.m_upperFolder) == null) continue;
            return folder;
        } while ((parent = parent.getParent()) != null);
        return this.m_pageContext.getPageFolder();
    }

    public void log2Monitor(String msg) {
        if (this.m_pageContext != null) {
            this.m_pageContext.log2Monitor(msg);
        }
    }

    public TagItem getTagItem() {
        return this.m_oCurrTagItem;
    }

    public void setTagItem(TagItem _tagItem) {
        this.m_oCurrTagItem = _tagItem;
    }

    public HashMap getAttributes() {
        this.assertCurrTagItemNotNull();
        return this.m_oCurrTagItem.getAttributes();
    }

    public String getAttribute(String _sName) {
        this.assertCurrTagItemNotNull();
        String sValue = this.m_oCurrTagItem.getAttribute(_sName);
        if (sValue == null) {
            return null;
        }
        if (!TagItem.isVariableParameter(sValue)) {
            try {
                return this.parsePageVariables(sValue);
            }
            catch (Exception e) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label6", "\u518d\u6b21\u89e3\u6790\u7f6e\u6807\u5c5e\u6027\u5931\u8d25\uff01[Value=") + sValue + "]"), (Throwable)e);
                return null;
            }
        }
        TemplateParameter tp = this.m_oCurrTagItem.getVariableParameter(_sName);
        if (tp == null) {
            return sValue;
        }
        String sVariableName = tp.getParameterName();
        if (sVariableName.charAt(0) == '@') {
            try {
                return this.getTagObjAttribute(this, sVariableName.substring(1));
            }
            catch (Exception e) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label7", "\u83b7\u53d6\u7f6e\u6807\u53d8\u91cf\u7684\u503c\u5931\u8d25\uff01[Name=") + sVariableName + "]"), (Throwable)e);
                return null;
            }
        }
        if (this.m_mVariableArgument == null) {
            if (this.m_oCurrNestTemplateTagItem == null) {
                return tp.getParameterDefaultValue();
            }
            return this.m_oCurrNestTemplateTagItem.getAttribute(sVariableName);
        }
        String sVariableKey = TemplateArgument.makeCacheKey(this.m_sPrefixOfArgument, sVariableName);
        String sVariableValue = (String)this.m_mVariableArgument.get(sVariableKey);
        if (sVariableValue != null) {
            return sVariableValue;
        }
        if (this.m_oCurrNestTemplateTagItem != null && (sVariableValue = this.m_oCurrNestTemplateTagItem.getAttribute(sVariableName)) != null) {
            return sVariableValue;
        }
        return tp.getParameterDefaultValue();
    }

    private final void assertCurrTagItemNotNull() {
        if (this.m_oCurrTagItem == null) {
            throw new IllegalStateException("no tag on TagContext");
        }
    }

    public String getAttributeTrim(String _sName) {
        String sValue = this.getAttribute(_sName);
        return sValue == null ? null : sValue.trim();
    }

    public int getAttribute(String _sName, int _nDefault) throws WCMException {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, "Value [" + sValue + "] of attribute [" + _sName + "] is not integer!", ex);
        }
    }

    public boolean getAttribute(String _sName, boolean _bDefault) {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true") || sValue.equals("1");
    }

    public String getPrefixOfArgument() {
        return this.m_sPrefixOfArgument;
    }

    public void setPrefixOfArgument(String prefixOfArgument) {
        if (prefixOfArgument != null && prefixOfArgument.length() <= 0) {
            prefixOfArgument = null;
        }
        if (this.m_sPrefixOfArgument != null && prefixOfArgument != null) {
            return;
        }
        this.m_sPrefixOfArgument = prefixOfArgument;
    }

    public int getSequenceNumber() throws WCMException {
        if (this.m_oTagParser4List == null) {
            throw new WCMException("");
        }
        return this.m_iSequenceNumber;
    }

    public void setSequenceNumber(int no) {
        this.m_iSequenceNumber = no;
    }

    public void saveNestTemplateContext() {
        if (!this.m_oCurrTagItem.getName().equalsIgnoreCase("TRS_TEMPLATE")) {
            return;
        }
        this.setPrefixOfArgument(this.m_oCurrTagItem.getAttribute("IDENTITY"));
        this.m_oPreNestTemplateTagItem = this.m_oCurrNestTemplateTagItem;
        this.m_oCurrNestTemplateTagItem = this.m_oCurrTagItem;
    }

    public void clearNestTemplateeContext() {
        this.m_oCurrNestTemplateTagItem = this.m_oPreNestTemplateTagItem;
        this.setPrefixOfArgument(null);
    }

    private String getTagObjAttribute(PublishTagContext _context, String _attribute) throws WCMException {
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getUpperHost().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PAGE".equalsIgnoreCase(sDomainName)) {
            return this.getPageObjAttribute(_context.getPageContext(), sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getUpperHost();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label8", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PAGE,SITE,PARENT]"));
    }

    private String getPageObjAttribute(PublishPageContext _context, String _attribute) throws WCMException {
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _context.getPageElement().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("SITE".equalsIgnoreCase(sDomainName)) {
            CMSObj obj = _context.getRoot().getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishElement element = _context.getPageElement();
            IPublishFolder folder = null;
            folder = element instanceof IPublishFolder ? ((IPublishFolder)element).getParent() : element.getFolder();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label9", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[SITE,PARENT]"));
    }

    private String getFolderObjAttribute(IPublishFolder _folder, String _attribute) throws WCMException {
        if (_folder == null) {
            throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label10", "\u9519\u8bef\u7684\u4f7f\u7528\u573a\u666f\uff0c\u5df2\u7ecf\u4e0d\u5b58\u5728\u7236\u76ee\u5f55"));
        }
        String sDomainName = null;
        String sAttribName = null;
        int iSplit = _attribute.indexOf(46);
        if (iSplit >= 0) {
            sDomainName = _attribute.substring(0, iSplit);
            sAttribName = _attribute.substring(iSplit + 1);
        } else {
            sAttribName = _attribute;
        }
        if (sDomainName == null || sDomainName.length() <= 0) {
            CMSObj obj = _folder.getSubstance();
            return obj.getPropertyAsString(sAttribName);
        }
        if ("PARENT".equalsIgnoreCase(sDomainName)) {
            IPublishFolder folder = _folder.getParent();
            return this.getFolderObjAttribute(folder, sAttribName);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label11", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PARENT]"));
    }

    public String parsePageVariables(String _sContent) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        char[] chrArray = _sContent.toCharArray();
        int nLength = chrArray.length;
        int nPos = 0;
        buffResult = new StringBuffer();
        while (nPos < chrArray.length) {
            char aChar;
            if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{' && chrArray[nPos + 1] == '@') {
                StringBuffer buffVarName = new StringBuffer(16);
                ++nPos;
                ++nPos;
                int iCount = 0;
                boolean zFound = false;
                while (iCount++ < 20 && nPos < nLength) {
                    if ((aChar = chrArray[nPos++]) == '}') {
                        zFound = true;
                        break;
                    }
                    buffVarName.append(aChar);
                }
                if (zFound) {
                    String sKey = buffVarName.toString().toUpperCase();
                    String sVal = this.getTagObjAttribute(this, sKey);
                    if (sVal != null) {
                        buffResult.append(sVal);
                        continue;
                    }
                    buffResult.append("${@").append(buffVarName).append('}');
                    continue;
                }
                buffResult.append("${@").append(buffVarName);
                continue;
            }
            buffResult.append(aChar);
        }
        return buffResult.toString();
    }
}

