/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.bookmark.BookMark;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class BookMarks
extends CMSBaseObjs {
    public BookMarks(User _currUser) {
        super(_currUser);
    }

    public BookMarks(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    @Override
    protected String getDbTableName() {
        return "WCMBOOKMARK";
    }

    @Override
    public String getIdFieldName() {
        return "MARKID";
    }

    @Override
    public Class getElementClass() {
        return BookMark.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new BookMarks(this.currUser);
    }

    public BookMark getByName(String _name, int _kind) {
        BookMark aBookMark = null;
        int nCount = this.size();
        for (int i = 0; i < nCount; ++i) {
            aBookMark = (BookMark)this.getAt(i);
            if (aBookMark == null || aBookMark.getName().compareTo(_name) != 0 || aBookMark.getKindId() != _kind) continue;
            return aBookMark;
        }
        this.currIndex = -3;
        return null;
    }

    public static final BookMarks findByIds(User _currUser, String _sIds) throws WCMException {
        if (_sIds == null || _sIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(BookMarks.class, "BookMarks.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        return (BookMarks)CMSBaseObjs.findWCMObjsByIds(_currUser, BookMarks.class, _sIds);
    }

    public static final BookMarks openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        return (BookMarks)CMSBaseObjs.openWCMObjs(_currUser, BookMarks.class, _filter);
    }

    public static BookMarks createNewInstance(User _currUser) throws WCMException {
        return (BookMarks)CMSBaseObjs.createInstance(_currUser, BookMarks.class);
    }
}

