/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.config;

import com.trs.cms.process.config.ActionHandlerConfig;
import com.trs.cms.process.config.ConditionHandlerConfig;
import com.trs.cms.process.config.FlowContentField;
import com.trs.cms.process.config.FlowContentTypeConfig;
import com.trs.cms.process.config.OperatorConfig;
import com.trs.cms.process.config.ParamConfig;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.config.ValueConfig;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FlowConfigServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(FlowConfigServer.class);
    private FlowContentTypeConfig[] m_pContentTypeConfigs = null;
    private ConditionHandlerConfig[] m_pConditionHandlerConfigs = null;
    private ActionHandlerConfig[] m_pActionHandlerConfigs = null;
    private ToUsersCreatorConfig[] m_pToUsersCreatorConfigs = null;
    private Element m_oConfigFileRootElement = null;

    @Override
    protected void doShutdown() {
        this.m_pContentTypeConfigs = null;
        this.m_pConditionHandlerConfigs = null;
        this.m_pActionHandlerConfigs = null;
        this.m_pToUsersCreatorConfigs = null;
    }

    @Override
    protected boolean doStart() throws WCMException {
        FileService fileWorkflowCustomConfigDir;
        FileStore[] fileWorkflowCustomConfigs;
        if (this.m_pContentTypeConfigs != null) {
            return true;
        }
        this.m_pContentTypeConfigs = new FlowContentTypeConfig[0];
        this.m_pConditionHandlerConfigs = new ConditionHandlerConfig[0];
        this.m_pActionHandlerConfigs = new ActionHandlerConfig[0];
        this.m_pToUsersCreatorConfigs = new ToUsersCreatorConfig[0];
        this.m_oConfigFileRootElement = DocumentHelper.createElement((String)"workflow-config");
        Iterator itConfigFiles = WCMDiscoveryFactory.getDiscovery().getResources("workflow_config.xml");
        while (itConfigFiles.hasNext()) {
            URL urlConfigFile = (URL)itConfigFiles.next();
            this.loadConfig(urlConfigFile);
        }
        this.createWorkflowCustomConfigDirIFNeed();
        URL urlWorkflowCustomConfigDir = this.getClass().getClassLoader().getResource("workflow");
        if (urlWorkflowCustomConfigDir != null && (fileWorkflowCustomConfigs = (fileWorkflowCustomConfigDir = new FileService(urlWorkflowCustomConfigDir.getFile())).listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                String sName = pathname.getName().toLowerCase();
                if (sName.equals("workflow_config.xml")) {
                    return false;
                }
                return sName.endsWith(".xml");
            }
        })) != null && fileWorkflowCustomConfigs.length > 0) {
            for (int i = 0; i < fileWorkflowCustomConfigs.length; ++i) {
                FileStore fileWorkflowCustomConfig = fileWorkflowCustomConfigs[i];
                URL urlWorkflowCustomConfig = null;
                try {
                    urlWorkflowCustomConfig = fileWorkflowCustomConfig.toURL();
                }
                catch (Exception e) {
                    logger.error((Object)("e" + fileWorkflowCustomConfig.getName() + "] a malformed URL has occurred"), (Throwable)e);
                    continue;
                }
                if (urlWorkflowCustomConfig == null) continue;
                this.loadConfig(urlWorkflowCustomConfig);
            }
        }
        return true;
    }

    private void createWorkflowCustomConfigDirIFNeed() {
        String sConfigRootFilePath = WCMDiscoveryFactory.getConfigRootFilePath().getPath();
        String sWorkflowCustomConfigDir = CMyString.setStrEndWith(sConfigRootFilePath, File.separatorChar) + "workflow";
        FileService fileWorkflowCustomConfigDir = new FileService(sWorkflowCustomConfigDir);
        if (!fileWorkflowCustomConfigDir.exists()) {
            fileWorkflowCustomConfigDir.mkdir();
        }
    }

    private void loadConfig(URL fileWorkflowCustomConfig) throws WCMException {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(fileWorkflowCustomConfig);
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(FlowConfigServer.class, "FlowConfigServer.label1", "\u914d\u7f6e\u6587\u4ef6[") + fileWorkflowCustomConfig + I18NMessage.get(FlowConfigServer.class, "FlowConfigServer.label2", "]\u683c\u5f0f\u6709\u95ee\u9898\uff01\u8bfb\u53d6\u9519\u8bef\uff01")), (Throwable)e);
        }
        if (document == null) {
            return;
        }
        Element elRoot = document.getRootElement();
        this.loadContentTypesConfig(elRoot);
        this.loadConditionHandlerConfigs(elRoot);
        this.loadActionHandlerConfigs(elRoot);
        this.loadToCreatorConfigs(elRoot, "tousers-creator");
        this.loadToCreatorConfigs(elRoot, "initvalue-creator");
    }

    public ConditionHandlerConfig[] getConditionHandlerConfigs() {
        return this.m_pConditionHandlerConfigs;
    }

    public ActionHandlerConfig[] getActionHandlerConfigs() {
        return this.m_pActionHandlerConfigs;
    }

    public ToUsersCreatorConfig[] getToUsersCreatorConfigs() {
        return this.m_pToUsersCreatorConfigs;
    }

    public ToUsersCreatorConfig getToUsersCreatorConfigByName(String _sName) {
        return this.getToUsersCreatorConfigByName(_sName, null);
    }

    public ToUsersCreatorConfig getToUsersCreatorConfigByName(String _sName, String _sParams) {
        if (this.m_pToUsersCreatorConfigs == null) {
            this.startup();
        }
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_pToUsersCreatorConfigs.length; ++i) {
            ToUsersCreatorConfig config = this.m_pToUsersCreatorConfigs[i];
            if (!config.getName().equalsIgnoreCase(_sName)) continue;
            if (_sParams != null) {
                config.setAttributes(_sParams);
            }
            return config;
        }
        return null;
    }

    public FlowContentTypeConfig[] getContentTypeConfigs() {
        if (this.m_pContentTypeConfigs == null) {
            this.startup();
        }
        return this.m_pContentTypeConfigs;
    }

    public FlowContentTypeConfig findContentTypeConfig(int _nContentType) {
        if (this.m_pContentTypeConfigs == null) {
            this.startup();
        }
        if (this.m_pContentTypeConfigs == null) {
            return null;
        }
        for (int i = 0; i < this.m_pContentTypeConfigs.length; ++i) {
            if (this.m_pContentTypeConfigs[i].getContentType() != _nContentType) continue;
            return this.m_pContentTypeConfigs[i];
        }
        return null;
    }

    public void setContentTypeConfigs(FlowContentTypeConfig[] contentTypeConfigs) {
        this.m_pContentTypeConfigs = contentTypeConfigs;
    }

    public void addContentTypeConfig(FlowContentTypeConfig contentTypeConfig) {
        int nOldLength = this.m_pContentTypeConfigs.length;
        FlowContentTypeConfig[] pTemp = new FlowContentTypeConfig[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(this.m_pContentTypeConfigs, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = contentTypeConfig;
        this.m_pContentTypeConfigs = pTemp;
    }

    private void loadContentTypesConfig(Element _elRoot) throws WCMException {
        Element elConfigs = _elRoot.element("content-types");
        if (elConfigs == null) {
            return;
        }
        Iterator itConfigs = elConfigs.elementIterator("content-type");
        if (itConfigs == null) {
            return;
        }
        while (itConfigs.hasNext()) {
            Element elHost = (Element)itConfigs.next();
            FlowContentTypeConfig contentTypeConfig = new FlowContentTypeConfig();
            contentTypeConfig.setName(elHost.attributeValue("name"));
            contentTypeConfig.setDesc(elHost.attributeValue("desc"));
            contentTypeConfig.setDBTableName(elHost.attributeValue("table-name"));
            contentTypeConfig.setClassName(elHost.attributeValue("class-name"));
            Iterator itFields = elHost.elementIterator("field");
            while (itFields != null && itFields.hasNext()) {
                Element elField = (Element)itFields.next();
                FlowContentField field = new FlowContentField(contentTypeConfig);
                field.setName(elField.attributeValue("name"));
                field.setDBName(elField.attributeValue("db-name"));
                contentTypeConfig.addContentField(field);
            }
            this.addContentTypeConfig(contentTypeConfig);
        }
        this.addConfigs(elConfigs);
    }

    private void addConfigs(Element _elConfigs) {
        Element elTemp = this.m_oConfigFileRootElement.element(_elConfigs.getName());
        if (elTemp == null) {
            this.m_oConfigFileRootElement.add(DocumentHelper.createText((String)"\n    "));
            this.m_oConfigFileRootElement.add((Element)_elConfigs.clone());
            this.m_oConfigFileRootElement.add(DocumentHelper.createText((String)"\n"));
            return;
        }
        int nNodeCount = _elConfigs.nodeCount();
        for (int i = 0; i < nNodeCount; ++i) {
            elTemp.add((Node)_elConfigs.node(i).clone());
        }
    }

    private void loadConditionHandlerConfigs(Element _elRoot) throws WCMException {
        Element elHosts = _elRoot.element("condition-handlers");
        if (elHosts == null) {
            return;
        }
        Iterator itHosts = elHosts.elementIterator("handler");
        if (itHosts == null) {
            return;
        }
        while (itHosts.hasNext()) {
            Element elHandler = (Element)itHosts.next();
            ConditionHandlerConfig conditionHandlerConfig = new ConditionHandlerConfig();
            conditionHandlerConfig.setName(elHandler.attributeValue("name"));
            conditionHandlerConfig.setDesc(elHandler.attributeValue("desc"));
            conditionHandlerConfig.setClassName(elHandler.attributeValue("class-name"));
            this.loadParams(elHandler, conditionHandlerConfig);
            this.addConditionHandlerConfig(conditionHandlerConfig);
        }
        this.addConfigs(elHosts);
    }

    private void loadParams(Element elHandler, ConditionHandlerConfig conditionHandlerConfig) {
        Iterator itFields = elHandler.elementIterator("param");
        while (itFields.hasNext()) {
            Element elParam = (Element)itFields.next();
            ParamConfig param = new ParamConfig();
            param.setName(elParam.attributeValue("name"));
            param.setDesc(elParam.attributeValue("desc"));
            this.loadOperators(elParam, param);
            conditionHandlerConfig.addParamConfig(param);
        }
    }

    private void loadParams(Element elHandler, ActionHandlerConfig actionHandlerConfig) {
        Iterator itFields = elHandler.elementIterator("param");
        while (itFields.hasNext()) {
            Element elParam = (Element)itFields.next();
            ParamConfig paramConfig = new ParamConfig();
            paramConfig.setName(elParam.attributeValue("name"));
            paramConfig.setDesc(elParam.attributeValue("desc"));
            this.loadValues(elParam, paramConfig);
            this.loadDefaultValue(elParam, paramConfig);
            actionHandlerConfig.addParamConfig(paramConfig);
        }
    }

    private void loadDefaultValue(Element _elParam, ParamConfig _paramConfig) {
        Element elDefaultValue;
        String sDefaultValue = _elParam.attributeValue("default-value");
        if (sDefaultValue == null && (elDefaultValue = _elParam.element("default-value")) != null) {
            sDefaultValue = elDefaultValue.getTextTrim();
        }
        if (sDefaultValue != null) {
            _paramConfig.setDefaultValue(sDefaultValue);
        }
    }

    private void loadOperators(Element _elParam, ParamConfig _paramConfig) {
        Element elOperators = _elParam.element("operators");
        if (elOperators == null) {
            return;
        }
        Iterator itOperators = elOperators.elementIterator("operator");
        while (itOperators.hasNext()) {
            Element elOperator = (Element)itOperators.next();
            OperatorConfig operator = new OperatorConfig();
            operator.setName(elOperator.attributeValue("name"));
            operator.setValue(elOperator.attributeValue("value"));
            _paramConfig.addOperatorConfig(operator);
        }
    }

    private void loadValues(Element _elParam, ParamConfig _paramConfig) {
        Element elValues = _elParam.element("values");
        if (elValues == null) {
            return;
        }
        Iterator itValues = elValues.elementIterator("value");
        while (itValues.hasNext()) {
            Element elValue = (Element)itValues.next();
            ValueConfig value = new ValueConfig();
            value.setName(elValue.attributeValue("name"));
            value.setDesc(elValue.attributeValue("value"));
            _paramConfig.addValueConfig(value);
        }
    }

    private void addConditionHandlerConfig(ConditionHandlerConfig ConditionHandlerConfig2) {
        int nOldLength = this.m_pConditionHandlerConfigs.length;
        ConditionHandlerConfig[] pTemp = new ConditionHandlerConfig[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(this.m_pConditionHandlerConfigs, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = ConditionHandlerConfig2;
        this.m_pConditionHandlerConfigs = pTemp;
    }

    private void loadActionHandlerConfigs(Element _elRoot) throws WCMException {
        Element elHosts = _elRoot.element("action-handlers");
        if (elHosts == null) {
            return;
        }
        Iterator itHosts = elHosts.elementIterator("handler");
        if (itHosts == null) {
            return;
        }
        while (itHosts.hasNext()) {
            Element elHandler = (Element)itHosts.next();
            ActionHandlerConfig actionHandlerConfig = new ActionHandlerConfig();
            actionHandlerConfig.setName(elHandler.attributeValue("name"));
            actionHandlerConfig.setDesc(elHandler.attributeValue("desc"));
            actionHandlerConfig.setClassName(elHandler.attributeValue("class-name"));
            this.loadParams(elHandler, actionHandlerConfig);
            this.addActionHandlerConfig(actionHandlerConfig);
        }
        this.addConfigs(elHosts);
    }

    private void addActionHandlerConfig(ActionHandlerConfig ActionHandlerConfig2) {
        int nOldLength = this.m_pActionHandlerConfigs.length;
        ActionHandlerConfig[] pTemp = new ActionHandlerConfig[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(this.m_pActionHandlerConfigs, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = ActionHandlerConfig2;
        this.m_pActionHandlerConfigs = pTemp;
    }

    public Element getConfigFileRootElement() {
        return this.m_oConfigFileRootElement;
    }

    public String getConfigFileContent() {
        if (this.m_oConfigFileRootElement == null) {
            this.startup();
        }
        return this.m_oConfigFileRootElement.asXML();
    }

    private void loadToCreatorConfigs(Element _elRoot, String _sTagName) throws WCMException {
        Element elCreators = _elRoot.element(_sTagName + "s");
        if (elCreators == null) {
            return;
        }
        Iterator itCreators = elCreators.elementIterator(_sTagName);
        if (itCreators == null) {
            return;
        }
        while (itCreators.hasNext()) {
            Element elCreator = (Element)itCreators.next();
            ToUsersCreatorConfig creatorConfig = new ToUsersCreatorConfig();
            for (int i = 0; i < elCreator.attributeCount(); ++i) {
                Attribute attr = elCreator.attribute(i);
                String sAttrName = attr.getName();
                String sValue = attr.getValue();
                if (sAttrName.equals("name")) {
                    creatorConfig.setName(sValue.trim());
                    continue;
                }
                if (sAttrName.equals("class-name")) {
                    creatorConfig.setClassName(sValue.trim());
                    continue;
                }
                creatorConfig.setAttribute(sAttrName, sValue);
            }
            this.addToUsersCreatorConfig(creatorConfig);
        }
        this.addConfigs(elCreators);
    }

    private void addToUsersCreatorConfig(ToUsersCreatorConfig ToUsersCreatorConfig2) {
        int nOldLength = this.m_pToUsersCreatorConfigs.length;
        ToUsersCreatorConfig[] pTemp = new ToUsersCreatorConfig[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(this.m_pToUsersCreatorConfigs, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = ToUsersCreatorConfig2;
        this.m_pToUsersCreatorConfigs = pTemp;
    }
}

