/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.job.BaseJob;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class UserInfoSyncUpdater
extends BaseJob {
    private static final Logger logger = Logger.getLogger(UserInfoSyncUpdater.class);
    private User m_oDeleted;
    private static int m_nWorkerId = 0;
    private static final String[] SQL_BY_NAME = new String[]{"delete from WCMEVENT where OWNER = #v", "delete from WCMCONTACT where CRUSER = #v", "delete from WCMADDRGROUP where CRUSER = #v", "delete from WCMADDRGRPMAP where CRUSER = #v", "delete from WCMTASK where CRUSER = #v", "delete from WCMBOOKMARK where CRUSER = #v", "delete from WCMMARKKIND where CRUSER = #v", "delete from WCMMARKSHARE where CRUSER = #v", "delete from WCMMSGQUEUE where exists(select MSGID from WCMMESSAGE where CRUSER = #v and WCMMESSAGE.MSGID=WCMMSGQUEUE.MSGID)", "delete from WCMMESSAGE where CRUSER = #v"};
    private static final String[] SQL_BY_ID = new String[]{"delete from  WCMUSERSETTING where USERID = #v", "delete from XWCMINDIVIDUATION where USERID = #v", "delete from WCMADDRESS where OBJTYPE=204 and OBJID = #v", "delete from WCMTASKPOOL where OBJTYPE=204 and OBJID = #v", "delete from WCMMSGQUEUE where OBJTYPE=204 and OBJID = #v"};

    protected boolean analyzeParams() {
        try {
            int nUserId = Integer.parseInt(this.getArgAsString("SenderId"));
            this.m_oDeleted = User.findById(nUserId);
            if (this.m_oDeleted == null) {
                logger.fatal((Object)("User not found,id=" + nUserId));
                return false;
            }
            String userName = this.getArgAsString("CrUser");
            ContextHelper.initContext(User.getSystem());
            User oScheduleUser = User.findByName(userName);
            if (oScheduleUser == null) {
                oScheduleUser = User.getSystem();
            }
            ContextHelper.setLoginUser(oScheduleUser);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"excute schedule publish failed", (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void execute() throws WCMException {
        Statement stmt;
        Connection conn;
        DBManager dbmanager;
        block24: {
            if (!this.analyzeParams()) {
                return;
            }
            dbmanager = DBManager.getDBManager();
            conn = null;
            stmt = null;
            try {
                String sUserName2332 = this.m_oDeleted.getName();
                int ix = sUserName2332.indexOf(36);
                if (ix == -1) {
                    logger.error((Object)("schedule sync fail:" + sUserName2332));
                    return;
                }
                sUserName2332 = sUserName2332.substring(0, ix);
                sUserName2332 = "'" + sUserName2332 + "'";
                String sUserId = String.valueOf(this.m_oDeleted.getId());
                conn = dbmanager.getConnection();
                stmt = conn.createStatement();
                String sql2222 = null;
                for (String sql2222 : SQL_BY_ID) {
                    stmt.executeUpdate(sql2222.replaceAll("#v", sUserId));
                    stmt.clearWarnings();
                }
                for (String sql2222 : SQL_BY_NAME) {
                    stmt.executeUpdate(sql2222.replaceAll("#v", sUserName2332));
                    stmt.clearWarnings();
                }
                this.clearSchedule();
                if (stmt == null) break block24;
            }
            catch (Exception ex) {
                throw new WCMException(1100, "delete user sync fail", ex);
            }
            try {
                stmt.close();
            }
            catch (Exception sUserName2332) {
                // empty catch block
            }
        }
        if (conn == null) return;
        try {
            dbmanager.freeConnection(conn);
            return;
        }
        catch (Exception sUserName2332) {
            return;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void clearSchedule() {
        try {
            Schedule schedule;
            if (m_nWorkerId == 0) {
                JobWorkerType worker = JobWorkerType.findByClassName(UserInfoSyncUpdater.class.getName());
                if (worker == null) {
                    return;
                }
                m_nWorkerId = worker.getId();
            }
            if ((schedule = Schedule.findBySender(m_nWorkerId, this.m_oDeleted)) != null) {
                schedule.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

