/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.util.ArrayList;
import org.apache.log4j.Logger;

class SQLStatementParser {
    private static final Logger LOG = Logger.getLogger(SQLStatementParser.class);
    private String statement;
    private String[] parameterNames;
    private String preparedStatement;

    public SQLStatementParser(String statement) {
        this.statement = statement;
        this.parse();
    }

    private void parse() {
        ArrayList<String> parameters = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(this.statement.length());
        int indexBegin = 0;
        int indexNext = 0;
        int index = this.statement.indexOf("${");
        while (index != -1) {
            indexNext = this.statement.indexOf("}", index + 1);
            if (indexNext == -1) break;
            String parameter = this.statement.substring(index, indexNext);
            parameters.add(parameter.substring(2, parameter.length()));
            sb.append(this.statement.substring(indexBegin, index)).append("?");
            indexBegin = indexNext + 1;
            index = this.statement.indexOf("${", indexBegin);
        }
        this.parameterNames = parameters.toArray(new String[0]);
        sb.append(this.statement.substring(indexBegin));
        this.preparedStatement = sb.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SQL transfer:" + this.statement + " => " + this.preparedStatement));
        }
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(String[] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setPreparedStatement(String preparedStatement) {
        this.preparedStatement = preparedStatement;
    }
}

