/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.CloseUtil;
import com.trs.idm.util.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class);
    private static final String ENTER = System.getProperty("line.separator");
    private static final String FILE_ENCODE_UTF8 = "UTF-8";

    public static String getFileContent(String fileName) {
        return FileUtil.getFileContent(fileName, Short.MAX_VALUE, true);
    }

    public static String getFileContent(String fileName, int maxLength, boolean readFileInfo) {
        if (fileName == null || fileName.trim().length() == 0) {
            return "fileName cannot be empty!";
        }
        File f = new File(fileName);
        if (!f.isFile()) {
            return String.valueOf(fileName) + " is not exist or is not a file!";
        }
        if (f.length() > (long)maxLength) {
            return String.valueOf(fileName) + " is larger than " + maxLength + " Byte!";
        }
        StringBuffer sb = new StringBuffer(maxLength);
        try {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
            BufferedReader br = new BufferedReader(isr);
            if (readFileInfo) {
                sb.append("LAST_MODIFIED:").append(new Timestamp(f.lastModified())).append(ENTER);
                sb.append("CONTENT:").append(ENTER);
            }
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(ENTER);
                line = br.readLine();
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            return sb.insert(0, e + ENTER + "Already read content:" + ENTER).toString();
        }
    }

    public static boolean copyTxtFile(File fSrc, File fDst) {
        if (fSrc == null || fDst == null) {
            return false;
        }
        if (!fSrc.isFile()) {
            return false;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(fSrc);
            fos = new FileOutputStream(fDst);
            InputStreamReader isr = new InputStreamReader(fis);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            br = new BufferedReader(isr, 4096);
            bw = new BufferedWriter(osw, 4096);
            String line = br.readLine();
            while (line != null) {
                bw.write(line);
                bw.newLine();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("fail on copying! fSrc=" + fSrc + ", fDst=" + fDst), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeWriter(bw);
                CloseUtil.closeOutputStream(fos);
                CloseUtil.closeReader(br);
                CloseUtil.closeInputStream(fis);
                throw throwable;
            }
            CloseUtil.closeWriter(bw);
            CloseUtil.closeOutputStream(fos);
            CloseUtil.closeReader(br);
            CloseUtil.closeInputStream(fis);
            return false;
        }
        CloseUtil.closeWriter(bw);
        CloseUtil.closeOutputStream(fos);
        CloseUtil.closeReader(br);
        CloseUtil.closeInputStream(fis);
        return true;
    }

    public static String getFiletype(String fileName) {
        String type = "";
        if (fileName == null || fileName.equals("")) {
            return type;
        }
        int position = fileName.lastIndexOf(".");
        if (position != -1) {
            type = fileName.substring(position + 1, fileName.length());
        }
        return type;
    }

    public static void createTxtFile(File f) {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                LOG.error((Object)("error while create new file: " + f), (Throwable)e);
            }
            LOG.debug((Object)(f + "\u5df2\u521b\u5efa!"));
        } else {
            LOG.debug((Object)(f + "\u5df2\u5df2\u5b58\u5728!"));
        }
    }

    public static void out(File f, String str) {
        FileUtil.out(f, str, "");
    }

    public static void out(File f, String str, String enc) {
        if (StringHelper.isEmpty(enc)) {
            enc = FILE_ENCODE_UTF8;
        }
        FileOutputStream fos = null;
        OutputStreamWriter out = null;
        BufferedWriter writer = null;
        try {
            try {
                fos = new FileOutputStream(f, true);
                out = new OutputStreamWriter((OutputStream)fos, enc);
                writer = new BufferedWriter(out);
                writer.write(str);
                writer.newLine();
                writer.flush();
                LOG.debug((Object)("write str: " + str + " to file: " + f));
            }
            catch (IOException e) {
                LOG.error((Object)("error while write string: " + str + " to file: " + f), (Throwable)e);
                try {
                    if (writer != null) {
                        writer.close();
                        writer = null;
                    }
                    if (out != null) {
                        out.close();
                        out = null;
                    }
                }
                catch (IOException e2) {
                    LOG.error((Object)"error while close writer and out", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"error while close writer and out", (Throwable)e);
            }
        }
    }

    public static boolean isAllowedFileFormat(String fileName, String[] allowedFileFormat) {
        if (StringHelper.isEmpty(fileName)) {
            return false;
        }
        if (allowedFileFormat == null || allowedFileFormat.length == 0) {
            allowedFileFormat = StringHelper.split("jpg,jpeg,gif", ",");
        }
        String suffix = fileName.substring(fileName.indexOf(".") + 1);
        int i = 0;
        while (i < allowedFileFormat.length) {
            if (suffix.toLowerCase().endsWith(allowedFileFormat[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

