/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.TagUtils;

public class MessageTag
extends HtmlEscapingAwareTag {
    private String code;
    private String arguments;
    private String text;
    private String var;
    private String scope = "page";

    public void setCode(String code) {
        this.code = code;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected final int doStartTagInternal() throws JspException, IOException {
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        String resolvedCode = ExpressionEvaluationUtils.evaluateString("code", this.code, this.pageContext);
        String resolvedText = ExpressionEvaluationUtils.evaluateString("text", this.text, this.pageContext);
        String resolvedVar = ExpressionEvaluationUtils.evaluateString("var", this.var, this.pageContext);
        try {
            String msg = null;
            if (resolvedCode != null) {
                String resolvedArguments = ExpressionEvaluationUtils.evaluateString("arguments", this.arguments, this.pageContext);
                Object[] argumentsArray = StringUtils.commaDelimitedListToStringArray(resolvedArguments);
                msg = resolvedText != null ? messageSource.getMessage(resolvedCode, argumentsArray, resolvedText, this.getRequestContext().getLocale()) : messageSource.getMessage(resolvedCode, argumentsArray, this.getRequestContext().getLocale());
            } else {
                msg = resolvedText;
            }
            String string = msg = this.isHtmlEscape() ? HtmlUtils.htmlEscape(msg) : msg;
            if (resolvedVar != null) {
                String resolvedScope = ExpressionEvaluationUtils.evaluateString("scope", this.scope, this.pageContext);
                this.pageContext.setAttribute(resolvedVar, (Object)msg, TagUtils.getScope(resolvedScope));
            } else {
                this.writeMessage(msg);
            }
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
        return 1;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }
}

