/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class JstlUtils {
    public static final String REQUEST_SCOPE_SUFFIX = ".request";

    public static void exposeLocalizationContext(HttpServletRequest request, MessageSource messageSource) {
        Locale jstlLocale = RequestContextUtils.getLocale(request);
        MessageSourceResourceBundle bundle = new MessageSourceResourceBundle(messageSource, jstlLocale);
        LocalizationContext jstlContext = new LocalizationContext((ResourceBundle)bundle, jstlLocale);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext", (Object)jstlContext);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.locale", (Object)jstlLocale);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request", (Object)jstlContext);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", (Object)jstlLocale);
    }
}

