/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.Time;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSTime
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.Time");
    private Time _maxInclusive;
    private Time _maxExclusive;
    private Time _minInclusive;
    private Time _minExclusive;

    public XSTime() {
        super((short)4);
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public JType getJType() {
        return jType;
    }

    public Time getMaxExclusive() {
        return this._maxExclusive;
    }

    public Time getMaxInclusive() {
        return this._maxInclusive;
    }

    public Time getMinExclusive() {
        return this._minExclusive;
    }

    public Time getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(Time max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Time max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Time min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(Time min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSTime.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            try {
                if ("maxExclusive".equals(name)) {
                    this.setMaxExclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(name)) {
                    this.setMaxInclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(name)) {
                    this.setMinExclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(name)) {
                    this.setMinInclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(name)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for XSTime.");
            }
            catch (ParseException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("DateTimeValidator typeValidator = new DateTimeValidator();");
        if (this.hasMinimum()) {
            jsc.add("try {");
            jsc.indent();
            Time min = this.getMinExclusive();
            if (min != null) {
                jsc.add("org.exolab.castor.types.Time min =org.exolab.castor.types.Time.parseTime(\"" + min.toString() + "\");");
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("org.exolab.castor.types.Time min =org.exolab.castor.types.Time.parseTime(\"" + min.toString() + "\");");
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append("min");
            jsc.append(");");
            jsc.unindent();
            jsc.add("} catch (java.text.ParseException e) {");
            jsc.indent();
            jsc.add("System.out.println(e);");
            jsc.add("e.printStackTrace();");
            jsc.add("return;");
            jsc.unindent();
            jsc.add("}");
        }
        if (this.hasMaximum()) {
            jsc.add("try {");
            jsc.indent();
            Time max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("org.exolab.castor.types.Time max =org.exolab.castor.types.Time.parseTime(\"" + max.toString() + "\");");
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("org.exolab.castor.types.Time max =org.exolab.castor.types.Time.parseTime(\"" + max.toString() + "\");");
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append("max");
            jsc.append(");");
            jsc.unindent();
            jsc.add("} catch (java.text.ParseException e) {");
            jsc.indent();
            jsc.add("System.out.println(e);");
            jsc.add("e.printStackTrace();");
            jsc.add("return;");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

