/*
 * Decompiled with CFR 0.152.
 */
package com.trs.autodeploy.tools;

import com.trs.util.CMyDateTime;
import com.trs.util.CMyFile;
import com.trs.util.CMyString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class DbUpdSQLLogMaker {
    private static String sEndTime = null;
    private static final String ENCODING = "GBK";
    private BufferedWriter oraWriter = null;
    private BufferedWriter sqlWriter = null;
    private BufferedWriter sybWriter = null;
    private BufferedWriter db2Writer = null;
    private BufferedWriter mysqlWriter = null;

    public static void main(String[] args) {
        try {
            System.out.println("Start making SQL files...");
            int nParamNum = args.length;
            String sSQLFilePath = "/e:/work/tempfiles/";
            if (nParamNum > 0) {
                sSQLFilePath = args[0];
                sSQLFilePath = CMyString.setStrEndWith(sSQLFilePath, File.separatorChar);
            }
            String sStartTime = "2011-07-12 11:14:14";
            if (nParamNum > 1) {
                sStartTime = args[1];
            }
            int nVersion = 1096;
            if (nParamNum > 2) {
                nVersion = Integer.parseInt(args[2]);
            }
            String info = "1096.4update";
            if (nParamNum > 3) {
                info = args[3];
            }
            CMyDateTime now = CMyDateTime.now();
            sEndTime = now.toString();
            if (nParamNum > 4) {
                sEndTime = args[4];
            }
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            String url = "jdbc:jtds:sqlserver://192.9.200.145:1433/TRSWCM52_Developer";
            Connection conn = DriverManager.getConnection(url, "trswcm", "trs");
            DbUpdSQLLogMaker maker = new DbUpdSQLLogMaker(sSQLFilePath, "update");
            Statement stmt = conn.createStatement();
            String sql = "select logtitle,dbupdatelogid,submitor,oraclesql,sqlserver,sysbasesql,db2sql,crtime,mysql from WCMDBUPDATELOG where logproductor like 'TRS.WCM.V6.1%' and crtime>='#st' and crtime<='#et' and logproductor not in('TRS.WCM.V6.1.Infogate', 'TRS.WCM.V6.1.Interview','TRS.WCM.V6.1.Poll' )";
            sql = sql.replaceAll("#st", sStartTime);
            sql = sql.replaceAll("#et", sEndTime);
            ResultSet rs = stmt.executeQuery(sql);
            StringBuffer buff = new StringBuffer(128);
            CMyDateTime crtime = new CMyDateTime();
            while (rs.next()) {
                buff.append("--");
                buff.append(rs.getString(1));
                buff.append('-').append(rs.getInt(2));
                buff.append(" by ").append(rs.getString(3));
                crtime.setDateTimeWithTimestamp(rs.getTimestamp(8));
                buff.append(" @").append(crtime);
                maker.write(buff.toString(), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(9));
                buff.setLength(0);
            }
            maker.end(nVersion, info);
            System.out.println("Finish making SQL files");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DbUpdSQLLogMaker(String dir, String name) throws Exception {
        File file = new File(String.valueOf(dir) + "oracle", String.valueOf(name) + ".sql");
        if (!file.exists()) {
            CMyFile.writeFile(file.getAbsolutePath(), "", ENCODING);
        }
        this.oraWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        file = new File(String.valueOf(dir) + "sqlserver", String.valueOf(name) + ".sql");
        if (!file.exists()) {
            CMyFile.writeFile(file.getAbsolutePath(), "", ENCODING);
        }
        this.sqlWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        file = new File(String.valueOf(dir) + "sybase", String.valueOf(name) + ".sql");
        if (!file.exists()) {
            CMyFile.writeFile(file.getAbsolutePath(), "", ENCODING);
        }
        this.sybWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        file = new File(String.valueOf(dir) + "db2", String.valueOf(name) + ".sql");
        if (!file.exists()) {
            CMyFile.writeFile(file.getAbsolutePath(), "", ENCODING);
        }
        this.db2Writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        file = new File(String.valueOf(dir) + "mysql", String.valueOf(name) + ".sql");
        if (!file.exists()) {
            CMyFile.writeFile(file.getAbsolutePath(), "", ENCODING);
        }
        this.mysqlWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
    }

    public void write(String title, String ora, String mssql, String sybase, String db2, String mysql) throws Exception {
        this.write(this.oraWriter, title, ora);
        this.write(this.sqlWriter, title, mssql);
        this.write(this.sybWriter, title, sybase);
        this.write(this.db2Writer, title, db2);
        this.write(this.mysqlWriter, title, mysql);
    }

    private void write(BufferedWriter writer, String title, String sql) throws Exception {
        writer.write(title);
        writer.write("\n");
        writer.write(this.showNull(sql));
        writer.write("\n\n");
        writer.flush();
    }

    private String showNull(String string) {
        return string != null ? string : "-- Not provided?";
    }

    public void end(int version, String info) throws Exception {
        String sUpdTime = sEndTime;
        if (sUpdTime == null) {
            CMyDateTime now = CMyDateTime.now();
            sUpdTime = now.toString();
        }
        String sql = "\nINSERT INTO WCMDBUPDATE (UPDVERSION, UPDINFO, UPDUSER, UPDTIME)\n";
        sql = String.valueOf(sql) + "VALUES (" + version;
        sql = String.valueOf(sql) + ", '" + info + "', 'WCM Team',";
        this.oraWriter.write(String.valueOf(sql) + "to_date('" + sUpdTime + "','yyyy-MM-dd HH24:MI:SS'));");
        this.sqlWriter.write(String.valueOf(sql) + "'" + sUpdTime + "');");
        this.sybWriter.write(String.valueOf(sql) + "'" + sUpdTime + "');");
        this.db2Writer.write(String.valueOf(sql) + "'" + sUpdTime + "');");
        this.mysqlWriter.write(String.valueOf(sql) + "'" + sUpdTime + "');");
        this.close(this.oraWriter);
        this.close(this.sqlWriter);
        this.close(this.sybWriter);
        this.close(this.db2Writer);
        this.close(this.mysqlWriter);
    }

    private void close(Writer writer) {
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void makeSQLLog(String _sStartTime, int _nVersion, String _sInfo) throws Exception {
        try {
            System.out.println("Start making SQL files...");
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            String url = "jdbc:jtds:sqlserver://192.9.200.145:1433/TRSWCM52_Developer";
            Connection conn = DriverManager.getConnection(url, "trswcm", "trs");
            Statement stmt = conn.createStatement();
            String sql = "select logtitle,dbupdatelogid,submitor,oraclesql,sqlserver,sysbasesql,db2sql,crtime,mysql from WCMDBUPDATELOG where logproductor like 'TRS.WCM.V6.1%' and crtime>='#t'";
            ResultSet rs = stmt.executeQuery(sql.replaceAll("#t", _sStartTime));
            StringBuffer buff = new StringBuffer(128);
            CMyDateTime crtime = new CMyDateTime();
            while (rs.next()) {
                buff.append("--");
                buff.append(rs.getString(1));
                buff.append('-').append(rs.getInt(2));
                buff.append(" by ").append(rs.getString(3));
                crtime.setDateTimeWithTimestamp(rs.getTimestamp(8));
                buff.append(" @").append(crtime);
                this.write(buff.toString(), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(9));
                buff.setLength(0);
            }
            this.end(_nVersion, _sInfo);
            System.out.println("Finish making SQL files");
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6SQL\u811a\u672c\u5931\u8d25", e);
        }
    }
}

