/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.video.VSConfig;
import com.trs.components.video.VideoInfo;
import com.trs.components.video.content.VideoDoc;
import com.trs.components.video.persistent.XVideo;
import com.trs.components.video.util.HttpAPIClient;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.dl.util.Duration;
import com.trs.dl.util.LangUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoDocUtil {
    private static final Logger LOG;
    private static final String ATTRNAME_TOKEN = "TOKEN";
    private static final String ATTRNAME_DURATION = "DURATION";
    private static final String ATTRNAME_WIDTH = "WIDTH";
    private static final String ATTRNAME_HEIGHT = "HEIGHT";
    private static final String ATTRNAME_FPS = "FPS";
    private static final String ATTRNAME_BITRATE = "BITRATE";
    private static final String ATTRNAME_THUMB_URL = "THUMB";
    private static final String ATTRNAME_CONVERTED = "CONVERTED";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.VideoDocUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public static String findExtPropertyById(int docId, String propName) throws WCMException {
        Document doc = Document.findById((int)docId);
        return VideoDocUtil.getExtPropertyValue(doc, propName);
    }

    private static String getExtPropertyValue(Document doc, String propName) {
        if (doc == null) {
            return null;
        }
        return doc.getAttributeValue(propName);
    }

    private static String getExtPropertyValue(ViewDocument doc, String propName) {
        if (doc == null) {
            return null;
        }
        return doc.getAttributeValue(propName);
    }

    private static String getExtPropertyValue(VideoDoc doc, String propName) {
        if (doc == null) {
            return null;
        }
        return doc.getAttributeValue(propName);
    }

    public static String getTokenById(int docId) throws WCMException {
        return VideoDocUtil.findExtPropertyById(docId, ATTRNAME_TOKEN);
    }

    public static String getThumbUrlById(int docId) throws WCMException {
        return VideoDocUtil.findExtPropertyById(docId, ATTRNAME_THUMB_URL);
    }

    public static String getVideoToken(Document doc) {
        return VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_TOKEN);
    }

    public static String getDuration(Document doc) {
        return VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_DURATION);
    }

    public static String getReadableDuration(Document doc) {
        String propertyValue = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_DURATION);
        return VideoDocUtil.getReadbleDurationByString(propertyValue);
    }

    public static String getReadbleDurationByString(String propertyValue) {
        try {
            Duration duration = new Duration(propertyValue);
            return duration.defaultShow();
        }
        catch (IllegalArgumentException e) {
            return "0";
        }
    }

    public static String getReadbleDurationByInt(int propertyValue) {
        try {
            Duration duration = new Duration(propertyValue);
            return duration.defaultShow();
        }
        catch (IllegalArgumentException e) {
            return "0";
        }
    }

    public static String getThumbUrl(Document doc) {
        return VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_THUMB_URL);
    }

    public static VideoInfo buildVideoInfo(Document doc) {
        VideoInfo vInfo = new VideoInfo();
        vInfo.token = VideoDocUtil.getVideoToken(doc);
        vInfo.duration = VideoDocUtil.getDuration(doc);
        vInfo.thumbName = VideoDocUtil.getThumbUrl(doc);
        vInfo.creationType = VideoDocUtil.getExtPropertyValue(doc, "TYPE");
        String converted = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_CONVERTED);
        vInfo.converted = converted == null || converted.length() == 0;
        vInfo.convertFailed = "-1".equals(converted);
        return vInfo;
    }

    public static VideoInfo buildVideoInfo(ViewDocument doc) {
        VideoInfo vInfo = new VideoInfo();
        vInfo.token = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_TOKEN);
        vInfo.duration = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_DURATION);
        vInfo.thumbName = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_THUMB_URL);
        vInfo.creationType = VideoDocUtil.getExtPropertyValue(doc, "TYPE");
        String converted = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_CONVERTED);
        vInfo.converted = converted == null || converted.length() == 0;
        vInfo.convertFailed = "-1".equals(converted);
        return vInfo;
    }

    public static VideoInfo buildVideoInfo(VideoDoc doc) {
        VideoInfo vInfo = new VideoInfo();
        vInfo.token = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_TOKEN);
        vInfo.duration = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_DURATION);
        vInfo.thumbName = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_THUMB_URL);
        vInfo.creationType = VideoDocUtil.getExtPropertyValue(doc, "TYPE");
        String converted = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_CONVERTED);
        vInfo.converted = converted == null || converted.length() == 0;
        vInfo.convertFailed = "-1".equals(converted);
        return vInfo;
    }

    public String refetchMetadataInfo(int docId) throws WCMException {
        String token = VideoDocUtil.getTokenById(docId);
        return this.refetchMetadata(token);
    }

    public String refetchMetadata(String token) {
        String string = null;
        try {
            string = HttpAPIClient.getURLContent(null, String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/query?v=" + token + "&option=metadata");
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.VideoDocUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"VideoDocUtil.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + VSConfig.getUploadJavaAppIntranetUrl() + "/service/query?v=" + token + "&option=metadata"));
            e.printStackTrace();
        }
        return string;
    }

    static boolean isConvertingDone(Document doc) {
        String converted = VideoDocUtil.getExtPropertyValue(doc, ATTRNAME_CONVERTED);
        return !"0".equals(converted);
    }

    public static String queryConvertStatus(String token) {
        String url = String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/query?v=" + token + "&option=convert";
        String string = null;
        try {
            string = HttpAPIClient.getURLContent(null, url);
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.VideoDocUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.error((Object)(String.valueOf(I18NMessage.get((Class)clazz, (String)"VideoDocUtil.label1", (String)"http\u8bf7\u6c42\u5931\u8d25\uff0curl\u662f")) + url));
            e.printStackTrace();
        }
        return string;
    }

    public static String updateTranscodeStatus(String srcFilename, int docId) throws Exception {
        XVideo xvideoUpdated = XVideo.findByDocIdAndQuality(docId, 0);
        if (xvideoUpdated == null) {
            return null;
        }
        XVideo xvideoNewed = XVideo.findByDocIdAndQuality(docId, 1);
        List xVideoList = XVideo.findXVideosByDocId(docId);
        String result = null;
        StringBuffer urlSb = new StringBuffer(String.valueOf(VSConfig.getUploadJavaAppIntranetUrl()) + "/service/query?v=");
        if (xvideoUpdated.getParentId() != 0) {
            urlSb.append(xvideoUpdated.getFileName());
            if (xvideoNewed != null) {
                urlSb.append("_s_").append(xvideoNewed.getFileName());
            }
            urlSb.append("&option=cut");
        } else {
            urlSb.append(srcFilename).append("&option=transcode");
        }
        result = HttpAPIClient.getURLContent(null, urlSb.toString());
        if ("".equalsIgnoreCase(result) || result == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.VideoDocUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMDatainvalidException(300000, I18NMessage.get((Class)clazz, (String)"VideoDocUtil.label2", (String)"\u65e0\u6cd5\u8bbf\u95eeMAS\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684MAS\u662f\u5426\u5f00\u542f"));
        }
        JSONArray jAry = new JSONArray(result);
        JSONObject json = jAry.getJSONObject(0);
        try {
            switch (json.getInt("CONVERT_STATUS")) {
                case 0: {
                    break;
                }
                case 1: {
                    json = jAry.getJSONObject(1);
                    VideoDocUtil.addOrUpdateXVideoWithJson(xvideoUpdated, json);
                    StringBuffer sb = new StringBuffer(xvideoUpdated.getFileName()).append(';');
                    if (jAry.length() == 3) {
                        json = jAry.getJSONObject(2);
                        if (xvideoNewed == null) {
                            xvideoNewed = xvideoUpdated;
                            xvideoNewed.setAddMode(true);
                            xvideoNewed.setXVideoId(0);
                        }
                        VideoDocUtil.addOrUpdateXVideoWithJson(xvideoNewed, json);
                        sb.append(xvideoNewed.getFileName()).append(';');
                    }
                    json.remove("FILENAME");
                    json.append("FILENAME", (Object)sb.toString());
                    break;
                }
                case -1: {
                    xvideoUpdated.setConvertStatus(-1);
                    xvideoUpdated.save();
                    if (xvideoNewed != null) {
                        xvideoNewed.setConvertStatus(-1);
                        xvideoNewed.save();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (xVideoList != null && xVideoList.size() != 0) {
                        int i = 0;
                        while (i < xVideoList.size()) {
                            XVideo x = (XVideo)((Object)xVideoList.get(i));
                            x.setConvertStatus(3);
                            x.save();
                            ++i;
                        }
                    }
                    StringBuffer fileNamesForPlayer = new StringBuffer(xvideoUpdated.getFileName()).append(';');
                    if (xvideoNewed != null) {
                        xvideoNewed.setConvertStatus(3);
                        xvideoNewed.save();
                        fileNamesForPlayer.append(xvideoNewed.getFileName()).append(';');
                    }
                    json.append("FILENAME", (Object)fileNamesForPlayer.toString());
                    json.append(ATTRNAME_THUMB_URL, (Object)xvideoUpdated.getThumb());
                    break;
                }
                case -3: 
                case -2: {
                    xvideoUpdated.setConvertStatus(-2);
                    xvideoUpdated.save();
                    if (xvideoNewed == null) break;
                    xvideoNewed.setConvertStatus(-2);
                    xvideoNewed.save();
                }
                default: {
                    break;
                }
            }
        }
        catch (JSONException e) {
            LOG.debug((Object)("cut process fail!json=" + json));
        }
        return json.toString();
    }

    private static void addOrUpdateXVideoWithJson(XVideo xvideo, JSONObject json) throws WCMException, JSONException {
        xvideo.setConvertStatus(1);
        xvideo.setFileName(json.getString("FILENAME"));
        xvideo.setThumb(json.getString(ATTRNAME_THUMB_URL));
        xvideo.setBitrate(json.getInt(ATTRNAME_BITRATE));
        xvideo.setQuality(json.getInt("QUALITY"));
        xvideo.save(ContextHelper.getLoginUser());
    }

    public boolean hasNoMetadata(int docId) throws WCMException {
        Document doc = Document.findById((int)docId);
        return VideoDocUtil.hasNoMetadata(doc);
    }

    public static boolean hasNoMetadata(Document doc) {
        if (doc == null || "".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_TOKEN)))) {
            return false;
        }
        if ("".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_DURATION)))) {
            return true;
        }
        if ("".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_FPS)))) {
            return true;
        }
        if ("".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_WIDTH)))) {
            return true;
        }
        if ("".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_HEIGHT)))) {
            return true;
        }
        return "".equals(LangUtil.avoidNull((String)doc.getAttributeValue(ATTRNAME_BITRATE)));
    }

    public void appendMetadataToAttribute(int docId, String appendMetaStr, String token) throws WCMException {
        Document doc = Document.findById((int)docId);
        String originAttr = doc.getAttribute();
        LOG.info((Object)("originAttr=" + originAttr + ". appendMetaStr=" + appendMetaStr));
        if (originAttr == null || originAttr.trim().length() == 0) {
            doc.setAttribute("token=" + token + "&" + appendMetaStr);
        } else {
            doc.setAttribute(String.valueOf(originAttr) + "&" + appendMetaStr);
        }
        doc.update();
        LOG.info((Object)("doc.update() ok! docId=" + docId + ", newAttr=" + doc.getAttribute()));
    }

    public static void removeConvertingFlag(int docId, String token) throws WCMException {
        Document doc = Document.findById((int)docId);
        if (doc == null) {
            throw new NullPointerException("doc is null! docId=[" + docId + "]");
        }
        String originAttr = doc.getAttribute();
        if (originAttr == null) {
            return;
        }
        String afterRemove = VideoDocUtil.removeKeyFromAttr(originAttr, ATTRNAME_CONVERTED);
        if (afterRemove.length() == originAttr.length()) {
            return;
        }
        DBManager dbMgr = DBManager.getDBManager();
        String[] pUpdateSQL = new String[]{"update WCMDOCUMENT set ATTRIBUTE=? where DOCID=?"};
        Object[] pParameters = new Object[]{afterRemove, new Integer(docId)};
        dbMgr.sqlExecuteUpdate(pUpdateSQL, pParameters);
        LOG.info((Object)("update ok! docId=" + docId + ", originAttr: " + originAttr + ". afterRemove: " + afterRemove));
    }

    public static void updateConvertingFlag(int docId, String token, String convertDone) throws WCMException {
        if (convertDone == null || "1".equals(convertDone)) {
            VideoDocUtil.removeConvertingFlag(docId, token);
            return;
        }
        Document doc = Document.findById((int)docId);
        if (doc == null) {
            throw new NullPointerException("doc is null! docId=[" + docId + "]");
        }
        doc.setAttribute(ATTRNAME_CONVERTED, "-1");
        doc.update();
    }

    public static void updateConvertStatus(int docId, String convertDone) throws WCMException {
        XVideo xvideo;
        if (convertDone == null) {
            convertDone = "1";
        }
        if ((xvideo = XVideo.findByDocIdAndQuality(docId, 0)) == null) {
            throw new NullPointerException("xvideo is null! docId=[" + docId + "]");
        }
        xvideo.setConvertStatus(Integer.parseInt(convertDone));
        xvideo.setAddMode(false);
        xvideo.save();
    }

    static String removeKeyFromAttr(String originAttr, String removeKey) {
        if (originAttr == null || originAttr.trim().length() == 0) {
            return originAttr;
        }
        if (removeKey == null || removeKey.trim().length() == 0) {
            return originAttr;
        }
        int startPos = originAttr.indexOf(String.valueOf(removeKey) + "=");
        if (startPos < 0) {
            return originAttr;
        }
        int endPos = originAttr.indexOf(38, startPos);
        if (startPos == 0) {
            return originAttr.substring(endPos + 1);
        }
        if (endPos == -1) {
            return originAttr.substring(0, startPos - 1);
        }
        return String.valueOf(originAttr.substring(0, startPos - 1)) + originAttr.substring(endPos);
    }

    void saveMetadata(int docId, String jsonMetaStr) throws WCMException {
        Document doc = Document.findById((int)docId);
        doc.setAttribute("duration", "");
        doc.update();
    }

    private static String getHttpContent(String strUrl) {
        StringBuffer buf = new StringBuffer(128);
        try {
            String str;
            URL url = new URL(strUrl);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = in.readLine()) != null) {
                buf.append(str);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        VideoDocUtil.getHttpContent("http://192.9.200.10:8080/fma/service/query?v=111c0b38612");
        VideoDocUtil.getHttpContent("http://192.9.200.10:8080/fma/service/query?v=none");
    }

    public static String getDocInfo(Document document) {
        if (document == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("id:").append(document.getId()).append("; ");
        sb.append("docId:").append(document.getDocId()).append("; ");
        sb.append("channelId:").append(document.getChannelId()).append("; ");
        sb.append("crTime:").append(document.getCrTime()).append("; ");
        sb.append("crUser:").append(document.getCrUser()).append("; ");
        sb.append("cacheIndex:").append(document.getCacheIndex()).append("; ");
        sb.append("key:").append(document.getKey()).append("; ");
        sb.append("attribute:").append(document.getAttribute()).append("; ");
        return sb.toString();
    }

    public static Document[] findDocsWithDownloadLinks(User loginUser, String docIds) throws WCMException {
        if (docIds == null) {
            return new Document[0];
        }
        docIds = docIds.trim();
        Document[] arrDoc = VideoDocUtil.findDocsByIds(loginUser, docIds);
        boolean _bCheckPropValid = false;
        int i = 0;
        while (i < arrDoc.length) {
            Document doc = arrDoc[i];
            doc.setProperty("_DownloadURL", (Object)(String.valueOf(VSConfig.getDownloadHomeUrl()) + VideoDocUtil.getVideoToken(doc) + ".flv"), _bCheckPropValid);
            ++i;
        }
        return arrDoc;
    }

    public static String getDownloadURLfromEnhancedDocument(Document doc) {
        if (doc == null) {
            return "doc is NULL!";
        }
        return (String)doc.getNewProperty("_DownloadURL");
    }

    public static String getXVideoDownloadURL(Document doc) throws WCMException {
        if (doc == null) {
            return "doc is NULL!";
        }
        int docId = doc.getId();
        XVideo xvideo = XVideo.findByDocIdAndQuality(docId, 0);
        return String.valueOf(VSConfig.getDownloadHomeUrl()) + xvideo.getFileName();
    }

    private static Document[] findDocsByIds(User loginUser, String docIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "DocId in (" + docIds + ")", "", "DocId,DocTitle,ATTRIBUTE,CrUser,CrTime,DocChannel");
        Documents docs = Documents.openWCMObjs((User)loginUser, (WCMFilter)filter);
        if (docs == null) {
            throw new WCMException("Documents.openWCMObjs return null!");
        }
        int size = docs.size();
        Document[] arrDoc = new Document[size];
        int i = 0;
        while (i < size) {
            BaseObj obj = docs.getAt(i);
            if (!(obj instanceof Document)) {
                throw new WCMException("Documents.openWCMObjs returned object in baseObjs is not a Document, it's a [" + (obj == null ? "null" : obj.getClass().getName()) + "]!");
            }
            arrDoc[i] = (Document)obj;
            ++i;
        }
        return arrDoc;
    }
}

